/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.truck.details;

import ch.icit.pegasus.client.converter.TruckTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.LocationUtil;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ILocalizedDTO;
import ch.icit.pegasus.server.core.dtos.tracking.TruckComplete;
import ch.icit.pegasus.server.core.dtos.tracking.TruckComplete_;
import ch.icit.pegasus.server.core.dtos.tracking.TruckTypeComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class BasicDetailsPanel
extends DefaultDetailsPanel<TruckComplete> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDTextField> matriculation;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TitledItem<RDComboBox> truckType;
    private TitledItem<RDTextField> sealCount;

    public BasicDetailsPanel(RowEditor<TruckComplete> editor, RDProvider provider) {
        super(editor, provider);
        this.setTitleText(Words.BASIC_DATA);
        this.matriculation = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.NORMAL), Words.MATRICULATION_NUMBER, TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.truckType = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(TruckTypeConverter.class)), Words.TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.sealCount = new TitledItem<RDTextField>(new RDTextField(provider, TextFieldType.INT), "Seal Count", TitledItem.TitledItemOrientation.NORTH);
        this.setCustomLayouter(new Layout());
        this.addToView(this.matriculation);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
        this.addToView(this.truckType);
        this.addToView(this.sealCount);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.matriculation.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        if (this.matriculation.getElement().isWritable() && (this.editor.getModel().getNode().getChildNamed(TruckComplete_.matriculation).getValue() == null || this.editor.getModel().getNode().getChildNamed(TruckComplete_.matriculation).getValue().equals(""))) {
            this.matriculation.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_MATRICULATION_IS_SET));
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations.getElement().isWritable() && this.locations.getElement().getNode().getChildCount() < 1) {
            this.locations.getElement().setInvalid();
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_LOCATION_IS_SET));
        }
        return validationObjects;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.matriculation.setEnabled(isEnabled);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(isEnabled);
        }
        this.truckType.setEnabled(isEnabled);
        this.sealCount.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.matriculation.kill();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.truckType.kill();
        this.sealCount.kill();
        this.matriculation = null;
        this.locations = null;
        this.truckType = null;
        this.sealCount = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.matriculation);
        CheckedListAdder.addToList(focusList, this.truckType);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.sealCount);
        return focusList;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        if (this.editor.getModel().isAddRow()) {
            TruckComplete dto = (TruckComplete)node.getValue();
            LocationUtil.ensureCurrentLocation((ILocalizedDTO)dto);
        }
        this.matriculation.getElement().setNode(node.getChildNamed(TruckComplete_.matriculation));
        this.truckType.getElement().setNode(node.getChildNamed(TruckComplete_.truckType));
        this.truckType.getElement().refreshPossibleValues(NodeToolkit.getAffixList(TruckTypeComplete.class));
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(node.getChildNamed(TruckComplete_.eligibleLocations));
        }
        this.sealCount.getElement().setNode(node.getChildNamed(TruckComplete_.sealCount));
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = BasicDetailsPanel.this.verticalBorder;
            h = (int)((double)h + BasicDetailsPanel.this.matriculation.getPreferredSize().getHeight());
            h += BasicDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + BasicDetailsPanel.this.truckType.getPreferredSize().getHeight());
            if (Boolean.TRUE.equals(BasicDetailsPanel.this.viewSettings.getShowLocation())) {
                h += BasicDetailsPanel.this.inner_verticalBorder;
                h = (int)((double)h + BasicDetailsPanel.this.locations.getPreferredSize().getHeight());
            }
            h += BasicDetailsPanel.this.verticalBorder;
            h = (int)((double)h + BasicDetailsPanel.this.sealCount.getPreferredSize().getHeight());
            return new Dimension(0, h += BasicDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            BasicDetailsPanel.this.matriculation.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.verticalBorder);
            BasicDetailsPanel.this.matriculation.setSize(parent.getWidth() - 2 * BasicDetailsPanel.this.horizontalBorder, (int)BasicDetailsPanel.this.matriculation.getPreferredSize().getHeight());
            BasicDetailsPanel.this.truckType.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.matriculation.getY() + BasicDetailsPanel.this.matriculation.getHeight() + BasicDetailsPanel.this.inner_verticalBorder);
            BasicDetailsPanel.this.truckType.setSize(200, ((BasicDetailsPanel)BasicDetailsPanel.this).truckType.getPreferredSize().height);
            BasicDetailsPanel.this.sealCount.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.truckType.getY() + BasicDetailsPanel.this.truckType.getHeight() + BasicDetailsPanel.this.inner_verticalBorder);
            BasicDetailsPanel.this.sealCount.setSize(200, ((BasicDetailsPanel)BasicDetailsPanel.this).sealCount.getPreferredSize().height);
            if (Boolean.TRUE.equals(BasicDetailsPanel.this.viewSettings.getShowLocation())) {
                BasicDetailsPanel.this.locations.setLocation(BasicDetailsPanel.this.horizontalBorder, BasicDetailsPanel.this.sealCount.getY() + BasicDetailsPanel.this.sealCount.getHeight() + BasicDetailsPanel.this.inner_verticalBorder);
                BasicDetailsPanel.this.locations.setSize(BasicDetailsPanel.this.locations.getPreferredSize());
            }
        }
    }
}

