/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.screentemplates.details;

import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.PageableTable2;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.StockTransactionSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.search.StockTransactionSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public abstract class PagedTableDetailsPanel<T extends IDTO>
extends DefaultDetailsPanel<T> {
    private int overridePrefHeight = 260;
    protected PageableTable2 table;

    public PagedTableDetailsPanel(RowEditor<T> editor, RDProvider provider) {
        this(editor, provider, true);
    }

    public PagedTableDetailsPanel(RowEditor<T> editor, RDProvider provider, boolean withAddButton) {
        this(editor, provider, true, true, false, withAddButton);
    }

    public PagedTableDetailsPanel(RowEditor<T> editor, RDProvider provider, boolean hasTitle, boolean hasSkin, boolean hasExpand, boolean withAddButton) {
        super(editor, provider, hasTitle, hasSkin, hasExpand);
        this.installTable();
    }

    public Table2Model createNewTableModel(List<TableColumnInfo> columns) {
        return new Table2Model(columns, true);
    }

    private void installTable() {
        this.table = new PageableTable2(Words.TABLE_ADD, false, false, false){

            @Override
            public void fillFilterChain() {
            }

            @Override
            public ASearchConfiguration<? extends ADTO, ? extends Enum<?>> filterValueChanged(String id, Object value) {
                StockTransactionSearchConfiguration configuration = new StockTransactionSearchConfiguration();
                configuration.setCharge((ArticleChargeReference)PagedTableDetailsPanel.this.editor.getModel().getNode().getValue(ArticleChargeReference.class));
                return configuration;
            }

            @Override
            public SearchAlgorithm getSearchAlgorithm() {
                return SearchAlgorithmRegistry.getSearchAlgorithm(StockTransactionSearchAlgorithm.class);
            }
        };
        this.table.setProvider(this.provider);
        List<TableColumnInfo> headers = this.getColumns(this.editor.getModel().isAddRow());
        Table2Model tableModel = this.createNewTableModel(headers);
        tableModel.setViewFactory(model -> this.generateView(model, false));
        this.table.setModel(tableModel);
        this.lafAttributeChanged("All attribues changed");
        this.configTable(this.table);
        this.setCustomLayouter(new Layout());
        this.addToView(this.table);
    }

    public abstract List<TableColumnInfo> getColumns(boolean var1);

    public abstract void configTable(Table2 var1);

    public abstract void addButtonPressed(int var1, int var2, Button var3);

    public abstract void childRemoved();

    public abstract Table2RowPanel generateView(Table2RowModel var1, boolean var2);

    public Table2 getTable() {
        return this.table;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.table.setLocked(isEnabled);
    }

    public void setOverridePrefHeight(int overridePrefHeight) {
        this.overridePrefHeight = overridePrefHeight;
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        super.addFocusCycleChangeListener(listener);
        this.table.getModel().addFocusCycleChangeListener(listener);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.table.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.table);
        return a;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
    }

    public Dimension calculateContainerPreferredSize() {
        return new Dimension(260, this.overridePrefHeight != -1 ? this.overridePrefHeight : (int)(this.table.getPreferredSize().getHeight() + 2.0));
    }

    public void layoutContainer(Container parent) {
        this.table.setLocation(0, 0);
        this.table.setSize(parent.getWidth(), parent.getHeight());
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            PagedTableDetailsPanel.this.layoutContainer(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return PagedTableDetailsPanel.this.calculateContainerPreferredSize();
        }
    }
}

