/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.kitchenops;

import ch.icit.pegasus.client.converter.FlightCategoryConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.batch.impl.FlightPrintBatch;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserPopup;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBox;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.DailyOpsSheetTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.IFlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.AirportComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.SearchReportConfiguration;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;

public class PrintKitchenDailyOpsComponent<T extends IFlightReference>
extends DefaultScrollablePrintPopup2<T> {
    private static final long serialVersionUID = 1L;
    protected TextLabel options;
    protected TitledItem<CheckBox> includePlannedFlights;
    protected TitledItem<CheckBox> groupOutboundMeals;
    protected TitledItem<CheckBox> hideFromToNSDS;
    protected TitledItem<CheckBox> useChronology;
    protected TitledItem<CheckBox> addSpaces;
    protected TitledItem<CheckBox> includeAdditionals;
    protected TitledItem<DateChooserPopup> dateChooser;
    protected TitledDateTimePeriodChooser dateTimeChooser;
    protected TitledItem<SearchComboBox> customer;
    protected TitledItem<ComboBox> category;
    protected Date selectedDate;
    private TitledItem<SearchTextField2<AirportComplete>> deliveryAirport;
    private final boolean withTime;

    public PrintKitchenDailyOpsComponent(Date date, boolean withTime) {
        super(true, true, false, false, ReportTypeE.KITCHEN_DAILY_OPS);
        this.selectedDate = date;
        this.withTime = withTime;
    }

    @Override
    public void insertElements() {
        this.createComponents();
        Font tf = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type"));
        Color tfc = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground"));
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.deliveryAirport = new TitledItem<SearchTextField2<AirportComplete>>(SearchTextField2Factory.getAirportSearchField(true, new DTOProxyNode()), Words.DELIVERY_AIRPORT, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryAirport.setTitleFont(f);
        this.deliveryAirport.setTitleForeground(fb);
        this.options = new TextLabel(Words.OPTIONS);
        this.options.setFont(tf);
        this.options.setForeground(tfc);
        this.includePlannedFlights = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_PLANNED_FLIGHTS, TitledItem.TitledItemOrientation.EAST);
        this.includePlannedFlights.setTitleFont(f);
        this.includePlannedFlights.setTitleForeground(fb);
        this.groupOutboundMeals = new TitledItem<CheckBox>(new CheckBox(), Words.GROUP_MEALS, TitledItem.TitledItemOrientation.EAST);
        this.groupOutboundMeals.setTitleFont(f);
        this.groupOutboundMeals.setTitleForeground(fb);
        this.hideFromToNSDS = new TitledItem<CheckBox>(new CheckBox(), Words.HIDE_FLIGHTS_FORM_NS_DS, TitledItem.TitledItemOrientation.EAST);
        this.hideFromToNSDS.setTitleFont(f);
        this.hideFromToNSDS.setTitleForeground(fb);
        this.useChronology = new TitledItem<CheckBox>(new CheckBox(), Words.SHOW_FLIGHTS_CHRONO, TitledItem.TitledItemOrientation.EAST);
        this.useChronology.setTitleFont(f);
        this.useChronology.setTitleForeground(fb);
        this.addSpaces = new TitledItem<CheckBox>(new CheckBox(), Words.ADD_ADDITIONAL_SPACE, TitledItem.TitledItemOrientation.EAST);
        this.addSpaces.setTitleFont(f);
        this.addSpaces.setTitleForeground(fb);
        this.includeAdditionals = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ADDITIONALS, TitledItem.TitledItemOrientation.EAST);
        this.includeAdditionals.setTitleFont(f);
        this.includeAdditionals.setTitleForeground(fb);
        if (this.withTime) {
            Calendar cal = TimeUtil.createCalendar();
            cal.setTime(this.selectedDate);
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            Timestamp s = new Timestamp(cal.getTimeInMillis());
            cal.add(5, 1);
            Timestamp e = new Timestamp(cal.getTimeInMillis());
            this.dateTimeChooser = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)new TimestampPeriodComplete(s, e), false, false));
            this.getViewContainer().add(this.dateTimeChooser);
        } else {
            this.dateChooser = new TitledItem<DateChooserPopup>(new DateChooserPopup(this.selectedDate), Words.OPS_DATE, TitledItem.TitledItemOrientation.NORTH);
            this.dateChooser.getElement().enableSkin(true);
            this.getViewContainer().add(this.dateChooser);
        }
        this.customer = new TitledItem<SearchComboBox>(SearchComboBoxFactory.getCustomerSearchField(true, new DTOProxyNode()), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.category = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(FlightCategoryComplete.class), ConverterRegistry.getConverter(FlightCategoryConverter.class), true), Words.CATEGORY, TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.options);
        this.getViewContainer().add(this.includePlannedFlights);
        this.getViewContainer().add(this.groupOutboundMeals);
        this.getViewContainer().add(this.hideFromToNSDS);
        this.getViewContainer().add(this.useChronology);
        this.getViewContainer().add(this.customer);
        this.getViewContainer().add(this.addSpaces);
        this.getViewContainer().add(this.includeAdditionals);
        this.getViewContainer().add(this.category);
        this.getViewContainer().add(this.deliveryAirport);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.options.setVisible(true);
        this.customer.setVisible(true);
        if (this.withTime) {
            this.dateTimeChooser.setVisible(true);
        } else {
            this.dateChooser.setVisible(true);
        }
        this.groupOutboundMeals.setVisible(true);
        this.hideFromToNSDS.setVisible(true);
        this.useChronology.setVisible(true);
        this.includePlannedFlights.setVisible(true);
        this.addSpaces.setVisible(true);
        this.includeAdditionals.setVisible(true);
        this.category.setVisible(true);
        this.deliveryAirport.setVisible(true);
    }

    @Override
    public String getTitleString() {
        return Words.DAILY_OPS;
    }

    @Override
    public String getTitleValue() {
        return Words.ALL_FLIGHTS;
    }

    @Override
    protected String getProgressText() {
        return Words.PRINT_KITCHEN_OPS;
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[3];
        return o;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.includePlannedFlights);
        CheckedListAdder.addToList(focusList, this.groupOutboundMeals);
        CheckedListAdder.addToList(focusList, this.hideFromToNSDS);
        CheckedListAdder.addToList(focusList, this.useChronology);
        CheckedListAdder.addToList(focusList, this.addSpaces);
        CheckedListAdder.addToList(focusList, this.includeAdditionals);
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.category);
        if (this.withTime) {
            CheckedListAdder.addToList(focusList, this.dateTimeChooser);
        } else {
            CheckedListAdder.addToList(focusList, this.dateChooser);
        }
        CheckedListAdder.addToList(focusList, this.deliveryAirport);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.options.kill();
        this.options = null;
        this.includePlannedFlights.kill();
        this.includePlannedFlights = null;
        this.groupOutboundMeals.kill();
        this.groupOutboundMeals = null;
        this.hideFromToNSDS.kill();
        this.hideFromToNSDS = null;
        this.deliveryAirport.kill();
        this.deliveryAirport = null;
        this.useChronology.kill();
        this.useChronology = null;
        this.addSpaces.kill();
        this.addSpaces = null;
        this.includeAdditionals.kill();
        this.includeAdditionals = null;
        if (this.withTime) {
            this.dateTimeChooser.kill();
            this.dateTimeChooser = null;
        } else {
            this.dateChooser.kill();
            this.dateChooser = null;
        }
        this.customer.kill();
        this.customer = null;
        this.category.kill();
        this.category = null;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        boolean innerComponent;
        if (this.customer != null && (innerComponent = this.customer.isInnerComponent(c))) {
            return true;
        }
        if (this.deliveryAirport != null && (innerComponent = this.deliveryAirport.isInnerComponent(c))) {
            return true;
        }
        if (this.category != null && (innerComponent = this.category.isInnerComponent(c))) {
            return true;
        }
        return super.isInnerComponent(c);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.options.setVisible(false);
        this.includePlannedFlights.setVisible(false);
        this.groupOutboundMeals.setVisible(false);
        this.hideFromToNSDS.setVisible(false);
        this.useChronology.setVisible(false);
        this.addSpaces.setVisible(false);
        this.includeAdditionals.setVisible(false);
        this.deliveryAirport.setVisible(false);
        if (this.withTime) {
            this.dateTimeChooser.setVisible(false);
        } else {
            this.dateChooser.setVisible(false);
        }
        this.customer.setVisible(false);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                boolean ipF = PrintKitchenDailyOpsComponent.this.includePlannedFlights.getElement().isChecked();
                boolean groupMeals = PrintKitchenDailyOpsComponent.this.groupOutboundMeals.getElement().isChecked();
                boolean hideNSDS = PrintKitchenDailyOpsComponent.this.hideFromToNSDS.getElement().isChecked();
                boolean isChronological = PrintKitchenDailyOpsComponent.this.useChronology.getElement().isChecked();
                boolean includeAdd = PrintKitchenDailyOpsComponent.this.includeAdditionals.getElement().isChecked();
                FlightCategoryComplete cat = (FlightCategoryComplete)PrintKitchenDailyOpsComponent.this.category.getElement().getNode().getValue();
                boolean isAddSpaces = PrintKitchenDailyOpsComponent.this.addSpaces.getElement().isChecked();
                FlightSearchConfiguration f = new FlightSearchConfiguration();
                f.setCategory(cat);
                if (PrintKitchenDailyOpsComponent.this.withTime) {
                    f.setDayTimePeriod(PrintKitchenDailyOpsComponent.this.dateTimeChooser.getTimePeriod());
                } else {
                    Calendar a = PrintKitchenDailyOpsComponent.this.dateChooser.getElement().getSelectedDate();
                    PeriodComplete p = new PeriodComplete(new Date(a.getTimeInMillis()), new Date(a.getTimeInMillis()));
                    f.setDayPeriod(p);
                }
                f.setCustomer((CustomerLight)PrintKitchenDailyOpsComponent.this.customer.getElement().getNode().getValue());
                if (!ipF) {
                    f.setOnlyOpenFlights(Boolean.valueOf(true));
                }
                f.setDeliveryAirport((AirportComplete)((SearchTextField2)PrintKitchenDailyOpsComponent.this.deliveryAirport.getElement()).getNode().getValue());
                f.setNumResults(Integer.MAX_VALUE);
                f.setSortColumn((Enum)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_ARRIVAL);
                ReportFileComplete file = PrintKitchenDailyOpsComponent.this.getSelectedReport();
                SearchReportConfiguration sc = new SearchReportConfiguration(ReportTypeE.FLIGHT, ReportingOutputFormatE.PDF, file);
                sc.setSearchConfig((ADtoSearchConfiguration)f);
                sc.setTitle(Words.DAILY_OPS);
                PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createFlightDailyOpsReport(sc, groupMeals, hideNSDS, isChronological, false, includeAdd, null, DailyOpsSheetTypeE.PAX_BASED, isAddSpaces, !PrintKitchenDailyOpsComponent.this.withTime).getValue();
                PrintKitchenDailyOpsComponent.this.processFile(t);
                Node returnValue = new Node();
                returnValue.setValue((Object)true, 0L);
                return returnValue;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintKitchenDailyOpsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<T> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<T> createBatchJob(Node<T> value, ThreadSafeExecutable job) {
        return new FlightPrintBatch<T>(job, value, this.getPrintProcessor(), false);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintKitchenDailyOpsComponent.this.getInheritedComponentsHeight();
            if (PrintKitchenDailyOpsComponent.this.animation != null) {
                return new Dimension((int)PrintKitchenDailyOpsComponent.this.animation.getPreferredSize().getWidth() + 2 * PrintKitchenDailyOpsComponent.this.border, (int)(PrintKitchenDailyOpsComponent.this.animation.getPreferredSize().getHeight() + (double)(2 * PrintKitchenDailyOpsComponent.this.border)));
            }
            h = (int)((double)h + PrintKitchenDailyOpsComponent.this.options.getPreferredSize().getHeight());
            h += PrintKitchenDailyOpsComponent.this.border;
            h = (int)((double)h + PrintKitchenDailyOpsComponent.this.includePlannedFlights.getPreferredSize().getHeight());
            h += PrintKitchenDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintKitchenDailyOpsComponent.this.groupOutboundMeals.getPreferredSize().getHeight());
            h += PrintKitchenDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintKitchenDailyOpsComponent.this.hideFromToNSDS.getPreferredSize().getHeight());
            h += PrintKitchenDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintKitchenDailyOpsComponent.this.useChronology.getPreferredSize().getHeight());
            h += PrintKitchenDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintKitchenDailyOpsComponent.this.addSpaces.getPreferredSize().getHeight());
            h += PrintKitchenDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintKitchenDailyOpsComponent.this.includeAdditionals.getPreferredSize().getHeight());
            h += PrintKitchenDailyOpsComponent.this.border;
            h = PrintKitchenDailyOpsComponent.this.withTime ? (int)((double)h + PrintKitchenDailyOpsComponent.this.dateTimeChooser.getPreferredSize().getHeight()) : (int)((double)h + PrintKitchenDailyOpsComponent.this.dateChooser.getPreferredSize().getHeight());
            h += PrintKitchenDailyOpsComponent.this.border;
            h = (int)((double)h + PrintKitchenDailyOpsComponent.this.customer.getPreferredSize().getHeight());
            h += PrintKitchenDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintKitchenDailyOpsComponent.this.category.getPreferredSize().getHeight());
            h += PrintKitchenDailyOpsComponent.this.border / 2;
            h = (int)((double)h + PrintKitchenDailyOpsComponent.this.deliveryAirport.getPreferredSize().getHeight());
            return new Dimension(0, h += PrintKitchenDailyOpsComponent.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            int h = PrintKitchenDailyOpsComponent.this.layoutInheritedComponents(parent);
            PrintKitchenDailyOpsComponent.this.options.setLocation(PrintKitchenDailyOpsComponent.this.border, h += PrintKitchenDailyOpsComponent.this.border);
            PrintKitchenDailyOpsComponent.this.options.setSize(PrintKitchenDailyOpsComponent.this.options.getPreferredSize());
            PrintKitchenDailyOpsComponent.this.includePlannedFlights.setLocation(PrintKitchenDailyOpsComponent.this.border, PrintKitchenDailyOpsComponent.this.options.getY() + PrintKitchenDailyOpsComponent.this.options.getHeight() + PrintKitchenDailyOpsComponent.this.border);
            PrintKitchenDailyOpsComponent.this.includePlannedFlights.setSize(PrintKitchenDailyOpsComponent.this.includePlannedFlights.getPreferredSize());
            PrintKitchenDailyOpsComponent.this.groupOutboundMeals.setLocation(PrintKitchenDailyOpsComponent.this.border, PrintKitchenDailyOpsComponent.this.includePlannedFlights.getY() + PrintKitchenDailyOpsComponent.this.includePlannedFlights.getHeight() + PrintKitchenDailyOpsComponent.this.border / 2);
            PrintKitchenDailyOpsComponent.this.groupOutboundMeals.setSize(PrintKitchenDailyOpsComponent.this.groupOutboundMeals.getPreferredSize());
            PrintKitchenDailyOpsComponent.this.hideFromToNSDS.setLocation(PrintKitchenDailyOpsComponent.this.border, PrintKitchenDailyOpsComponent.this.groupOutboundMeals.getY() + PrintKitchenDailyOpsComponent.this.groupOutboundMeals.getHeight() + PrintKitchenDailyOpsComponent.this.border / 2);
            PrintKitchenDailyOpsComponent.this.hideFromToNSDS.setSize(PrintKitchenDailyOpsComponent.this.hideFromToNSDS.getPreferredSize());
            int y = PrintKitchenDailyOpsComponent.this.hideFromToNSDS.getY() + PrintKitchenDailyOpsComponent.this.hideFromToNSDS.getHeight() + PrintKitchenDailyOpsComponent.this.border;
            PrintKitchenDailyOpsComponent.this.useChronology.setLocation(PrintKitchenDailyOpsComponent.this.border, PrintKitchenDailyOpsComponent.this.hideFromToNSDS.getY() + PrintKitchenDailyOpsComponent.this.hideFromToNSDS.getHeight() + PrintKitchenDailyOpsComponent.this.border / 2);
            PrintKitchenDailyOpsComponent.this.useChronology.setSize(PrintKitchenDailyOpsComponent.this.useChronology.getPreferredSize());
            PrintKitchenDailyOpsComponent.this.addSpaces.setLocation(PrintKitchenDailyOpsComponent.this.border, PrintKitchenDailyOpsComponent.this.useChronology.getY() + PrintKitchenDailyOpsComponent.this.useChronology.getHeight() + PrintKitchenDailyOpsComponent.this.border / 2);
            PrintKitchenDailyOpsComponent.this.addSpaces.setSize(PrintKitchenDailyOpsComponent.this.addSpaces.getPreferredSize());
            PrintKitchenDailyOpsComponent.this.includeAdditionals.setLocation(PrintKitchenDailyOpsComponent.this.border, PrintKitchenDailyOpsComponent.this.addSpaces.getY() + PrintKitchenDailyOpsComponent.this.addSpaces.getHeight() + PrintKitchenDailyOpsComponent.this.border / 2);
            PrintKitchenDailyOpsComponent.this.includeAdditionals.setSize(PrintKitchenDailyOpsComponent.this.includeAdditionals.getPreferredSize());
            y = PrintKitchenDailyOpsComponent.this.includeAdditionals.getY() + PrintKitchenDailyOpsComponent.this.includeAdditionals.getHeight() + PrintKitchenDailyOpsComponent.this.border;
            if (PrintKitchenDailyOpsComponent.this.withTime) {
                PrintKitchenDailyOpsComponent.this.dateTimeChooser.setLocation(PrintKitchenDailyOpsComponent.this.border, y);
                PrintKitchenDailyOpsComponent.this.dateTimeChooser.setSize(PrintKitchenDailyOpsComponent.this.dateTimeChooser.getPreferredSize());
                y = (int)((double)y + PrintKitchenDailyOpsComponent.this.dateTimeChooser.getPreferredSize().getHeight());
            } else {
                PrintKitchenDailyOpsComponent.this.dateChooser.setLocation(PrintKitchenDailyOpsComponent.this.border, y);
                PrintKitchenDailyOpsComponent.this.dateChooser.setSize(PrintKitchenDailyOpsComponent.this.dateChooser.getPreferredSize());
                y = (int)((double)y + PrintKitchenDailyOpsComponent.this.dateChooser.getPreferredSize().getHeight());
            }
            PrintKitchenDailyOpsComponent.this.deliveryAirport.setLocation(PrintKitchenDailyOpsComponent.this.border, y + PrintKitchenDailyOpsComponent.this.border / 2);
            PrintKitchenDailyOpsComponent.this.deliveryAirport.setSize(parent.getWidth() - 2 * PrintKitchenDailyOpsComponent.this.border, (int)PrintKitchenDailyOpsComponent.this.deliveryAirport.getPreferredSize().getHeight());
            y = PrintKitchenDailyOpsComponent.this.deliveryAirport.getY() + PrintKitchenDailyOpsComponent.this.deliveryAirport.getHeight();
            PrintKitchenDailyOpsComponent.this.customer.setLocation(PrintKitchenDailyOpsComponent.this.border, y + PrintKitchenDailyOpsComponent.this.border);
            PrintKitchenDailyOpsComponent.this.customer.setSize(parent.getWidth() - 2 * PrintKitchenDailyOpsComponent.this.border, (int)PrintKitchenDailyOpsComponent.this.customer.getPreferredSize().getHeight());
            y = PrintKitchenDailyOpsComponent.this.customer.getY() + PrintKitchenDailyOpsComponent.this.customer.getHeight();
            PrintKitchenDailyOpsComponent.this.category.setLocation(PrintKitchenDailyOpsComponent.this.border, y + PrintKitchenDailyOpsComponent.this.border / 2);
            PrintKitchenDailyOpsComponent.this.category.setSize(parent.getWidth() - 2 * PrintKitchenDailyOpsComponent.this.border, (int)PrintKitchenDailyOpsComponent.this.category.getPreferredSize().getHeight());
        }
    }
}

