/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.limeflight;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.RadioButtonBoxAnalysisItem;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.EdelweissServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import ch.icit.pegasus.server.core.timerService.ServiceTypesForTimerService;

public class AnalysisLimeFlightSyncComponent
extends DefaultServerSideAnalysisComponent<FlightLight, FlightReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RadioButtonBox> buttonBox;
    private TitledItem<RadioButton> lm0800h0d;
    private TitledItem<RadioButton> lm1500h1d;
    private TitledItem<RadioButton> lm1500h2d;
    private TitledItem<RadioButton> lm2000h0d;
    private TitledItem<RadioButton> lm2000h1d;
    private TitledItem<RadioButton> lm2000h2d;

    public AnalysisLimeFlightSyncComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.buttonBox = new TitledItem<RadioButtonBox>(new RadioButtonBox(), "Sync Type", TitledItem.TitledItemOrientation.NORTH);
        this.lm0800h0d = new TitledItem<RadioButton>(new RadioButton(), "08:00h +0d", TitledItem.TitledItemOrientation.EAST);
        this.lm1500h1d = new TitledItem<RadioButton>(new RadioButton(), "15:00h +1d", TitledItem.TitledItemOrientation.EAST);
        this.lm1500h2d = new TitledItem<RadioButton>(new RadioButton(), "15:00h +2d", TitledItem.TitledItemOrientation.EAST);
        this.lm2000h0d = new TitledItem<RadioButton>(new RadioButton(), "20:00h +0d", TitledItem.TitledItemOrientation.EAST);
        this.lm2000h1d = new TitledItem<RadioButton>(new RadioButton(), "20:00h +1d", TitledItem.TitledItemOrientation.EAST);
        this.lm2000h2d = new TitledItem<RadioButton>(new RadioButton(), "20:00h +2d", TitledItem.TitledItemOrientation.EAST);
        this.buttonBox.getElement().addBox(this.lm0800h0d, this.lm0800h0d.getElement());
        this.buttonBox.getElement().addBox(this.lm1500h1d, this.lm1500h1d.getElement());
        this.buttonBox.getElement().addBox(this.lm1500h2d, this.lm1500h2d.getElement());
        this.buttonBox.getElement().addBox(this.lm2000h0d, this.lm2000h0d.getElement());
        this.buttonBox.getElement().addBox(this.lm2000h1d, this.lm2000h1d.getElement());
        this.buttonBox.getElement().addBox(this.lm2000h2d, this.lm2000h2d.getElement());
        this.addOptionsItem(new RadioButtonBoxAnalysisItem(this.buttonBox, "lm_type"));
    }

    @Override
    public String getTitleString() {
        return "Lime Flight";
    }

    @Override
    public FlightReference createReference(FlightLight item) {
        return null;
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        ServiceTypesForTimerService selected = null;
        if (this.lm0800h0d.getElement().isChecked()) {
            selected = ServiceTypesForTimerService.EDELWEISS_LIME_FLIGHT_RECEIVE_DATA_0DAYS_08H;
        }
        if (this.lm1500h1d.getElement().isChecked()) {
            selected = ServiceTypesForTimerService.EDELWEISS_LIME_FLIGHT_RECEIVE_DATA_1DAYS_15H;
        }
        if (this.lm1500h2d.getElement().isChecked()) {
            selected = ServiceTypesForTimerService.EDELWEISS_LIME_FLIGHT_RECEIVE_DATA_2DAYS_15H;
        }
        if (this.lm2000h0d.getElement().isChecked()) {
            selected = ServiceTypesForTimerService.EDELWEISS_LIME_FLIGHT_RECEIVE_DATA_0DAYS_20H;
        }
        if (this.lm2000h1d.getElement().isChecked()) {
            selected = ServiceTypesForTimerService.EDELWEISS_LIME_FLIGHT_RECEIVE_DATA_1DAYS_20H;
        }
        if (this.lm2000h2d.getElement().isChecked()) {
            selected = ServiceTypesForTimerService.EDELWEISS_LIME_FLIGHT_RECEIVE_DATA_2DAYS_20H;
        }
        ((EdelweissServiceManager)ServiceManagerRegistry.getService(EdelweissServiceManager.class)).readLimeFlightData(selected);
        return null;
    }
}

