/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.inventory.remote.overview;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.PeriodEditorAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.InventoryReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.InventoryDifferenceReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.search.InventorySearchConfiguration;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.general.IUniversal;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class InventoryOverviewAnalysisComponent
extends DefaultServerSideAnalysisComponent<InventoryLight, InventoryReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<CheckBox> stdPrice;
    private TitledPeriodEditor wastePeriod;
    private TitledPeriodEditor matDispoPeriod;
    private TitledPeriodEditor floatPeriod;

    public InventoryOverviewAnalysisComponent(AnalysisSmartExternalOpenTool<InventoryLight> defaultAnalysis) {
        super(defaultAnalysis, false, true);
    }

    @Override
    public void addOptionItems() {
        boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        if (!isNoPro) {
            this.stdPrice = new TitledItem<CheckBox>(new CheckBox(), "Standard Price", TitledItem.TitledItemOrientation.EAST);
            this.addOptionsItem(new CheckBoxAnalysisItem(this.stdPrice, "std_price"));
        }
        PeriodComplete periodComplete = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
        this.wastePeriod = new TitledPeriodEditor((Node<PeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)periodComplete, false, false), true, null);
        this.wastePeriod.setTitleText("Waste/Dispo/toFloat Start", "End");
        this.addOptionsItem(new PeriodEditorAnalysisItem(this.wastePeriod, "waste_period"));
        periodComplete = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
        this.matDispoPeriod = new TitledPeriodEditor((Node<PeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)periodComplete, false, false), true, null);
        this.matDispoPeriod.setTitleText("MatDispo Start", "End");
        this.addOptionsItem(new PeriodEditorAnalysisItem(this.matDispoPeriod, "matdispo_period"));
        periodComplete = new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis()));
        this.floatPeriod = new TitledPeriodEditor((Node<PeriodComplete>)INodeCreator.getDefaultImpl().getNode4DTO((Object)periodComplete, false, false), true, null);
        this.floatPeriod.setTitleText("toFloat Start", "End");
        this.addOptionsItem(new PeriodEditorAnalysisItem(this.floatPeriod, "float_period"));
    }

    @Override
    public InventoryReference createReference(InventoryLight item) {
        return new InventoryReference(item.getId());
    }

    @Override
    public Iterator<InventoryLight> getIterator() throws ServiceException {
        if (this.numbers != null && ((RadioButton)this.numbers.getElement()).isChecked()) {
            String text = this.numberField.getText();
            HashSet<Integer> copyNumbers = new HashSet<Integer>();
            if (text != null && !text.isEmpty()) {
                String[] s;
                for (String ss : s = text.split(",")) {
                    try {
                        String[] sss = ss.split("-");
                        if (sss != null && sss.length > 1 && ss.contains("-")) {
                            int start = Integer.valueOf(sss[0]);
                            int end = Integer.valueOf(sss[1]);
                            for (int i = start; i <= end; ++i) {
                                copyNumbers.add(i);
                            }
                            continue;
                        }
                        int i = Integer.valueOf(ss.trim());
                        copyNumbers.add(i);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            ArrayList<IUniversal> inventories = new ArrayList<IUniversal>();
            for (Integer number : copyNumbers) {
                InventorySearchConfiguration config = new InventorySearchConfiguration();
                config.setNumber(number);
                SearchResultIterator sri = new SearchResultIterator((ASearchConfiguration)config);
                while (sri.hasNext()) {
                    inventories.add(sri.next());
                }
            }
            return inventories.iterator();
        }
        return super.getIterator();
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        InventoryDifferenceReportConfiguration config = new InventoryDifferenceReportConfiguration();
        config.setFormat(ReportingOutputFormatE.XLSX);
        if (this.stdPrice != null) {
            config.setUseStandardPrice(Boolean.valueOf(this.stdPrice.getElement().isChecked()));
        }
        config.setInventory(this.loadItemReferences());
        config.setWastePeriod(this.wastePeriod.getPeriod());
        config.setMatDispoPeriod(this.matDispoPeriod.getPeriod());
        config.setFloatPeriod(this.floatPeriod.getPeriod());
        return (PegasusFileComplete)((InventoryReportServiceManager)ServiceManagerRegistry.getService(InventoryReportServiceManager.class)).getInventoryOverviewReport(config).getValue();
    }
}

