/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.product.remote.usage.flight;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledDateTimePeriodChooser;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateTimePeriodEditorAnalysisItem;
import ch.icit.pegasus.client.gui.utils.tables.ProductTable;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TimestampPeriodComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductReference;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight;
import ch.icit.pegasus.server.core.dtos.search.ProductSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Component;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AnalysisProductFlightUsageComponent
extends DefaultServerSideAnalysisComponent<ProductComplete, ProductReference> {
    private static final long serialVersionUID = 1L;
    private TitledDateTimePeriodChooser chooser;

    public AnalysisProductFlightUsageComponent(AnalysisSmartExternalOpenTool<ProductComplete> defaultAnalysis) {
        super(defaultAnalysis, false, true, null);
    }

    @Override
    public void addOptionItems() {
        Node dateNode = new Node();
        dateNode.setValue((Object)new TimestampPeriodComplete(new Timestamp(System.currentTimeMillis()), new Timestamp(System.currentTimeMillis())), 0L);
        this.chooser = new TitledDateTimePeriodChooser((Node<TimestampPeriodComplete>)dateNode);
        this.addOptionsItem(new DateTimePeriodEditorAnalysisItem(this.chooser, "period"));
    }

    @Override
    public Table2 createTable() {
        ProductTable p = new ProductTable();
        p.setNode((Node<?>)new ListNode());
        return p;
    }

    @Override
    public boolean validateContent() {
        return true;
    }

    @Override
    protected String getProgressText() {
        return WordsToolkit.toCapitalLetter((String)Words.PRINT);
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT_PRODUCT_USAGE;
    }

    @Override
    public String getTitleValue() {
        return Words.PRODUCT;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ProductReference createReference(ProductComplete item) {
        return new ProductReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        this.chooser.getNode().commitThis();
        TimestampPeriodComplete ts = this.chooser.getTimePeriod();
        ArrayList<ProductReference> references = new ArrayList<ProductReference>();
        ProductSearchConfiguration searchConfig = this.getSearchConfiguration();
        Iterator s = this.getIterator();
        if (s == null) {
            List<Integer> numbers2Search;
            if (this.expandIcon != null && this.expandIcon.isExpanded()) {
                numbers2Search = new ArrayList<Integer>();
                Iterator it = this.table.getModel().getNode().getFailSafeChildIterator();
                while (it.hasNext()) {
                    Node n = (Node)it.next();
                    if (n.getValue() == null) continue;
                    numbers2Search.add(((ProductVariantLight)n.getValue()).getProduct().getNumber());
                }
            } else {
                numbers2Search = this.getNumbers();
            }
            for (Integer i : numbers2Search) {
                ProductSearchConfiguration c = new ProductSearchConfiguration();
                c.setNumber(i);
                SearchResultIterator si = new SearchResultIterator((ASearchConfiguration)c);
                for (ProductComplete p : si) {
                    references.add(new ProductReference(p.getId()));
                }
            }
            searchConfig = new ProductSearchConfiguration();
        } else {
            while (s.hasNext()) {
                ProductComplete next = (ProductComplete)s.next();
                if (next != null) {
                    references.add(new ProductReference(next.getId()));
                    continue;
                }
                System.out.println("");
            }
        }
        PegasusFileComplete file = (PegasusFileComplete)((SupplyReportServiceManager)ServiceManagerRegistry.getService(SupplyReportServiceManager.class)).getProductFlightUsageReport(new ListWrapper(references), ts, searchConfig).getValue();
        return file;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }
}

