/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.productcatalog.productfactsheet;

import ch.icit.pegasus.client.gui.submodules.analysis.productcatalog.productfactsheet.AnalysisProductFactSheetReport;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.CheckBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ComboBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.ProductReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogLight;
import ch.icit.pegasus.server.core.dtos.product.ProductCatalogReference;
import ch.icit.pegasus.server.core.dtos.report.ProductFactSheetsReportConfiguration;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductCatalogAccess;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class AnalysisProductFactSheetComponent
extends DefaultServerSideAnalysisComponent<ProductCatalogLight, ProductCatalogReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> dueDate;
    private TitledItem<CheckBox> includeSalesPrice;
    private TitledItem<CheckBox> includeMealPlanData;
    private TitledItem<CheckBox> includeManMinutes;
    private TitledItem<CheckBox> includeProductMM;
    private TitledItem<CheckBox> includeGroupMM;
    private TitledItem<CheckBox> includeComponentMM;
    private TitledItem<ComboBox> includeTender;
    private TitledItem<CheckBox> resolveRecipesToArticles;
    private TitledItem<CheckBox> splitCostCenters;

    public AnalysisProductFactSheetComponent(AnalysisProductFactSheetReport productListAnalysis) {
        super(productListAnalysis);
    }

    @Override
    public void addOptionItems() {
        UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        ModuleAccessRightComplete r = HUDToolkit.getCurrentAccessRight(ProductCatalogAccess.MODULE_PRODUCT_CATALOG, user);
        boolean showProductionCosts = false;
        boolean printExternalCostFactSheet = false;
        for (DataFieldAccessRightComplete a : r.getFieldAccessRights()) {
            if (a.getField().getName().equals(ProductCatalogAccess.SHOW_PRODUCTION_COSTS.getName())) {
                showProductionCosts = true;
                continue;
            }
            if (!a.getField().getName().equals(ProductCatalogAccess.PRINT_EXTERNAL_COST_FACT_SHEET.getName())) continue;
            printExternalCostFactSheet = true;
        }
        Node n = new Node();
        n.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(n), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new DateChooserAnalysisItem(this.dueDate, "dueDate"));
        if (showProductionCosts) {
            this.includeSalesPrice = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COSTS, TitledItem.TitledItemOrientation.EAST);
            this.addOptionsItem(new CheckBoxAnalysisItem(this.includeSalesPrice, "sales"));
        }
        this.includeMealPlanData = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MEAL_PLAN_AND_STOWING_LIST, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeMealPlanData, "mealPlan"));
        this.includeManMinutes = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_MAN_MINUTES_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeManMinutes, "includeManMinutes"));
        this.includeProductMM = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_PRODUCT_MM_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeProductMM, "includeProductMM"));
        this.includeGroupMM = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_GROUP_MM_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeGroupMM, "includeGroupMM"));
        this.includeComponentMM = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COMPONENT_MM_SHEET, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.includeComponentMM, "includeComponentMM"));
        if (printExternalCostFactSheet) {
            this.includeTender = new TitledItem<ComboBox>(new ComboBox(), Words.TENDER, TitledItem.TitledItemOrientation.NORTH);
            this.includeTender.getElement().addItem(Words.ALL);
            this.includeTender.getElement().addItem(Words.TENDER);
            this.includeTender.getElement().addItem(Words.PRODUCTIVE);
            this.addOptionsItem(new ComboBoxAnalysisItem(this.includeTender, "tender"));
        }
        this.resolveRecipesToArticles = new TitledItem<CheckBox>(new CheckBox(), Words.RESOLVE_RECIPES_TO_ARTICLES, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.resolveRecipesToArticles, "resolveRecipesToArticles"));
        this.splitCostCenters = new TitledItem<CheckBox>(new CheckBox(), Words.SPLIT_DEPARTMENTS, TitledItem.TitledItemOrientation.EAST);
        this.addOptionsItem(new CheckBoxAnalysisItem(this.splitCostCenters, "splitCostCenters"));
    }

    @Override
    public ProductCatalogReference createReference(ProductCatalogLight item) {
        return new ProductCatalogReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        List references = this.loadItemReferences();
        Date d = null;
        if (this.dueDate.getElement().getNode().getValue() instanceof Date) {
            d = (Date)this.dueDate.getElement().getNode().getValue();
        } else if (this.dueDate.getElement().getNode().getValue() instanceof Timestamp) {
            d = new Date(((Timestamp)this.dueDate.getElement().getNode().getValue()).getTime());
        }
        ArrayList warnings = new ArrayList();
        boolean includeCosts = false;
        if (this.includeSalesPrice != null) {
            includeCosts = this.includeSalesPrice.getElement().isChecked();
        }
        Boolean showTender = false;
        if (this.includeTender == null) {
            showTender = false;
        } else if (this.includeTender.getElement().getSelectedItem().equals(Words.ALL)) {
            showTender = null;
        } else if (this.includeTender.getElement().getSelectedItem().equals(Words.TENDER)) {
            showTender = true;
        } else if (this.includeTender.getElement().getSelectedItem().equals(Words.PRODUCTIVE)) {
            showTender = false;
        }
        boolean manMinutes = this.includeManMinutes.getElement().isChecked();
        boolean includeProductMMSheet = this.includeProductMM.getElement().isChecked();
        boolean includeGroupMMSheet = this.includeGroupMM.getElement().isChecked();
        boolean includeComponentMMSheet = this.includeComponentMM.getElement().isChecked();
        boolean includeMPStw = false;
        if (this.includeMealPlanData != null) {
            includeMPStw = this.includeMealPlanData.getElement().isChecked();
        }
        boolean resolveRecipesToArticles = this.resolveRecipesToArticles.getElement().isChecked();
        boolean splitDepartments = this.splitCostCenters.getElement().isChecked();
        ProductFactSheetsReportConfiguration configuration = new ProductFactSheetsReportConfiguration();
        configuration.setDueDate(d);
        configuration.setIncludeCosts(Boolean.valueOf(includeCosts));
        configuration.setIncludeMpAndStwUsage(Boolean.valueOf(includeMPStw));
        configuration.setResolveRecipesToArticles(Boolean.valueOf(resolveRecipesToArticles));
        configuration.setIncludeMMSheet(Boolean.valueOf(manMinutes));
        configuration.setShowProductComponentDepartmentsSeperately(Boolean.valueOf(splitDepartments));
        configuration.setIncludeProductMMSheet(Boolean.valueOf(includeProductMMSheet));
        configuration.setIncludeGroupMMSheet(Boolean.valueOf(includeGroupMMSheet));
        configuration.setIncludeComponentMMSheet(Boolean.valueOf(includeComponentMMSheet));
        configuration.setShowTender(showTender);
        PegasusFileComplete file = (PegasusFileComplete)((ProductReportServiceManager)ServiceManagerRegistry.getService(ProductReportServiceManager.class)).createProductFactSheetExportForCatalogs(new ListWrapper(references), configuration).getValue();
        if (!warnings.isEmpty()) {
            ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
            for (String m : warnings) {
                o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, m));
            }
            InnerPopupFactory.showErrorDialog(o, "Unable to calculate all Products", (Component)this);
        }
        return file;
    }
}

