/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.requisitionorder.ops;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderLight;
import ch.icit.pegasus.server.core.dtos.report.RequisitionOrderReportConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.List;

public class PrintDeliverDailyOpsComponent
extends DefaultScrollablePrintPopup2<RequisitionOrderLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> selectedDate;
    private TitledItem<ComboBox> department;
    private TitledItem<SearchTextField2> storeSearch;
    private TitledItem<CheckBox> includeOnlyPlannedOrders;
    private TitledItem<CheckBox> filterPositions;

    public PrintDeliverDailyOpsComponent() {
        super(false, false, ReportTypeE.REQUISITION_ORDER_DELIVER);
    }

    @Override
    public void insertElements() {
        this.createComponents();
        this.selectedDate = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false)), Words.DATE_SCHED_DELIVERY, TitledItem.TitledItemOrientation.NORTH);
        this.selectedDate.setVisible(true);
        this.department = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(InternalCostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class), true), Words.DELIVER_DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.storeSearch = new TitledItem<SearchTextField2<StoreLight>>(SearchTextField2Factory.getStoreSearchField(true, new DTOProxyNode()), Words.DELIVER_STORE, TitledItem.TitledItemOrientation.NORTH);
        this.includeOnlyPlannedOrders = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_PLANNED_ORDERS_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.includeOnlyPlannedOrders.getElement().setChecked(true);
        this.filterPositions = new TitledItem<CheckBox>(new CheckBox(), Words.FILTER_POSITION_BY_DEPARTMENT, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.selectedDate);
        this.getViewContainer().add(this.department);
        this.getViewContainer().add(this.storeSearch);
        this.getViewContainer().add(this.includeOnlyPlannedOrders);
        this.getViewContainer().add(this.filterPositions);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.selectedDate.setVisible(true);
        this.department.setVisible(true);
        this.storeSearch.setVisible(true);
        this.includeOnlyPlannedOrders.setVisible(true);
        this.filterPositions.setVisible(true);
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.selectedDate.setVisible(false);
        this.department.setVisible(false);
        this.storeSearch.setVisible(false);
        this.includeOnlyPlannedOrders.setVisible(false);
        this.filterPositions.setVisible(false);
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return super.isInnerComponent(c);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                RequisitionOrderReportConfiguration p = new RequisitionOrderReportConfiguration();
                p.setStylesheet(PrintDeliverDailyOpsComponent.this.getSelectedReport());
                if (((DateChooser)PrintDeliverDailyOpsComponent.this.selectedDate.getElement()).getSelectedDate() != null) {
                    p.setSelectedDate(new Date(((DateChooser)PrintDeliverDailyOpsComponent.this.selectedDate.getElement()).getSelectedDate().getTime()));
                }
                if (((SearchTextField2)PrintDeliverDailyOpsComponent.this.storeSearch.getElement()).getNode().getValue() != null) {
                    p.setDeliverStore(new StoreReference(((StoreLight)((SearchTextField2)PrintDeliverDailyOpsComponent.this.storeSearch.getElement()).getNode().getValue()).getId()));
                }
                if (((ComboBox)PrintDeliverDailyOpsComponent.this.department.getElement()).getNode().getValue() != null) {
                    p.setDeliverDepartment((CostCenterComplete)((ComboBox)PrintDeliverDailyOpsComponent.this.department.getElement()).getNode().getValue());
                }
                if (p.getSelectedDate() != null) {
                    p.setSelectedDate(new PeriodComplete(new Date(p.getSelectedDate().getTime()), new Date(p.getSelectedDate().getTime())).getStartDate());
                }
                p.setIncludePlannedOrdersOnly(Boolean.valueOf(((CheckBox)PrintDeliverDailyOpsComponent.this.includeOnlyPlannedOrders.getElement()).isChecked()));
                p.setFilterPositionByDepartment(Boolean.valueOf(((CheckBox)PrintDeliverDailyOpsComponent.this.filterPositions.getElement()).isChecked()));
                PegasusFileComplete t = (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createRequisitionDeliverDailyOps(p).getValue();
                if (t == null) {
                    InnerPopupFactory.showMessageDialog("No Order Position found for given configuration", PrintDeliverDailyOpsComponent.this);
                    Node b = new Node();
                    b.setValue((Object)true, 0L);
                    return b;
                }
                PrintDeliverDailyOpsComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintDeliverDailyOpsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<RequisitionOrderLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<RequisitionOrderLight> createBatchJob(Node<RequisitionOrderLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public String getTitleString() {
        return Words.REQUISITION_ORDER_DELIVER_SHEETS;
    }

    @Override
    public String getTitleValue() {
        return Words.ALL;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.selectedDate);
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.selectedDate != null) {
            this.selectedDate.kill();
        }
        this.selectedDate = null;
        if (this.includeOnlyPlannedOrders != null) {
            this.includeOnlyPlannedOrders.kill();
        }
        this.includeOnlyPlannedOrders = null;
        if (this.filterPositions != null) {
            this.filterPositions.kill();
        }
        this.filterPositions = null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int y = PrintDeliverDailyOpsComponent.this.getInheritedComponentsHeight();
            y += PrintDeliverDailyOpsComponent.this.border;
            y = (int)((double)y + PrintDeliverDailyOpsComponent.this.selectedDate.getPreferredSize().getHeight());
            y += PrintDeliverDailyOpsComponent.this.border;
            y = (int)((double)y + PrintDeliverDailyOpsComponent.this.department.getPreferredSize().getHeight());
            y += PrintDeliverDailyOpsComponent.this.border;
            y = (int)((double)y + PrintDeliverDailyOpsComponent.this.storeSearch.getPreferredSize().getHeight());
            y += PrintDeliverDailyOpsComponent.this.border;
            y = (int)((double)y + PrintDeliverDailyOpsComponent.this.includeOnlyPlannedOrders.getPreferredSize().getHeight());
            y += PrintDeliverDailyOpsComponent.this.border;
            y = (int)((double)y + PrintDeliverDailyOpsComponent.this.filterPositions.getPreferredSize().getHeight());
            return new Dimension(0, y += PrintDeliverDailyOpsComponent.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintDeliverDailyOpsComponent.this.layoutInheritedComponents(parent);
            PrintDeliverDailyOpsComponent.this.selectedDate.setLocation(PrintDeliverDailyOpsComponent.this.border, y += PrintDeliverDailyOpsComponent.this.border);
            PrintDeliverDailyOpsComponent.this.selectedDate.setSize(PrintDeliverDailyOpsComponent.this.selectedDate.getPreferredSize());
            y = PrintDeliverDailyOpsComponent.this.selectedDate.getY() + PrintDeliverDailyOpsComponent.this.selectedDate.getHeight() + PrintDeliverDailyOpsComponent.this.border;
            PrintDeliverDailyOpsComponent.this.department.setLocation(PrintDeliverDailyOpsComponent.this.border, y);
            PrintDeliverDailyOpsComponent.this.department.setSize(200, (int)PrintDeliverDailyOpsComponent.this.department.getPreferredSize().getHeight());
            y = PrintDeliverDailyOpsComponent.this.department.getY() + PrintDeliverDailyOpsComponent.this.department.getHeight() + PrintDeliverDailyOpsComponent.this.border;
            PrintDeliverDailyOpsComponent.this.storeSearch.setLocation(PrintDeliverDailyOpsComponent.this.border, y);
            PrintDeliverDailyOpsComponent.this.storeSearch.setSize(200, (int)PrintDeliverDailyOpsComponent.this.storeSearch.getPreferredSize().getHeight());
            PrintDeliverDailyOpsComponent.this.includeOnlyPlannedOrders.setLocation(PrintDeliverDailyOpsComponent.this.border, PrintDeliverDailyOpsComponent.this.storeSearch.getY() + PrintDeliverDailyOpsComponent.this.storeSearch.getHeight() + PrintDeliverDailyOpsComponent.this.border);
            PrintDeliverDailyOpsComponent.this.includeOnlyPlannedOrders.setSize(PrintDeliverDailyOpsComponent.this.includeOnlyPlannedOrders.getPreferredSize());
            PrintDeliverDailyOpsComponent.this.filterPositions.setLocation(PrintDeliverDailyOpsComponent.this.border, PrintDeliverDailyOpsComponent.this.includeOnlyPlannedOrders.getY() + PrintDeliverDailyOpsComponent.this.includeOnlyPlannedOrders.getHeight() + PrintDeliverDailyOpsComponent.this.border);
            PrintDeliverDailyOpsComponent.this.filterPositions.setSize(PrintDeliverDailyOpsComponent.this.filterPositions.getPreferredSize());
        }
    }
}

