/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.stowinglist.articleusage;

import ch.icit.pegasus.client.converter.BondedStateEConverter;
import ch.icit.pegasus.client.converter.HaulTypeConverter;
import ch.icit.pegasus.client.converter.SingleArticleCategoryConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ComboBoxAnalysisItem;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.search.StowingListTemplateSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ServiceException;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Timestamp;

public class ArticleByStowingListAnalysisComponentNew
extends DefaultServerSideAnalysisComponent<StowingListTemplateComplete, StowingListTemplateReference>
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> bonded;
    private TitledItem<ComboBox> includeUnused;
    private TitledItem<ComboBox> includeDeleted;
    private TitledItem<ComboBox> includeNominated;
    private TitledItem<ComboBox> includeCustomerOwned;
    private TitledItem<ComboBox> category;
    private TitledItem<ComboBox> group;
    private TitledItem<ComboBox> subGroup;
    private TitledItem<ComboBox> haulType;
    private TitledItem<DateChooser> validityDateChooser;

    public ArticleByStowingListAnalysisComponentNew(AnalysisSmartExternalOpenTool<StowingListTemplateComplete> defaultAnalysis) {
        super(defaultAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.validityDateChooser = new TitledItem<DateChooser>(new DateChooser(), Words.VALIDITY, TitledItem.TitledItemOrientation.NORTH);
        this.validityDateChooser.getElement().setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Timestamp(System.currentTimeMillis()), false, false));
        this.bonded = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(BondedStateE.class), ConverterRegistry.getConverter(BondedStateEConverter.class)), Words.INCLUDE_BONDED, TitledItem.TitledItemOrientation.NORTH);
        this.includeUnused = new TitledItem<ComboBox>(new ComboBox(), Words.INCLUDE_INUSE, TitledItem.TitledItemOrientation.NORTH);
        this.includeUnused.getElement().addItem(Words.ALL);
        this.includeUnused.getElement().addItem(Words.IN_USE);
        this.includeUnused.getElement().addItem(Words.NOT_USE_ONLY);
        this.includeUnused.getElement().setSelectedItem(Words.ALL);
        this.includeDeleted = new TitledItem<ComboBox>(new ComboBox(), Words.INCLUDE_DELETED, TitledItem.TitledItemOrientation.NORTH);
        this.includeDeleted.getElement().addItem(Words.ALL);
        this.includeDeleted.getElement().addItem(Words.DELETED_ONLY);
        this.includeDeleted.getElement().addItem(Words.NOT_DELETED_ONLY);
        this.includeDeleted.getElement().setSelectedItem(Words.NOT_DELETED_ONLY);
        this.includeNominated = new TitledItem<ComboBox>(new ComboBox(), Words.INCLUDE_NOMINATED, TitledItem.TitledItemOrientation.NORTH);
        this.includeNominated.getElement().addItem(Words.ALL);
        this.includeNominated.getElement().addItem(Words.NOMINATED_ONLY);
        this.includeNominated.getElement().addItem(Words.NOT_NOMINATED);
        this.includeNominated.getElement().setSelectedItem(Words.ALL);
        this.includeCustomerOwned = new TitledItem<ComboBox>(new ComboBox(), Words.INCLUDE_CUSTOMER_OWNED, TitledItem.TitledItemOrientation.NORTH);
        this.includeCustomerOwned.getElement().addItem(Words.ALL);
        this.includeCustomerOwned.getElement().addItem(Words.CUSTOMER_OWNED_ONLY);
        this.includeCustomerOwned.getElement().addItem(Words.NOT_CUSTOMER_OWNED);
        this.includeCustomerOwned.getElement().setSelectedItem(Words.ALL);
        this.category = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(ArticleCategoryComplete.class), ConverterRegistry.getConverter(SingleArticleCategoryConverter.class), true), Words.CATEGORY, TitledItem.TitledItemOrientation.NORTH);
        this.group = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(SingleArticleCategoryConverter.class), true), Words.GROUP, TitledItem.TitledItemOrientation.NORTH);
        this.subGroup = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(SingleArticleCategoryConverter.class), true), Words.SUB_GROUP, TitledItem.TitledItemOrientation.NORTH);
        this.category.getElement().addItemListener(this);
        this.group.getElement().addItemListener(this);
        this.haulType = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(HaulTypeComplete.class), ConverterRegistry.getConverter(HaulTypeConverter.class)), Words.HAUL_TYPE, TitledItem.TitledItemOrientation.NORTH);
        this.haulType.getElement().addItem(Words.ALL);
        this.haulType.getElement().setSelectedItem(Words.ALL);
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDateChooser, "validityDate"));
        this.addOptionsItem(new ComboBoxAnalysisItem(this.haulType, "haulType"));
        this.addOptionsItem(new ComboBoxAnalysisItem(this.bonded, "bonded"));
        this.addOptionsItem(new ComboBoxAnalysisItem(this.includeUnused, "used"));
        this.addOptionsItem(new ComboBoxAnalysisItem(this.includeDeleted, "deleted"));
        this.addOptionsItem(new ComboBoxAnalysisItem(this.includeNominated, "nominated"));
        this.addOptionsItem(new ComboBoxAnalysisItem(this.includeCustomerOwned, "owned"));
        this.addOptionsItem(new ComboBoxAnalysisItem(this.category, "category"));
        this.addOptionsItem(new ComboBoxAnalysisItem(this.group, "group"));
        this.addOptionsItem(new ComboBoxAnalysisItem(this.subGroup, "subGroup"));
        this.setEnabled(true);
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE_BY_STOWING;
    }

    @Override
    public String getTitleValue() {
        return Words.STOWING_LISTS;
    }

    @Override
    public StowingListTemplateReference createReference(StowingListTemplateComplete item) {
        return new StowingListTemplateReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws ServiceException {
        StowingListTemplateSearchConfiguration searchConfiguration = (StowingListTemplateSearchConfiguration)this.getSearchConfiguration();
        if (searchConfiguration == null) {
            searchConfiguration = (StowingListTemplateSearchConfiguration)this.externalOpenTool.getEmptyConfig();
            searchConfiguration.setSearchtype(ASearchConfiguration.SearchType.Full);
            searchConfiguration.setPageNumber(0);
            searchConfiguration.setNumResults(Integer.MAX_VALUE);
        }
        searchConfiguration.setIncludeBonded((BondedStateE)this.bonded.getElement().getNode().getValue());
        if (this.includeUnused.getElement().getSelectedItem().equals(Words.IN_USE)) {
            searchConfiguration.setIncludeUnused(Boolean.valueOf(true));
        } else if (this.includeUnused.getElement().getSelectedItem().equals(Words.NOT_USE_ONLY)) {
            searchConfiguration.setIncludeUnused(Boolean.valueOf(false));
        } else {
            searchConfiguration.setIncludeBonded(null);
        }
        if (this.includeDeleted.getElement().getSelectedItem().equals(Words.DELETED_ONLY)) {
            searchConfiguration.setIncludeDeleted(Boolean.valueOf(true));
        } else if (this.includeDeleted.getElement().getSelectedItem().equals(Words.NOT_DELETED_ONLY)) {
            searchConfiguration.setIncludeUnused(Boolean.valueOf(false));
        } else {
            searchConfiguration.setIncludeBonded(null);
        }
        if (this.includeNominated.getElement().getSelectedItem().equals(Words.NOMINATED_ONLY)) {
            searchConfiguration.setIncludeNominated(Boolean.valueOf(true));
        } else if (this.includeNominated.getElement().getSelectedItem().equals(Words.NOT_NOMINATED)) {
            searchConfiguration.setIncludeNominated(Boolean.valueOf(false));
        } else {
            searchConfiguration.setIncludeNominated(null);
        }
        if (this.includeCustomerOwned.getElement().getSelectedItem().equals(Words.CUSTOMER_OWNED_ONLY)) {
            searchConfiguration.setIncludeCustomerOwned(Boolean.valueOf(true));
        } else if (this.includeCustomerOwned.getElement().getSelectedItem().equals(Words.NOT_CUSTOMER_OWNED)) {
            searchConfiguration.setIncludeCustomerOwned(Boolean.valueOf(false));
        } else {
            searchConfiguration.setIncludeCustomerOwned(null);
        }
        if (this.category.getElement().getSelectedItem() instanceof Node) {
            searchConfiguration.setCategory((ArticleCategoryReference)((Node)this.category.getElement().getSelectedItem()).getValue());
        }
        if (this.group.getElement().getSelectedItem() instanceof Node) {
            searchConfiguration.setGroup((ArticleCategoryReference)((Node)this.group.getElement().getSelectedItem()).getValue());
        }
        if (this.subGroup.getElement().getSelectedItem() instanceof Node) {
            searchConfiguration.setSubGroup((ArticleCategoryReference)((Node)this.subGroup.getElement().getSelectedItem()).getValue());
        }
        if (this.haulType.getElement().getSelectedItem() instanceof Node) {
            searchConfiguration.setHaulType((HaulTypeComplete)((Node)this.haulType.getElement().getSelectedItem()).getValue());
        } else {
            searchConfiguration.setHaulType(null);
        }
        Timestamp validityDate = new Timestamp(this.validityDateChooser.getElement().getSelectedDate().getTime());
        PegasusFileComplete file = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createArticleByStowingListExport(searchConfiguration, new TimestampWrapper(validityDate)).getValue();
        return file;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.category.getElement()) {
                if (this.category.getElement().getSelectedItem() != null) {
                    if (this.category.getElement().getSelectedItem() instanceof ArticleCategoryReference) {
                        ArticleCategoryComplete cat = (ArticleCategoryComplete)this.category.getElement().getSelectedItem();
                        Node nodes = INodeCreator.getDefaultImpl().createNodes(cat.getSubCategories(), false);
                        this.group.getElement().refreshPossibleValues(nodes);
                    } else if (this.category.getElement().getSelectedItem() instanceof Node) {
                        Node node = (Node)this.category.getElement().getSelectedItem();
                        Node nodes = node.getChildNamed(ArticleCategoryComplete_.subCategories);
                        this.group.getElement().refreshPossibleValues(nodes);
                    } else {
                        this.group.getElement().refreshPossibleValues(null);
                    }
                }
            } else if (e.getSource() == this.group.getElement() && this.group.getElement().getSelectedItem() != null) {
                if (this.group.getElement().getSelectedItem() instanceof ArticleCategoryReference) {
                    ArticleCategoryComplete cat = (ArticleCategoryComplete)this.group.getElement().getSelectedItem();
                    Node nodes = INodeCreator.getDefaultImpl().createNodes(cat.getSubCategories(), false);
                    this.subGroup.getElement().refreshPossibleValues(nodes);
                } else if (this.group.getElement().getSelectedItem() instanceof Node) {
                    Node node = (Node)this.group.getElement().getSelectedItem();
                    Node nodes = node.getChildNamed(ArticleCategoryComplete_.subCategories);
                    this.subGroup.getElement().refreshPossibleValues(nodes);
                } else {
                    this.subGroup.getElement().refreshPossibleValues(null);
                }
            }
        }
    }
}

