/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.stowinglisttemplate.labels;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.export.AsyncSimpleExportPopupInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.GenericStowingListReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.generic.GenericAnalysisReportType;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Font;
import java.sql.Date;
import java.sql.Timestamp;

public class StowingListLabelAnalysisComponent
extends AsyncSimpleExportPopupInsert<StowingListTemplateComplete> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> validityDate;

    public StowingListLabelAnalysisComponent(AnalysisSmartExternalOpenTool<StowingListTemplateComplete> subProv) {
        super(subProv);
    }

    @Override
    public void addOptionItems() {
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        Node dn = new Node();
        dn.setValue((Object)new Date(System.currentTimeMillis()), 0L);
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(dn), Words.VALIDITY, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new DateChooserAnalysisItem(this.validityDate, "dueDate"));
    }

    @Override
    public GenericAnalysisReportType getReportType() {
        return GenericAnalysisReportType.StowingListLabels;
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        GenericStowingListReportConfiguration conf = new GenericStowingListReportConfiguration();
        Date date = (Date)this.validityDate.getElement().getNode().getValue();
        conf.setDueDate(new Timestamp(date.getTime()));
        conf.setReportType(this.getReportType());
        return conf;
    }
}

