/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.stowinglisttemplate.sequence;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.DateChooserAnalysisItem;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;

public class StowingListTemplateSequenceAnalysisComponent
extends DefaultServerSideAnalysisComponent<StowingListTemplateComplete, StowingListTemplateReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<DateChooser> period;

    public StowingListTemplateSequenceAnalysisComponent(AnalysisSmartExternalOpenTool<StowingListTemplateComplete> defaultAnalysis) {
        super(defaultAnalysis, false, false);
    }

    @Override
    public void addOptionItems() {
        this.period = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Timestamp(System.currentTimeMillis()), false, false)), "Due Date", TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new DateChooserAnalysisItem(this.period, "dueDate"));
    }

    @Override
    public String getTitleString() {
        return Words.SEQUENCE;
    }

    @Override
    public String getTitleValue() {
        return Words.STOWING_LIST;
    }

    @Override
    public StowingListTemplateReference createReference(StowingListTemplateComplete item) {
        return new StowingListTemplateReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        ArrayList references = new ArrayList();
        Iterator s = this.getIterator();
        while (s.hasNext()) {
            references.add(s.next());
        }
        Timestamp p = new Timestamp(this.period.getElement().getSelectedDate().getTime());
        return (PegasusFileComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getStowingSequenceReport(new ListWrapper(references), new TimestampWrapper(p)).getValue();
    }
}

