/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.retail.invoice;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.services.interfaces.invoice.InvoiceServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.InvoiceReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.invoice.HistoricalInvoiceComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceReference;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceStateE;
import ch.icit.pegasus.server.core.dtos.report.InvoiceReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.InvoiceReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;

public class PrintRetailInvoiceComponent
extends DefaultScrollablePrintPopup2<FlightLight> {
    private static final long serialVersionUID = 1L;
    private Node<FlightLight> currentFlight;
    private InvoiceLight currentInvoice;
    private Node<InvoiceReportConfiguration> configNode;
    private TextLabel printOptionTitle;
    private TitledItem<CheckBox> titleOnly;
    private TitledItem<CheckBox> finalVersion;
    private TitledItem<CheckBox> includeNullValues;
    private TitledItem<CheckBox> groupTaxes;
    private RowModel<FlightLight> rowModel;
    private boolean invoiceClosedMode = false;

    public PrintRetailInvoiceComponent(Node<FlightLight> node, RowModel<FlightLight> m) {
        super(false, false, ReportTypeE.INVOICE);
        this.rowModel = m;
        this.currentFlight = node;
        this.loadBeforeShowing(() -> {
            try {
                this.currentInvoice = (InvoiceLight)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).getInvoiceForFlight(new FlightReference(((FlightLight)this.currentFlight.getValue()).getId())).getValue();
            }
            catch (ClientServerCallException e) {
                e.printStackTrace();
            }
            if (this.currentInvoice == null) {
                this.invoiceClosedMode = true;
                this.popup.hideScheduled(1000, "");
                InnerPopupFactory.showErrorDialog(ScreenValidationObject.createList((ScreenValidationObject[])new ScreenValidationObject[]{new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No Invoice for current Retail found")}), "Error", (Component)this);
            } else {
                this.initInvoiceClosedMode();
            }
        });
        InvoiceReportConfiguration config = new InvoiceReportConfiguration(ReportTypeE.INVOICE, null, null);
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    private void initInvoiceClosedMode() {
        HistoricalInvoiceComplete historic;
        this.invoiceClosedMode = this.currentInvoice.getState() == InvoiceStateE.PLANNED || this.currentInvoice.getState() == InvoiceStateE.CHECKED ? false : (historic = this.currentInvoice.getFinalData()) != null && !Boolean.TRUE.equals(this.currentInvoice.getHasError());
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        if (!this.invoiceClosedMode) {
            Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
            Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
            this.printOptionTitle = new TextLabel(Words.OPTIONS);
            this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
            this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
            this.titleOnly = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InvoiceReportConfiguration_.titlePageOnly)), Words.TITLE_PAGE_ONLY, TitledItem.TitledItemOrientation.EAST);
            this.titleOnly.setTitleFont(f);
            this.titleOnly.setTitleForeground(fb);
            this.titleOnly.getElement().setChecked(true);
            this.finalVersion = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InvoiceReportConfiguration_.finalVersion)), Words.PRINT_FINAL_VERSION_AND_CLOSE_INVOICE, TitledItem.TitledItemOrientation.EAST);
            this.finalVersion.setTitleFont(f);
            this.finalVersion.setTitleForeground(fb);
            this.includeNullValues = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InvoiceReportConfiguration_.includeNullValues)), Words.INCLUDE_NULL_VALUES, TitledItem.TitledItemOrientation.EAST);
            this.includeNullValues.setTitleFont(f);
            this.includeNullValues.setTitleForeground(fb);
            this.groupTaxes = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(InvoiceReportConfiguration_.totalTaxGroups)), Words.GROUP_TAXES, TitledItem.TitledItemOrientation.EAST);
            this.groupTaxes.setTitleFont(f);
            this.groupTaxes.setTitleForeground(fb);
            this.getViewContainer().add(this.printOptionTitle);
            this.getViewContainer().add(this.titleOnly);
            this.getViewContainer().add(this.finalVersion);
            this.getViewContainer().add(this.includeNullValues);
            this.getViewContainer().add(this.groupTaxes);
        }
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        if (!this.invoiceClosedMode) {
            for (String[] s : conf.getProperties()) {
                String n = s[0];
                String v = s[1];
                Boolean b = Boolean.valueOf(v);
                switch (n) {
                    case "title": {
                        this.titleOnly.getElement().setChecked(b);
                        break;
                    }
                    case "include_null_values": {
                        this.includeNullValues.getElement().setChecked(b);
                        break;
                    }
                    case "group_taxes": {
                        this.groupTaxes.getElement().setChecked(b);
                    }
                }
            }
            if (this.currentInvoice.getState() == InvoiceStateE.CANCELLED) {
                this.titleOnly.getElement().setChecked(true);
                this.finalVersion.getElement().setChecked(true);
            }
        }
    }

    @Override
    protected void setEnabledFromRemoteLoad(boolean isEnabled) {
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (!this.invoiceClosedMode) {
            boolean b;
            boolean bl = b = this.currentInvoice.getState() != InvoiceStateE.CREDIT_NOTE && isEnabled;
            if (((InvoiceReportConfiguration)this.configNode.getValue()).getReportType() == ReportTypeE.INVOICE) {
                this.titleOnly.setEnabled(isEnabled);
                this.finalVersion.setEnabled(isEnabled);
                this.includeNullValues.setEnabled(isEnabled);
                this.groupTaxes.setEnabled(isEnabled);
            } else if (((InvoiceReportConfiguration)this.configNode.getValue()).getReportType() == ReportTypeE.INVOICE_SOB_ONLY || ((InvoiceReportConfiguration)this.configNode.getValue()).getReportType() == ReportTypeE.INVOICE_COMPLEMENTARY) {
                this.titleOnly.setEnabled(b);
                this.finalVersion.setEnabled(b);
                this.includeNullValues.setEnabled(false);
                this.groupTaxes.setEnabled(false);
            } else {
                this.titleOnly.setEnabled(false);
                this.finalVersion.setEnabled(b);
                this.includeNullValues.setEnabled(false);
                this.groupTaxes.setEnabled(false);
            }
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        if (!this.invoiceClosedMode) {
            FilterChainConfiguration conf = new FilterChainConfiguration();
            conf.addProperty("title", "" + this.titleOnly.getElement().isChecked());
            conf.addProperty("include_null_values", "" + this.includeNullValues.getElement().isChecked());
            conf.addProperty("group_taxes", "" + this.groupTaxes.getElement().isChecked());
            return conf;
        }
        return null;
    }

    @Override
    public String getTitleString() {
        return Words.INVOICE;
    }

    @Override
    public String getTitleValue() {
        return "" + this.currentFlight.getChildNamed(FlightLight_.trackingNumber).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.titleOnly != null) {
            this.titleOnly.kill();
        }
        if (this.finalVersion != null) {
            this.finalVersion.kill();
        }
        if (this.includeNullValues != null) {
            this.includeNullValues.kill();
        }
        if (this.groupTaxes != null) {
            this.groupTaxes.kill();
        }
        this.printOptionTitle = null;
        this.titleOnly = null;
        this.finalVersion = null;
        this.includeNullValues = null;
        this.groupTaxes = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(true);
        }
        if (this.titleOnly != null) {
            this.titleOnly.setVisible(true);
        }
        if (this.finalVersion != null) {
            this.finalVersion.setVisible(true);
        }
        if (this.includeNullValues != null) {
            this.includeNullValues.setVisible(true);
        }
        if (this.groupTaxes != null) {
            this.groupTaxes.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(false);
        }
        if (this.titleOnly != null) {
            this.titleOnly.setVisible(false);
        }
        if (this.finalVersion != null) {
            this.finalVersion.setVisible(false);
        }
        if (this.includeNullValues != null) {
            this.includeNullValues.setVisible(false);
        }
        if (this.groupTaxes != null) {
            this.groupTaxes.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                if (!PrintRetailInvoiceComponent.this.invoiceClosedMode) {
                    InvoiceComplete invoice;
                    ReportFileComplete file = PrintRetailInvoiceComponent.this.getSelectedReport();
                    PrintRetailInvoiceComponent.this.configNode.commit();
                    InvoiceReportConfiguration config = (InvoiceReportConfiguration)PrintRetailInvoiceComponent.this.configNode.getValue();
                    config.setStylesheet(file);
                    config.setFormat(ReportingOutputFormatE.PDF);
                    config.setInvoice((InvoiceReference)PrintRetailInvoiceComponent.this.currentInvoice);
                    boolean wasClosing = false;
                    if (config.getFinalVersion().booleanValue() && PrintRetailInvoiceComponent.this.currentInvoice.getState() != InvoiceStateE.CLOSED && PrintRetailInvoiceComponent.this.currentInvoice.getState() != InvoiceStateE.CANCELLED && PrintRetailInvoiceComponent.this.currentInvoice.getState() != InvoiceStateE.CREDIT_NOTE) {
                        wasClosing = true;
                        PrintRetailInvoiceComponent.this.ensureAnimation("Close Invoice");
                        invoice = (InvoiceComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).getInvoice(new InvoiceReference(PrintRetailInvoiceComponent.this.currentInvoice.getId())).getValue();
                        invoice.setState(InvoiceStateE.CLOSED);
                        invoice = (InvoiceComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).updateInvoice(invoice).getValue();
                        FlightLight flight = (FlightLight)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlightLight(new FlightReference(((FlightLight)PrintRetailInvoiceComponent.this.currentFlight.getValue()).getId())).getValue();
                        PrintRetailInvoiceComponent.this.currentFlight.removeExistingValues();
                        PrintRetailInvoiceComponent.this.currentFlight.setValue((Object)flight, 0L);
                        PrintRetailInvoiceComponent.this.currentFlight.updateNode();
                    }
                    config.setInvoice((InvoiceReference)PrintRetailInvoiceComponent.this.currentInvoice);
                    if (Boolean.TRUE.equals(PrintRetailInvoiceComponent.this.currentInvoice.getHasError())) {
                        invoice = (InvoiceComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).getInvoice(new InvoiceReference(PrintRetailInvoiceComponent.this.currentInvoice.getId())).getValue();
                        invoice = (InvoiceComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).updateInvoice(invoice).getValue();
                    }
                    if (wasClosing) {
                        PrintRetailInvoiceComponent.this.ensureAnimation(PrintRetailInvoiceComponent.this.getProgressText());
                    }
                    PegasusFileComplete t = (PegasusFileComplete)((InvoiceReportServiceManager)ServiceManagerRegistry.getService(InvoiceReportServiceManager.class)).createInvoiceReport(config).getValue();
                    PrintRetailInvoiceComponent.this.processFile(t);
                    Node b = new Node();
                    b.setValue((Object)true, 0L);
                    return b;
                }
                InvoiceLight i = PrintRetailInvoiceComponent.this.currentInvoice;
                HistoricalInvoiceComplete historic = i.getFinalData();
                if (historic == null) {
                    throw new Exception(Words.NO_HISTORIC_DATA_FOUND);
                }
                PegasusFileComplete t = historic.getReport();
                PrintRetailInvoiceComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintRetailInvoiceComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
        this.rowModel.getView().refreshCells();
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.currentFlight;
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintRetailInvoiceComponent.this.layoutInheritedComponents(parent);
            if (PrintRetailInvoiceComponent.this.printOptionTitle != null) {
                PrintRetailInvoiceComponent.this.printOptionTitle.setLocation(PrintRetailInvoiceComponent.this.border, y + PrintRetailInvoiceComponent.this.border);
                PrintRetailInvoiceComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * PrintRetailInvoiceComponent.this.border, (int)PrintRetailInvoiceComponent.this.printOptionTitle.getPreferredSize().getHeight());
                y = PrintRetailInvoiceComponent.this.printOptionTitle.getY() + PrintRetailInvoiceComponent.this.printOptionTitle.getHeight();
            }
            if (PrintRetailInvoiceComponent.this.titleOnly != null) {
                PrintRetailInvoiceComponent.this.titleOnly.setLocation(PrintRetailInvoiceComponent.this.border, y + PrintRetailInvoiceComponent.this.border / 2);
                PrintRetailInvoiceComponent.this.titleOnly.setSize(parent.getWidth() - 2 * PrintRetailInvoiceComponent.this.border, (int)PrintRetailInvoiceComponent.this.titleOnly.getPreferredSize().getHeight());
                y = PrintRetailInvoiceComponent.this.titleOnly.getY() + PrintRetailInvoiceComponent.this.titleOnly.getHeight();
            }
            if (PrintRetailInvoiceComponent.this.finalVersion != null) {
                PrintRetailInvoiceComponent.this.finalVersion.setLocation(PrintRetailInvoiceComponent.this.border, y + PrintRetailInvoiceComponent.this.border / 2);
                PrintRetailInvoiceComponent.this.finalVersion.setSize((parent.getWidth() - 3 * PrintRetailInvoiceComponent.this.border) / 2, (int)PrintRetailInvoiceComponent.this.finalVersion.getPreferredSize().getHeight());
                y = PrintRetailInvoiceComponent.this.finalVersion.getY() + PrintRetailInvoiceComponent.this.finalVersion.getHeight();
            }
            if (PrintRetailInvoiceComponent.this.includeNullValues != null) {
                PrintRetailInvoiceComponent.this.includeNullValues.setLocation(PrintRetailInvoiceComponent.this.border, y + PrintRetailInvoiceComponent.this.border);
                PrintRetailInvoiceComponent.this.includeNullValues.setSize(parent.getWidth() - 2 * PrintRetailInvoiceComponent.this.border, (int)PrintRetailInvoiceComponent.this.includeNullValues.getPreferredSize().getHeight());
                y = PrintRetailInvoiceComponent.this.includeNullValues.getY() + PrintRetailInvoiceComponent.this.includeNullValues.getHeight();
            }
            if (PrintRetailInvoiceComponent.this.groupTaxes != null) {
                PrintRetailInvoiceComponent.this.groupTaxes.setLocation(PrintRetailInvoiceComponent.this.border, y + PrintRetailInvoiceComponent.this.border / 2);
                PrintRetailInvoiceComponent.this.groupTaxes.setSize(parent.getWidth() - 2 * PrintRetailInvoiceComponent.this.border, (int)PrintRetailInvoiceComponent.this.groupTaxes.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintRetailInvoiceComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintRetailInvoiceComponent.this.border;
            if (PrintRetailInvoiceComponent.this.printOptionTitle != null) {
                h = (int)((double)h + PrintRetailInvoiceComponent.this.printOptionTitle.getPreferredSize().getHeight());
                h += PrintRetailInvoiceComponent.this.border / 2;
            }
            if (PrintRetailInvoiceComponent.this.titleOnly != null) {
                h = (int)((double)h + PrintRetailInvoiceComponent.this.titleOnly.getPreferredSize().getHeight());
                h += PrintRetailInvoiceComponent.this.border / 2;
            }
            if (PrintRetailInvoiceComponent.this.finalVersion != null) {
                h = (int)((double)h + PrintRetailInvoiceComponent.this.finalVersion.getPreferredSize().getHeight());
                h += PrintRetailInvoiceComponent.this.border;
            }
            if (PrintRetailInvoiceComponent.this.includeNullValues != null) {
                h = (int)((double)h + PrintRetailInvoiceComponent.this.includeNullValues.getPreferredSize().getHeight());
                h += PrintRetailInvoiceComponent.this.border / 2;
            }
            if (PrintRetailInvoiceComponent.this.groupTaxes != null) {
                h = (int)((double)h + PrintRetailInvoiceComponent.this.groupTaxes.getPreferredSize().getHeight());
                h += PrintRetailInvoiceComponent.this.border / 2;
            }
            return new Dimension(w, h);
        }
    }
}

