/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.sob.reconciliationoverview;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.report.SalesOnBoardReconciliationOverviewReportConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class PrintSobReconciliationOverviewComponent
extends DefaultScrollablePrintPopup2<FlightLight> {
    private static final long serialVersionUID = 1L;
    private FlightLight dto;
    private TitledItem<CheckBox> includeProductUsage;

    public PrintSobReconciliationOverviewComponent(FlightLight dto) {
        super(true, true, false, false, ReportTypeE.SOB_RECONCILIATION_OVERVIEW);
        this.dto = dto;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public String getTitleString() {
        return "Flight No.";
    }

    @Override
    public String getTitleValue() {
        return this.dto.getOutboundCode();
    }

    @Override
    public void createComponents() {
        super.createComponents();
        this.getViewContainer().setLayout(new Layout());
        this.includeProductUsage = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_INVENTORY_DISCREPANCY, TitledItem.TitledItemOrientation.EAST);
        this.getViewContainer().add(this.includeProductUsage);
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.includeProductUsage);
        return focusList;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return new Object[0];
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.includeProductUsage != null) {
            this.includeProductUsage.kill();
        }
        this.includeProductUsage = null;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                SalesOnBoardReconciliationOverviewReportConfiguration config = new SalesOnBoardReconciliationOverviewReportConfiguration();
                config.setFlight((FlightReference)PrintSobReconciliationOverviewComponent.this.dto);
                config.setStylesheet(PrintSobReconciliationOverviewComponent.this.getSelectedReport());
                if (PrintSobReconciliationOverviewComponent.this.includeProductUsage != null) {
                    config.setIncludeProductUsage(Boolean.valueOf(((CheckBox)PrintSobReconciliationOverviewComponent.this.includeProductUsage.getElement()).isChecked()));
                }
                PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createSobReconciliationOverview(config).getValue();
                PrintSobReconciliationOverviewComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintSobReconciliationOverviewComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return INodeCreator.getDefaultImpl().getNode4DTO((Object)this.dto, false, false);
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public void insertElements() {
        this.createComponents();
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.includeProductUsage != null) {
            this.includeProductUsage.setVisible(false);
        }
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        if (this.includeProductUsage != null) {
            for (String[] s : conf.getProperties()) {
                String n = s[0];
                String v = s[1];
                Boolean b = Boolean.valueOf(v);
                if (!n.equals("includeProductUsage")) continue;
                this.includeProductUsage.getElement().setChecked(b);
            }
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        if (this.includeProductUsage != null) {
            conf.addProperty("includeProductUsage", "" + this.includeProductUsage.getElement().isChecked());
        }
        return conf;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintSobReconciliationOverviewComponent.this.layoutInheritedComponents(parent);
            y += PrintSobReconciliationOverviewComponent.this.border;
            if (PrintSobReconciliationOverviewComponent.this.includeProductUsage != null) {
                PrintSobReconciliationOverviewComponent.this.includeProductUsage.setLocation(PrintSobReconciliationOverviewComponent.this.border, y);
                PrintSobReconciliationOverviewComponent.this.includeProductUsage.setSize(PrintSobReconciliationOverviewComponent.this.includeProductUsage.getPreferredSize());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(100, 150);
        }
    }
}

