/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.store.abc;

import ch.icit.pegasus.client.converter.ArticleReportTypeConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.TitledCategoryChooser;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.tables.StoreSearchTable;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryLight;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryReference;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.ABCAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ABCAnalysisReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.report.ArticleReportTypeE;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.BasicArticleSearchConfiguration_;
import ch.icit.pegasus.server.core.dtos.search.StoreSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.TimestampWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;

public class PrintABCStoreComponent
extends DefaultScrollablePrintPopup2<StoreLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TextLabel storeSection;
    private StoreSearchTable stores;
    private TitledItem<CheckBox> includeAllStores;
    private TitledItem<ComboBox> typeBox;
    private HorizontalSeparator sep1;
    private TitledPeriodEditor period;
    private TextLabel articleSection;
    private TitledItem<SearchTextField2> customerSearch;
    private TitledItem<CheckBox> customerOwned;
    private TitledCategoryChooser categories;
    private TitledItem<SearchTextField2> supplier;
    private TitledItem<CheckBox> includeInuseOnly;
    private TitledItem<CheckBox> includeAllArticles;
    private TitledItem<CheckBox> includeOverflow;
    private TitledItem<CheckBox> includeZeroValue;
    private Node configNode;

    public PrintABCStoreComponent() {
        super(false, true, false, ReportTypeE.ABC_ANALYSIS);
        ABCAnalysisReportConfiguration config = new ABCAnalysisReportConfiguration();
        config.setArticleConfig(new BasicArticleSearchConfiguration());
        config.setStoreConfig(new StoreSearchConfiguration());
        config.setPeriod(new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())));
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
        for (String[] s : conf.getProperties()) {
            String n = s[0];
            String v = s[1];
            Boolean b = Boolean.valueOf(v);
            if (n.equals("all")) {
                this.includeAllArticles.getElement().setChecked(b);
                continue;
            }
            if (!n.equals("active")) continue;
            this.includeInuseOnly.getElement().setChecked(b);
        }
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        conf.addProperty("all", "" + this.includeAllArticles.getElement().isChecked());
        conf.addProperty("active", "" + this.includeInuseOnly.getElement().isChecked());
        return conf;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.typeBox = new TitledItem<ComboBox>(new ComboBox(this.configNode.getChildNamed(ABCAnalysisReportConfiguration_.type), NodeToolkit.getAffixList(ArticleReportTypeE.class), ConverterRegistry.getConverter(ArticleReportTypeConverter.class)), "Type", TitledItem.TitledItemOrientation.NORTH);
        this.storeSection = new TextLabel(Words.CHOOSE_STORES);
        this.stores = new StoreSearchTable();
        this.stores.setNode((Node<List<StoreLight>>)this.configNode.getChildNamed(ABCAnalysisReportConfiguration_.stores));
        this.includeAllStores = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(ABCAnalysisReportConfiguration_.useStoreSearch)), Words.USE_ALL_STORES, TitledItem.TitledItemOrientation.EAST);
        this.sep1 = new HorizontalSeparator();
        this.articleSection = new TextLabel(Words.CHOOSE_ARTICLES);
        this.customerSearch = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, new DTOProxyNode()), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.customerSearch.getElement().setNode(this.configNode.getChildNamed(new DtoField[]{ABCAnalysisReportConfiguration_.articleConfig, BasicArticleSearchConfiguration_.customer}));
        this.customerOwned = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(new DtoField[]{ABCAnalysisReportConfiguration_.articleConfig, BasicArticleSearchConfiguration_.customerOwned})), Words.CUSTOMER_OWNED_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.categories = new TitledCategoryChooser((Node)new DTOProxyNode(), NodeToolkit.getAffixList(ArticleCategoryComplete.class), TitledCategoryChooser.getTypeForSettings(TitledCategoryChooser.CATEGORY_TYPE.ARTICLE), true);
        this.categories.setProgress(1.0f);
        this.supplier = new TitledItem<SearchTextField2<SupplierLight>>(SearchTextField2Factory.getSupplierSearchField(true, new DTOProxyNode()), Words.SUPPLIER, TitledItem.TitledItemOrientation.NORTH);
        this.supplier.getElement().setNode(this.configNode.getChildNamed(new DtoField[]{ABCAnalysisReportConfiguration_.articleConfig, BasicArticleSearchConfiguration_.supplier}));
        this.includeAllArticles = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ALL_ARTICLES, TitledItem.TitledItemOrientation.EAST);
        this.includeAllArticles.getElement().setChecked(true);
        this.includeAllArticles.getElement().addButtonListener(this);
        this.includeInuseOnly = new TitledItem<CheckBox>(new CheckBox(), Words.ACTIVE_ARTICLES_ONLY, TitledItem.TitledItemOrientation.EAST);
        this.includeZeroValue = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(ABCAnalysisReportConfiguration_.includeZeroValue)), Words.INCLUDE_ZERO_VALUE, TitledItem.TitledItemOrientation.EAST);
        this.includeOverflow = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)this.configNode.getChildNamed(ABCAnalysisReportConfiguration_.includeOverflow)), Words.INCLUDE_OVERFLOW, TitledItem.TitledItemOrientation.EAST);
        this.period = new TitledPeriodEditor((Node<PeriodComplete>)this.configNode.getChildNamed(ABCAnalysisReportConfiguration_.period), true, null);
        this.getViewContainer().add(this.typeBox);
        this.getViewContainer().add(this.storeSection);
        this.getViewContainer().add(this.stores);
        this.getViewContainer().add(this.includeAllStores);
        this.getViewContainer().add(this.sep1);
        this.getViewContainer().add(this.articleSection);
        this.getViewContainer().add(this.period);
        this.getViewContainer().add(this.customerSearch);
        this.getViewContainer().add(this.customerOwned);
        this.getViewContainer().add(this.categories);
        this.getViewContainer().add(this.supplier);
        this.getViewContainer().add(this.includeAllArticles);
        this.getViewContainer().add(this.includeZeroValue);
        this.getViewContainer().add(this.includeOverflow);
        this.getViewContainer().add(this.includeInuseOnly);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.typeBox != null) {
            this.typeBox.setEnabled(isEnabled);
            this.storeSection.setEnabled(isEnabled);
            this.stores.setEnabled(isEnabled);
            this.includeAllStores.setEnabled(isEnabled);
            this.sep1.setEnabled(isEnabled);
            this.articleSection.setEnabled(isEnabled);
            this.period.setEnabled(isEnabled);
            this.includeAllArticles.setEnabled(isEnabled);
            boolean b = isEnabled && !this.includeAllArticles.getElement().isChecked();
            this.includeInuseOnly.setEnabled(isEnabled);
            this.customerSearch.setEnabled(b);
            this.customerOwned.setEnabled(b);
            this.categories.setEnabled(b);
            this.supplier.setEnabled(b);
            this.includeZeroValue.setEnabled(b);
            this.includeOverflow.setEnabled(b);
        }
    }

    @Override
    public String getTitleString() {
        return Words.REPORTING;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        if (this.categories != null && this.categories.isInnerComponent(c)) {
            return true;
        }
        if (this.typeBox != null && this.typeBox.getElement().getCurrentPopUp() != null) {
            for (Component currentC = c; currentC != null; currentC = currentC.getParent()) {
                if (!currentC.equals(this.typeBox.getElement().getCurrentPopUp())) continue;
                return true;
            }
        }
        return super.isInnerComponent(c);
    }

    @Override
    public String getTitleValue() {
        return Words.ABC_ANALYSIS;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.storeSection != null) {
            this.storeSection.kill();
        }
        if (this.stores != null) {
            this.stores.kill();
        }
        if (this.includeAllStores != null) {
            this.includeAllStores.kill();
        }
        if (this.sep1 != null) {
            this.sep1.kill();
        }
        if (this.articleSection != null) {
            this.articleSection.kill();
        }
        if (this.customerSearch != null) {
            this.customerSearch.kill();
        }
        if (this.customerOwned != null) {
            this.customerOwned.kill();
        }
        if (this.categories != null) {
            this.categories.kill();
        }
        if (this.supplier != null) {
            this.supplier.kill();
        }
        if (this.includeAllArticles != null) {
            this.includeAllArticles.kill();
        }
        if (this.includeOverflow != null) {
            this.includeOverflow.kill();
        }
        if (this.includeZeroValue != null) {
            this.includeZeroValue.kill();
        }
        if (this.typeBox != null) {
            this.typeBox.kill();
        }
        if (this.includeInuseOnly != null) {
            this.includeInuseOnly.kill();
        }
        if (this.period != null) {
            this.period.kill();
        }
        this.storeSection = null;
        this.stores = null;
        this.includeInuseOnly = null;
        this.includeAllStores = null;
        this.sep1 = null;
        this.articleSection = null;
        this.customerSearch = null;
        this.customerOwned = null;
        this.categories = null;
        this.supplier = null;
        this.includeAllArticles = null;
        this.includeOverflow = null;
        this.includeZeroValue = null;
        this.typeBox = null;
        this.period = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.storeSection != null) {
            this.storeSection.setVisible(true);
        }
        if (this.stores != null) {
            this.stores.setVisible(true);
        }
        if (this.includeAllStores != null) {
            this.includeAllStores.setVisible(true);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(true);
        }
        if (this.articleSection != null) {
            this.articleSection.setVisible(true);
        }
        if (this.customerSearch != null) {
            this.customerSearch.setVisible(true);
        }
        if (this.customerOwned != null) {
            this.customerOwned.setVisible(true);
        }
        if (this.categories != null) {
            this.categories.setVisible(true);
        }
        if (this.includeInuseOnly != null) {
            this.includeInuseOnly.setVisible(true);
        }
        if (this.supplier != null) {
            this.supplier.setVisible(true);
        }
        if (this.includeAllArticles != null) {
            this.includeAllArticles.setVisible(true);
        }
        if (this.includeOverflow != null) {
            this.includeOverflow.setVisible(true);
        }
        if (this.includeZeroValue != null) {
            this.includeZeroValue.setVisible(true);
        }
        if (this.typeBox != null) {
            this.typeBox.setVisible(true);
        }
        if (this.period != null) {
            this.period.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.storeSection != null) {
            this.storeSection.setVisible(false);
        }
        if (this.stores != null) {
            this.stores.setVisible(false);
        }
        if (this.includeAllStores != null) {
            this.includeAllStores.setVisible(false);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(false);
        }
        if (this.includeInuseOnly != null) {
            this.includeInuseOnly.setVisible(false);
        }
        if (this.articleSection != null) {
            this.articleSection.setVisible(false);
        }
        if (this.customerSearch != null) {
            this.customerSearch.setVisible(false);
        }
        if (this.customerOwned != null) {
            this.customerOwned.setVisible(false);
        }
        if (this.categories != null) {
            this.categories.setVisible(false);
        }
        if (this.supplier != null) {
            this.supplier.setVisible(false);
        }
        if (this.includeAllArticles != null) {
            this.includeAllArticles.setVisible(false);
        }
        if (this.includeOverflow != null) {
            this.includeOverflow.setVisible(false);
        }
        if (this.includeZeroValue != null) {
            this.includeZeroValue.setVisible(false);
        }
        if (this.typeBox != null) {
            this.typeBox.setVisible(false);
        }
        if (this.period != null) {
            this.period.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintABCStoreComponent.this.getSelectedReport();
                PrintABCStoreComponent.this.configNode.commit();
                ABCAnalysisReportConfiguration config = (ABCAnalysisReportConfiguration)PrintABCStoreComponent.this.configNode.getValue();
                config.setStylesheet(file);
                if (((RadioButton)PrintABCStoreComponent.this.asXLS.getElement()).isChecked()) {
                    config.setFormat(ReportingOutputFormatE.XLSX);
                } else {
                    config.setFormat(ReportingOutputFormatE.PDF);
                }
                config.setAllArticles(Boolean.valueOf(((CheckBox)PrintABCStoreComponent.this.includeAllArticles.getElement()).isChecked()));
                if (((CheckBox)PrintABCStoreComponent.this.includeAllArticles.getElement()).isChecked()) {
                    config.setArticleConfig(new BasicArticleSearchConfiguration());
                } else {
                    ArticleCategoryLight l = (ArticleCategoryLight)PrintABCStoreComponent.this.categories.getNode().getValue();
                    if (l != null) {
                        config.getArticleConfig().setOwnershipCategory(new ArticleCategoryReference(l.getId()));
                        if (l.getParent() != null) {
                            config.getArticleConfig().setTemperatureCategory(new ArticleCategoryReference(l.getParent().getId()));
                            if (l.getParent().getParent() != null) {
                                config.getArticleConfig().setAttribute3Category(new ArticleCategoryReference(l.getParent().getParent().getId()));
                            }
                        }
                    }
                }
                config.getArticleConfig().setInUse(Boolean.valueOf(((CheckBox)PrintABCStoreComponent.this.includeInuseOnly.getElement()).isChecked()));
                Timestamp validityDate = new Timestamp(System.currentTimeMillis());
                PegasusFileComplete t = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createABCAnalysisReport(config, new TimestampWrapper(validityDate)).getValue();
                PrintABCStoreComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintABCStoreComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<StoreLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<StoreLight> createBatchJob(Node<StoreLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        return this.period.validateContent();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintABCStoreComponent.this.layoutInheritedComponents(parent) + PrintABCStoreComponent.this.border;
            if (PrintABCStoreComponent.this.typeBox != null) {
                PrintABCStoreComponent.this.typeBox.setLocation(PrintABCStoreComponent.this.border, y);
                PrintABCStoreComponent.this.typeBox.setSize(parent.getWidth() - 2 * PrintABCStoreComponent.this.border, (int)PrintABCStoreComponent.this.typeBox.getPreferredSize().getHeight());
                PrintABCStoreComponent.this.storeSection.setLocation(PrintABCStoreComponent.this.border, PrintABCStoreComponent.this.typeBox.getY() + PrintABCStoreComponent.this.typeBox.getHeight() + PrintABCStoreComponent.this.border);
                PrintABCStoreComponent.this.storeSection.setSize(parent.getWidth() - 2 * PrintABCStoreComponent.this.border, (int)PrintABCStoreComponent.this.storeSection.getPreferredSize().getHeight());
                PrintABCStoreComponent.this.stores.setLocation(PrintABCStoreComponent.this.border, PrintABCStoreComponent.this.storeSection.getY() + PrintABCStoreComponent.this.storeSection.getHeight() + PrintABCStoreComponent.this.border / 2);
                PrintABCStoreComponent.this.stores.setSize(parent.getWidth() - 2 * PrintABCStoreComponent.this.border, 200);
                PrintABCStoreComponent.this.includeAllStores.setLocation(PrintABCStoreComponent.this.border, PrintABCStoreComponent.this.stores.getY() + PrintABCStoreComponent.this.stores.getHeight() + PrintABCStoreComponent.this.border / 2);
                PrintABCStoreComponent.this.includeAllStores.setSize(parent.getWidth() - 2 * PrintABCStoreComponent.this.border, (int)PrintABCStoreComponent.this.includeAllStores.getPreferredSize().getHeight());
                PrintABCStoreComponent.this.sep1.setLocation(0, PrintABCStoreComponent.this.includeAllStores.getY() + PrintABCStoreComponent.this.includeAllStores.getHeight() + PrintABCStoreComponent.this.border / 2);
                PrintABCStoreComponent.this.sep1.setSize(parent.getWidth(), (int)PrintABCStoreComponent.this.sep1.getPreferredSize().getHeight());
                PrintABCStoreComponent.this.articleSection.setLocation(PrintABCStoreComponent.this.border, PrintABCStoreComponent.this.sep1.getY() + PrintABCStoreComponent.this.sep1.getHeight() + PrintABCStoreComponent.this.border);
                PrintABCStoreComponent.this.articleSection.setSize(parent.getWidth() - 2 * PrintABCStoreComponent.this.border, (int)PrintABCStoreComponent.this.articleSection.getPreferredSize().getHeight());
                PrintABCStoreComponent.this.period.setLocation(PrintABCStoreComponent.this.border, PrintABCStoreComponent.this.articleSection.getY() + PrintABCStoreComponent.this.articleSection.getHeight() + PrintABCStoreComponent.this.border);
                PrintABCStoreComponent.this.period.setSize(parent.getWidth() - 2 * PrintABCStoreComponent.this.border, (int)PrintABCStoreComponent.this.period.getPreferredSize().getHeight());
                PrintABCStoreComponent.this.includeAllArticles.setLocation(PrintABCStoreComponent.this.border, PrintABCStoreComponent.this.period.getY() + PrintABCStoreComponent.this.period.getHeight() + PrintABCStoreComponent.this.border);
                PrintABCStoreComponent.this.includeAllArticles.setSize(parent.getWidth() - 2 * PrintABCStoreComponent.this.border, (int)PrintABCStoreComponent.this.includeAllArticles.getPreferredSize().getHeight());
                PrintABCStoreComponent.this.includeInuseOnly.setLocation(PrintABCStoreComponent.this.border, PrintABCStoreComponent.this.includeAllArticles.getY() + PrintABCStoreComponent.this.includeAllArticles.getHeight() + PrintABCStoreComponent.this.border / 2);
                PrintABCStoreComponent.this.includeInuseOnly.setSize(parent.getWidth() - 2 * PrintABCStoreComponent.this.border, (int)PrintABCStoreComponent.this.includeInuseOnly.getPreferredSize().getHeight());
                PrintABCStoreComponent.this.customerSearch.setLocation(PrintABCStoreComponent.this.border, PrintABCStoreComponent.this.includeInuseOnly.getY() + PrintABCStoreComponent.this.includeInuseOnly.getHeight() + PrintABCStoreComponent.this.border);
                PrintABCStoreComponent.this.customerSearch.setSize(parent.getWidth() - 2 * PrintABCStoreComponent.this.border, (int)PrintABCStoreComponent.this.customerSearch.getPreferredSize().getHeight());
                PrintABCStoreComponent.this.customerOwned.setLocation(PrintABCStoreComponent.this.border, PrintABCStoreComponent.this.customerSearch.getY() + PrintABCStoreComponent.this.customerSearch.getHeight() + 3);
                PrintABCStoreComponent.this.customerOwned.setSize(parent.getWidth() - 2 * PrintABCStoreComponent.this.border, (int)PrintABCStoreComponent.this.customerOwned.getPreferredSize().getHeight());
                PrintABCStoreComponent.this.categories.setLocation(PrintABCStoreComponent.this.border, PrintABCStoreComponent.this.customerOwned.getY() + PrintABCStoreComponent.this.customerOwned.getHeight() + PrintABCStoreComponent.this.border / 2);
                PrintABCStoreComponent.this.categories.setSize(parent.getWidth() - 2 * PrintABCStoreComponent.this.border, (int)PrintABCStoreComponent.this.categories.getPreferredSize().getHeight());
                PrintABCStoreComponent.this.supplier.setLocation(PrintABCStoreComponent.this.border, PrintABCStoreComponent.this.categories.getY() + PrintABCStoreComponent.this.categories.getHeight() + PrintABCStoreComponent.this.border / 2);
                PrintABCStoreComponent.this.supplier.setSize(parent.getWidth() - 2 * PrintABCStoreComponent.this.border, (int)PrintABCStoreComponent.this.supplier.getPreferredSize().getHeight());
                PrintABCStoreComponent.this.includeOverflow.setLocation(PrintABCStoreComponent.this.border, PrintABCStoreComponent.this.supplier.getY() + PrintABCStoreComponent.this.supplier.getHeight() + PrintABCStoreComponent.this.border);
                PrintABCStoreComponent.this.includeOverflow.setSize(parent.getWidth() - 2 * PrintABCStoreComponent.this.border, (int)PrintABCStoreComponent.this.includeOverflow.getPreferredSize().getHeight());
                PrintABCStoreComponent.this.includeZeroValue.setLocation(PrintABCStoreComponent.this.border, PrintABCStoreComponent.this.includeOverflow.getY() + PrintABCStoreComponent.this.includeOverflow.getHeight() + PrintABCStoreComponent.this.border / 2);
                PrintABCStoreComponent.this.includeZeroValue.setSize(parent.getWidth() - 2 * PrintABCStoreComponent.this.border, (int)PrintABCStoreComponent.this.includeZeroValue.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintABCStoreComponent.this.getInheritedComponentsHeight();
            int w = 250;
            if (PrintABCStoreComponent.this.typeBox != null) {
                h = (int)((double)h + PrintABCStoreComponent.this.typeBox.getPreferredSize().getHeight());
                h += PrintABCStoreComponent.this.border;
                h = (int)((double)h + PrintABCStoreComponent.this.storeSection.getPreferredSize().getHeight());
                h += PrintABCStoreComponent.this.border / 2;
                h += 200;
                h += 3;
                h = (int)((double)h + PrintABCStoreComponent.this.includeAllStores.getPreferredSize().getHeight());
                h += PrintABCStoreComponent.this.border / 2;
                h = (int)((double)h + PrintABCStoreComponent.this.sep1.getPreferredSize().getHeight());
                h += PrintABCStoreComponent.this.border;
                h = (int)((double)h + PrintABCStoreComponent.this.articleSection.getPreferredSize().getHeight());
                h += PrintABCStoreComponent.this.border;
                h = (int)((double)h + PrintABCStoreComponent.this.period.getPreferredSize().getHeight());
                h += PrintABCStoreComponent.this.border;
                h = (int)((double)h + PrintABCStoreComponent.this.includeAllArticles.getPreferredSize().getHeight());
                h += PrintABCStoreComponent.this.border / 2;
                h = (int)((double)h + PrintABCStoreComponent.this.includeInuseOnly.getPreferredSize().getHeight());
                h += PrintABCStoreComponent.this.border;
                h = (int)((double)h + PrintABCStoreComponent.this.customerSearch.getPreferredSize().getHeight());
                h += 3;
                h = (int)((double)h + PrintABCStoreComponent.this.customerOwned.getPreferredSize().getHeight());
                h += PrintABCStoreComponent.this.border / 2;
                h = (int)((double)h + PrintABCStoreComponent.this.categories.getPreferredSize().getHeight());
                h += PrintABCStoreComponent.this.border / 2;
                h = (int)((double)h + PrintABCStoreComponent.this.supplier.getPreferredSize().getHeight());
                h += PrintABCStoreComponent.this.border;
                h = (int)((double)h + PrintABCStoreComponent.this.includeOverflow.getPreferredSize().getHeight());
                h += PrintABCStoreComponent.this.border / 2;
                h = (int)((double)h + PrintABCStoreComponent.this.includeZeroValue.getPreferredSize().getHeight());
                h += PrintABCStoreComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

