/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.weeklyplan.recipe;

import ch.icit.pegasus.client.converter.QuantityConverter0Decimal;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ProductionJobComplete_;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ProductionItemSelectionTable
extends Table2 {
    public ProductionItemSelectionTable() {
        super(false, "");
        this.setComparator((o1, o2) -> {
            String type2;
            String type1 = (String)o1.getModel().getNode().getChildNamed(ProductionJobComplete_.jobTypeString).getValue();
            int i = type1.compareTo(type2 = (String)o2.getModel().getNode().getChildNamed(ProductionJobComplete_.jobTypeString).getValue());
            if (i == 0) {
                String number1 = (String)o1.getModel().getNode().getChildNamed(ProductionJobComplete_.jobItemNumber).getValue();
                String number2 = (String)o2.getModel().getNode().getChildNamed(ProductionJobComplete_.jobItemNumber).getValue();
                return number1.compareTo(number2);
            }
            return i;
        });
        this.setModel(new Table2Model(this.getColumns(), model -> new TableRowImpl(model)));
    }

    private List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("", null, null, null, "", TableColumnInfo.checkColumnWith));
        columns.add(new TableColumnInfo("Type", null, null, null, "", 120));
        columns.add(new TableColumnInfo("Number", null, null, null, "", 120));
        columns.add(new TableColumnInfo("Name", null, null, null, "", 120, Integer.MAX_VALUE, Integer.MAX_VALUE));
        columns.add(new TableColumnInfo("Quantity", null, null, null, "", 120));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        return columns;
    }

    public List<JobComplete> getJobs() {
        ArrayList<JobComplete> jobs = new ArrayList<JobComplete>();
        for (Table2RowPanel row : this.getRowsFailSafe()) {
            TableRowImpl r = (TableRowImpl)row;
            if (!r.print.isChecked()) continue;
            jobs.add((JobComplete)r.getModel().getNode().getValue());
        }
        return jobs;
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private CheckBox print;
        private TextLabel number;
        private TextLabel name;
        private TextLabel type;
        private TextLabel quantity;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.print = new CheckBox();
            this.number = new TextLabel();
            this.name = new TextLabel();
            this.type = new TextLabel();
            this.quantity = new TextLabel(m.getNode().getChildNamed(ProductionJobComplete_.quantity), ConverterRegistry.getConverter(QuantityConverter0Decimal.class));
            JobComplete job = (JobComplete)m.getNode().getValue();
            this.number.setNode(m.getNode().getChildNamed(ProductionJobComplete_.jobItemNumber));
            this.name.setNode(m.getNode().getChildNamed(ProductionJobComplete_.jobName));
            this.type.setNode(m.getNode().getChildNamed(ProductionJobComplete_.jobTypeString));
            this.setLayout(new Layout());
            this.add(this.print);
            this.add(this.number);
            this.add(this.name);
            this.add(this.type);
            this.add(this.quantity);
        }

        @Override
        public Object getObject4Column(int column) {
            return this.model.getNode().getChildNamed(ProductionJobComplete_.jobItemNumber).getValue();
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                TableRowImpl.this.print.setLocation((int)(((double)w - TableRowImpl.this.print.getPreferredSize().getWidth()) / 2.0), (int)(((double)parent.getHeight() - TableRowImpl.this.print.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.print.setSize(TableRowImpl.this.print.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(1);
                TableRowImpl.this.type.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.type.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.type.setSize(TableRowImpl.this.type.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(2);
                TableRowImpl.this.number.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.number.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.number.setSize(TableRowImpl.this.number.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(3);
                TableRowImpl.this.name.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(TableRowImpl.this.name.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(4);
                TableRowImpl.this.quantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.quantity.setSize(TableRowImpl.this.quantity.getPreferredSize());
            }
        }
    }
}

