/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.PegasusSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.utils.TextFieldComparator;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.LinearFunctionSetQuantityCalculationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.delivery.StepFunctionQuantityCalculationComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.DeliveryInstructionComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PaxTable5
extends JPanelKillable
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private Table2 table;
    private Node rootNode;
    private Node seatConfiguration;
    private CabinClassComplete preChoosenCC;
    private PegasusSubModule screen;

    public PaxTable5(Node node, boolean hasBackground, boolean hasTitle, String titleName, int scrolling) {
        this.rootNode = node;
        this.setLayout(new Layout());
        this.table = new Table2(true, Words.ADD_PAX_CLASS, hasBackground, hasTitle, titleName);
        this.table.setHasBackground(true);
        this.table.setRequestFocusOnAdd(true);
        this.table.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                PaxTable5.this.checkIfAddofMoreClassesIsPossible();
                PaxTable5.this.validate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                CabinClassComplete cc = PaxTable5.this.preChoosenCC;
                if (cc == null) {
                    cc = PaxTable5.this.getUnusedCabinClass();
                } else {
                    PaxTable5.this.preChoosenCC = null;
                }
                SeatConfigurationComplete scc = new SeatConfigurationComplete(Integer.valueOf(0), cc);
                scc.setClientOId(Long.valueOf(ADTO.getNextId()));
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)scc, true, false);
                PaxTable5.this.seatConfiguration.addChild(n, System.currentTimeMillis());
                PaxTable5.this.revalidateCombos();
                PaxTable5.this.checkIfAddofMoreClassesIsPossible();
                PaxTable5.this.validate();
            }
        });
        this.table.setDontUseScrollBar(scrolling);
        this.setOpaque(false);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(0.3, 0.0, Words.CLASS, "", null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(0.7, 0.0, "PAX COUNT", "", null, null, "", 40, 40, 40));
        int delWidth = DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo(0.0, 0.0, "", "", null, null, "", delWidth += this.table.getCellPadding() * 2, delWidth, delWidth));
        Table2Model model = new Table2Model(columns, true){

            @Override
            public Table2RowPanel getEffectedRow(Node IReadableNodeAdd) {
                CabinClassComplete dto = (CabinClassComplete)IReadableNodeAdd.getChildNamed(new String[]{"cabinClass"}).getValue();
                for (Table2RowPanel row : PaxTable5.this.table.getRows()) {
                    TableRow r = (TableRow)row;
                    if (!r.usesThisCabinClass(dto)) continue;
                    return r;
                }
                return null;
            }

            @Override
            public boolean needsNewRow(Node IReadableNodeAdd) {
                CabinClassComplete dto = (CabinClassComplete)IReadableNodeAdd.getChildNamed(new String[]{"cabinClass"}).getValue();
                for (Table2RowPanel row : PaxTable5.this.table.getRows()) {
                    TableRow r = (TableRow)row;
                    if (!r.usesThisCabinClass(dto)) continue;
                    return false;
                }
                return true;
            }
        };
        model.setTransposed(true);
        model.setViewFactory(model1 -> new TableRow(model1));
        this.table.setModel(model);
        this.add(this.table);
        this.table.fadeIn();
        this.setNode(this.rootNode);
        this.checkIfAddofMoreClassesIsPossible();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.checkIfAddofMoreClassesIsPossible();
        }
    }

    public void checkIfAddofMoreClassesIsPossible() {
        if (NodeToolkit.getAffixList(CabinClassComplete.class) != null) {
            int c = NodeToolkit.getAffixList(CabinClassComplete.class).getChildCount();
            this.table.enableAddButton(c != this.table.getRowCount() && (this.screen == null || !this.screen.isLocked()));
        }
    }

    protected void revalidateCombos() {
        List<Node> list = this.getAllUsedCabinClasses();
        for (Table2RowPanel row : this.table.getRows()) {
            TableRow r = (TableRow)row;
            r.setUsableComboClasses(list);
        }
    }

    private List<Node> getAllUsedCabinClasses() {
        ArrayList<Node> list = new ArrayList<Node>();
        for (Table2RowPanel row : this.table.getRows()) {
            list.add(row.getModel().getNode().getChildNamed(new String[]{"cabinClass"}));
        }
        return list;
    }

    public void setScreen(PegasusSubModule screen) {
        this.screen = screen;
    }

    public void setNode(Node node) {
        if (this.rootNode != null) {
            this.rootNode.removeNodeListener((NodeListener)this);
            this.rootNode = null;
        }
        this.rootNode = node;
        if (this.rootNode != null) {
            this.rootNode.addNodeListener((NodeListener)this);
            this.childAdded(this.rootNode, this.rootNode.getChildNamed(new String[]{"seatConfigurations"}));
            this.table.getModel().setNode(this.seatConfiguration);
            this.checkIfAddofMoreClassesIsPossible();
            this.revalidateCombos();
        }
    }

    public List<Component> getFocusComponents() {
        return this.table.getFocusComponents();
    }

    private CabinClassComplete getUnusedCabinClass() {
        Iterator it = NodeToolkit.getAffixList(CabinClassComplete.class).getChilds();
        while (it.hasNext()) {
            Node cc = (Node)it.next();
            Iterator<Table2RowPanel> it2 = this.table.getRows().iterator();
            boolean found = false;
            while (it2.hasNext() && !found) {
                Table2RowPanel row = it2.next();
                if (!row.getModel().getNode().getChildNamed(new String[]{"cabinClass"}).getValue().equals(cc.getValue())) continue;
                found = true;
            }
            if (found) continue;
            return (CabinClassComplete)cc.getValue();
        }
        return null;
    }

    public void childAdded(Node<?> source, Node<?> child) {
        if (source == this.rootNode && child != null && child.getName() != null && child.getName().equals("seatConfigurations")) {
            this.seatConfiguration = child;
        }
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void valueChanged(Node<?> node) {
    }

    private void deleteDeliveryInstructions(List<Node<DeliveryInstructionComplete>> dis) {
        for (Node<DeliveryInstructionComplete> di : dis) {
            Node gdr = di.getChildNamed(new String[]{"galleyDistributionRules"});
            Iterator gdrIT = gdr.getFailSafeChildIterator();
            while (gdrIT.hasNext()) {
                Node gd = (Node)gdrIT.next();
                Node edr = gd.getChildNamed(new String[]{"equipmentDistributionRules"});
                Iterator edrIT = edr.getFailSafeChildIterator();
                while (edrIT.hasNext()) {
                    Node ed = (Node)edrIT.next();
                    Node idr = ed.getChildNamed(new String[]{"insertDistributionRule"});
                    Iterator idrIT = idr.getFailSafeChildIterator();
                    while (idrIT.hasNext()) {
                        Node id = (Node)idrIT.next();
                        if (id.getChildNamed(new String[]{"deliverySpace"}) == null || this.screen == null) continue;
                        this.screen.deleteElement(null, id.getChildNamed(new String[]{"deliverySpace"}), true);
                    }
                }
            }
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.table.kill();
        this.table = null;
        if (this.rootNode != null) {
            this.rootNode.removeNodeListener((NodeListener)this);
        }
        this.rootNode = null;
        if (this.seatConfiguration != null) {
            this.seatConfiguration.removeNodeListener((NodeListener)this);
        }
        this.seatConfiguration = null;
    }

    public void addCabinClass(CabinClassComplete cc) {
        this.preChoosenCC = cc;
        this.table.getButtonHandler().addButtonPressed(0, 0, null);
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public boolean isSwingOnly() {
        return true;
    }

    private class TableRow
    extends Table2RowPanel
    implements ButtonListener,
    ItemListener {
        private ComboBox classCombo;
        private List<TextField> field;
        private DeleteButton deleteButton;

        public TableRow(Table2RowModel m) {
            super(m);
            this.field = new ArrayList<TextField>();
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            Node nodeValue = m.getNode().getChildNamed(new String[]{"cabinClass"});
            Node allValues = NodeToolkit.getAffixList(CabinClassComplete.class);
            CabinClassConverter viewConverter = (CabinClassConverter)ConverterRegistry.getConverter(CabinClassConverter.class);
            this.classCombo = new ComboBox(nodeValue, allValues, (Converter)viewConverter, false, true);
            this.classCombo.setProgress(1.0f);
            NumberTextField f = new NumberTextField(m.getNode().getChildNamed(new String[]{"number"}), TextFieldType.INT);
            f.setUserObject(m.getNode().getChildNamed(new String[]{"leg"}));
            this.field.add(f);
            this.setLayout(new RowLayout());
            this.deleteButton = new DeleteButton();
            this.deleteButton.addButtonListener(this);
            this.add(this.deleteButton);
            this.add(this.classCombo);
            this.add(f);
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.classCombo.getStringValue();
                }
            }
            return null;
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.classCombo != null) {
                this.classCombo.requestFocusInWindowNow();
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.classCombo.kill();
            this.classCombo = null;
            for (TextField f : this.field) {
                f.kill();
            }
            this.field.clear();
            this.field = null;
            this.deleteButton.kill();
            this.deleteButton = null;
        }

        public void updateRow(Node node) {
            NumberTextField f = new NumberTextField(node.getChildNamed(new String[]{"number"}), TextFieldType.INT);
            f.setUserObject(node.getChildNamed(new String[]{"leg"}));
            this.field.add(f);
            Collections.sort(this.field, ComparatorRegistry.getComparator(TextFieldComparator.class));
            this.add(f);
            this.classCombo.addAffectedNode(node.getChildNamed(new String[]{"cabinClass"}));
            this.validate();
        }

        protected boolean usesThisCabinClass(CabinClassComplete dto) {
            Node nodeValue = this.model.getNode().getChildNamed(new String[]{"cabinClass"});
            return ((CabinClassComplete)nodeValue.getValue()).equals((Object)dto);
        }

        protected void setUsableComboClasses(List<Node> list) {
            this.classCombo.updateSelectableValues(list);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.classCombo);
            for (TextField f : this.field) {
                CheckedListAdder.addToList(a, f);
            }
            CheckedListAdder.addToList(a, this.deleteButton);
            return a;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean enable = isEnabled && !PaxTable5.this.screen.isLocked();
            super.setEnabled(enable);
            this.classCombo.setEnabled(enable);
            this.field.forEach(entry -> entry.setEnabled(enable));
            this.deleteButton.setEnabled(enable);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            final ArrayList<Node> curretDIs = new ArrayList<Node>();
            CabinClassComplete searchedClass = (CabinClassComplete)this.model.getNode().getChildNamed(new String[]{"cabinClass"}).getValue();
            Node dis = PaxTable5.this.rootNode.getChildNamed(new String[]{"deliverables"});
            Iterator it = dis.getChilds();
            block0: while (it.hasNext()) {
                Iterator it2;
                Node deliverable = (Node)it.next();
                Node di = deliverable.getChildNamed(new String[]{"deliveryInstruction"});
                Node q = deliverable.getChildNamed(new String[]{"quantityCalculation"});
                if (q.getValue() instanceof LinearFunctionSetQuantityCalculationComplete) {
                    it2 = q.getChildNamed(new String[]{"functions"}).getChilds();
                    while (it2.hasNext()) {
                        Node f = (Node)it2.next();
                        Iterator it3 = f.getChildNamed(new String[]{"paxKeySets"}).getChilds();
                        while (it3.hasNext()) {
                            Node ps = (Node)it3.next();
                            if (!ps.getChildNamed(new String[]{"paxClass"}).getValue().equals(searchedClass)) continue;
                            curretDIs.add(di);
                            continue block0;
                        }
                    }
                    continue;
                }
                if (!(q.getValue() instanceof StepFunctionQuantityCalculationComplete)) continue;
                it2 = q.getChildNamed(new String[]{"paxKeySets"}).getChilds();
                while (it2.hasNext()) {
                    Node ps = (Node)it2.next();
                    if (!ps.getChildNamed(new String[]{"paxClass"}).getValue().equals(searchedClass)) continue;
                    curretDIs.add(di);
                    continue block0;
                }
            }
            if (curretDIs.size() > 0) {
                InnerPopUp2 aPopUp = InnerPopUp2.getInnerPopUp();
                aPopUp.setAttributes(null, true, true, "");
                InnerPopUpListener2 l = new InnerPopUpListener2(){

                    @Override
                    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                        if (xargs != null) {
                            PaxTable5.this.deleteDeliveryInstructions(curretDIs);
                            long currentId = System.currentTimeMillis();
                            for (Node n : TableRow.this.classCombo.getAffectedNodes()) {
                                n.getParent().getParent().removeChild(n.getParent(), currentId);
                            }
                            TableRow.this.model.getNode().getParent().removeChild(TableRow.this.model.getNode(), currentId);
                        }
                    }
                };
                InnerPopupFactory.showWarningDialog("You try to remove a Cabinclass which is refered by a inserted Service/Product/Article. Do you want to remove all effected Delivery Instructions?", l, (Component)source);
            } else {
                long currentId = System.currentTimeMillis();
                for (Node n : this.classCombo.getAffectedNodes()) {
                    n.getParent().getParent().removeChild(n.getParent(), currentId);
                }
                this.model.getNode().getParent().removeChild(this.model.getNode(), currentId);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
        }

        private class RowLayout
        extends DefaultLayout {
            private RowLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                if (TableRow.this.isKilled()) {
                    return;
                }
                int w = TableRow.this.model.getParentModel().getColumnWidth(0);
                int currentX = TableRow.this.model.getParentModel().getTable().getCellPadding();
                TableRow.this.classCombo.setLocation(currentX, (int)((double)parent.getHeight() - TableRow.this.classCombo.getPreferredSize().getHeight()) / 2);
                TableRow.this.classCombo.setSize(w - 2 * TableRow.this.model.getParentModel().getTable().getCellPadding(), (int)TableRow.this.classCombo.getPreferredSize().getHeight());
                currentX = w;
                int count = 1;
                for (TextField f : TableRow.this.field) {
                    w = TableRow.this.model.getParentModel().getColumnWidth(count);
                    f.setLocation(currentX + TableRow.this.model.getParentModel().getTable().getCellPadding(), (int)((double)parent.getHeight() - f.getPreferredSize().getHeight()) / 2);
                    f.setSize(w - 2 * TableRow.this.model.getParentModel().getTable().getCellPadding(), (int)f.getPreferredSize().getHeight());
                    ++count;
                    currentX += w;
                }
                TableRow.this.setControlsX(currentX);
                w = TableRow.this.model.getParentModel().getColumnWidth(count);
                TableRow.this.deleteButton.setLocation((int)((double)currentX + ((double)w - TableRow.this.deleteButton.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - TableRow.this.deleteButton.getPreferredSize().getHeight()) / 2);
                TableRow.this.deleteButton.setSize(TableRow.this.deleteButton.getPreferredSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRow.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            PaxTable5.this.table.setLocation(0, 0);
            PaxTable5.this.table.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return PaxTable5.this.table.getPreferredSize();
        }
    }
}

