/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.labelprint.details;

import ch.icit.pegasus.client.gui.submodules.tool.labelprint.details.ContentDetailsPanel;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.table2.Table2RowSelectionListener;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CursorController;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.PDFViewer;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.LabelReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.AlaCarteMealLabelComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.ILabelComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.ItemLabelComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.label.SpecialMealLabelComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.LabelWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import com.sun.pdfview.PDFFile;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;

public class LabelPreviewDetailsPanel
extends DefaultDetailsPanel<FlightLight>
implements Table2RowSelectionListener {
    private static final long serialVersionUID = 1L;
    private Node<?> currentNode;
    private PDFViewer pdfContent;
    private Node<FlightLight> flightNode;
    private final ContentDetailsPanel contentPanel;
    private LoadingAnimation animation;

    public LabelPreviewDetailsPanel(Node<FlightLight> fightNode) {
        super(null, null);
        this.setTitleText(Words.PREVIEW);
        this.pdfContent = new PDFViewer();
        this.pdfContent.setInnerBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color")));
        this.pdfContent.setOpaque(false);
        this.contentPanel = new ContentDetailsPanel();
        this.contentPanel.setFlightNode(this.flightNode);
        this.flightNode = fightNode;
        this.currentState = Button.ButtonState.STATE_NOTSELECTED;
        this.setCustomLayouter(new Layout());
        this.addToView(this.pdfContent);
        this.addToView(this.contentPanel);
    }

    private void ensureAnimation(String maxText) {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(maxText);
            this.addToView(this.animation);
            this.animation.start();
            this.animation.fadeIn();
        }
        this.revalidate();
    }

    private void removeAnimation() {
        if (this.animation != null) {
            this.animation.fadeOut(true);
            this.animation.stop();
            this.animation = null;
        }
        this.revalidate();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
        if (newState != this.currentState) {
            this.currentState = newState;
            if (this.currentState == Button.ButtonState.STATE_SELECTED) {
                this.contentPanel.fadeIn();
                this.pdfContent.setVisible(true);
            } else {
                this.contentPanel.fadeOut(false);
                this.pdfContent.setVisible(false);
            }
        }
    }

    @Override
    public void tableRowSelected(Table2 sourceTable, Table2RowPanel panel) {
        if (panel != null) {
            this.setNode(panel.getModel().getNode());
        } else {
            this.setNode(null);
        }
    }

    private void createLabelPreview() {
        if (this.currentNode == null) {
            return;
        }
        this.ensureAnimation("Load Label Preview");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                try {
                    FlightReference fr = new FlightReference();
                    fr.setId(((FlightLight)LabelPreviewDetailsPanel.this.flightNode.getValue()).getId());
                    ILabelComplete label = null;
                    if (LabelPreviewDetailsPanel.this.currentNode.getValue() instanceof ItemLabelComplete) {
                        label = (ILabelComplete)LabelPreviewDetailsPanel.this.currentNode.getValue(ItemLabelComplete.class);
                    } else if (LabelPreviewDetailsPanel.this.currentNode.getValue() instanceof SpecialMealLabelComplete) {
                        label = (ILabelComplete)LabelPreviewDetailsPanel.this.currentNode.getValue(SpecialMealLabelComplete.class);
                    } else if (LabelPreviewDetailsPanel.this.currentNode.getValue() instanceof AlaCarteMealLabelComplete) {
                        label = (ILabelComplete)LabelPreviewDetailsPanel.this.currentNode.getValue(AlaCarteMealLabelComplete.class);
                    }
                    byte[] o = ((LabelReportServiceManager)ServiceManagerRegistry.getService(LabelReportServiceManager.class)).createLabelPreview(new LabelWrapper(label));
                    if (o != null) {
                        ViewNode n = new ViewNode("");
                        ByteBuffer buffer = null;
                        if (o != null) {
                            buffer = ByteBuffer.wrap(o);
                        }
                        n.setValue((Object)buffer, 0L);
                        return n;
                    }
                }
                catch (Exception e) {
                    return null;
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return LabelPreviewDetailsPanel.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void setNode(Node<?> node) {
        this.currentNode = node;
        if (this.currentNode != null) {
            CursorController.showCursor(this, true);
            this.switchState(Button.ButtonState.STATE_SELECTED);
            this.createLabelPreview();
            CursorController.showCursor(this, false);
        } else {
            this.contentPanel.setNode(null);
            this.switchState(Button.ButtonState.STATE_NOTSELECTED);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    public String getInboundCode() {
        return "";
    }

    public String getOutboundCode() {
        return ((FlightComplete)this.flightNode.getValue(FlightComplete.class)).getOutboundCode();
    }

    public String getReturnCode() {
        return ((FlightComplete)this.flightNode.getValue(FlightComplete.class)).getInboundCode();
    }

    public Date getStaInbound() {
        return null;
    }

    public Date getStaReturn() {
        return ((FlightComplete)this.flightNode.getValue(FlightComplete.class)).getSta();
    }

    public Date getStd() {
        return ((FlightComplete)this.flightNode.getValue(FlightComplete.class)).getStd();
    }

    public List<FlightLegComplete> getLegs() {
        return ((FlightComplete)this.flightNode.getValue(FlightComplete.class)).getLegs();
    }

    public Integer getTrackingNr() {
        return 123456789;
    }

    public void setFlightNode(Node<FlightLight> flightIReadableNode) {
        this.flightNode = flightIReadableNode;
        this.contentPanel.setFlightNode(flightIReadableNode);
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.animation != null) {
            this.animation.kill();
        }
        this.animation = null;
        LabelPreviewDetailsPanel labelPreviewDetailsPanel = this;
        synchronized (labelPreviewDetailsPanel) {
            if (this.pdfContent != null) {
                this.pdfContent.kill();
            }
            this.pdfContent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remoteObjectLoaded(Node<?> node) {
        if (node != null && node.getValue() != null && this.pdfContent != null) {
            this.removeAnimation();
            ByteBuffer o = (ByteBuffer)node.getValue();
            try {
                LabelPreviewDetailsPanel labelPreviewDetailsPanel = this;
                synchronized (labelPreviewDetailsPanel) {
                    if (this.pdfContent != null) {
                        this.pdfContent.showPDF(null, new PDFFile(o));
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getViewPort().invalidate();
            this.getViewPort().validate();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int currentH = 0;
            if (LabelPreviewDetailsPanel.this.animation != null) {
                LabelPreviewDetailsPanel.this.animation.setLocation((int)(((double)parent.getWidth() - LabelPreviewDetailsPanel.this.animation.getPreferredSize().getWidth()) / 2.0), (int)(((double)parent.getHeight() - LabelPreviewDetailsPanel.this.animation.getPreferredSize().getHeight()) / 2.0));
                LabelPreviewDetailsPanel.this.animation.setSize(LabelPreviewDetailsPanel.this.animation.getPreferredSize());
            }
            if (LabelPreviewDetailsPanel.this.pdfContent != null) {
                LabelPreviewDetailsPanel.this.pdfContent.setLocation(10, 10);
                LabelPreviewDetailsPanel.this.pdfContent.setSize(parent.getWidth() - 20, parent.getHeight() - 20);
            }
            if (LabelPreviewDetailsPanel.this.contentPanel != null) {
                LabelPreviewDetailsPanel.this.contentPanel.setLocation(0, currentH);
                LabelPreviewDetailsPanel.this.contentPanel.setSize(parent.getWidth(), parent.getHeight() - LabelPreviewDetailsPanel.this.contentPanel.getY());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 0);
        }
    }
}

