/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.product.spec;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbGroupTable;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbNavigator;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbPanel;
import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbTable;
import ch.icit.pegasus.client.gui.modules.product.ProductModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.product.details.utils.MaterialCostConverter;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.ProductSpecificationSubModule;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils.AddGroupPopupInsert;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils.GroupLoader;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils.ProductBreadCrumbComponentTable;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils.ProductBreadCrumbGroupTable;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils.ProductBreadCrumbNavigator;
import ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils.SimpleEditPanel;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.priceanimation.CalculationRunnable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.EmbeddedDTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.util.PriceToolkit;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.client.util.variantaccessor.CurrencyVariantAccessorImpl;
import ch.icit.pegasus.client.util.variantaccessor.RecipeVariantAccessorImpl;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.product.ComplexProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantComplete_;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete_;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductVariantComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductAccess;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.ProductPriceCalculationToolkit;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CurrencyVariantAccessor;
import ch.icit.pegasus.server.core.dtos.utils.accessor.RecipeVariantAccessor;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Container;
import java.io.File;
import java.sql.Date;
import java.sql.Timestamp;

public class ProductBreadCrumbPanel
extends BreadCrumbPanel {
    private static final long serialVersionUID = 1L;
    private SystemSettingsComplete settings;
    private ProductSpecificationSubModule screen;
    private SimpleEditPanel edit;
    private ProductComplete currentProduct;
    private RecipeVariantAccessor variantAccessor = new RecipeVariantAccessorImpl();
    private CurrencyVariantAccessor currencyAccessor = new CurrencyVariantAccessorImpl();
    private Node<ComplexProductVariantComplete> selectedVariant;

    public ProductBreadCrumbPanel(IDataHandler dataHandler, ProductSpecificationSubModule screen, RDProvider p) {
        super(dataHandler, Integer.MAX_VALUE, p);
        this.screen = screen;
    }

    public boolean canEditSpecification() {
        ModificationStateE stateE = (ModificationStateE)this.getSelectedVariant().getChildNamed(ProductVariantComplete_.state).getValue();
        if (stateE == ModificationStateE.ACCEPTED) {
            return false;
        }
        return this.getProvider().isWritable(ProductAccess.SPECIFICATION);
    }

    public Node<Date> getDueDate() {
        return this.screen.getDueDate();
    }

    public CurrencyVariantAccessor getCurrencyAccessor() {
        return this.currencyAccessor;
    }

    public RecipeVariantAccessor getVariantAccessor() {
        return this.variantAccessor;
    }

    public Node<ComplexProductVariantComplete> getSelectedVariant() {
        return this.selectedVariant;
    }

    public Timestamp getTimestamp() {
        return new Timestamp(((Date)this.getDueDate().getValue()).getTime());
    }

    public ProductSpecificationSubModule getScreen() {
        return this.screen;
    }

    @Override
    public BreadCrumbTable getGroupTable(Node node) {
        ProductBreadCrumbGroupTable table = new ProductBreadCrumbGroupTable(this.dataHandler, (BreadCrumbPanel)this, "Add Group", node, this.provider);
        ((BreadCrumbTable)table).setNode(node);
        return table;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.edit != null) {
            this.edit.setEnabled(isEnabled);
        }
    }

    @Override
    public void layoutRest(Container parent) {
        super.layoutRest(parent);
        if (this.edit != null) {
            this.edit.setLocation(50, 50);
            this.edit.setSize(parent.getWidth() - 100, (int)this.edit.getPreferredSize().getHeight());
        }
    }

    @Override
    public BreadCrumbTable getComponentTable(Node node, int depth) {
        ProductBreadCrumbComponentTable table = new ProductBreadCrumbComponentTable(this.dataHandler, (BreadCrumbPanel)this, this.loader, "Add Component", node, this.provider);
        ((BreadCrumbTable)table).setNode(node);
        return table;
    }

    @Override
    public void tableRowSelected(Table2 sourceTable, Table2RowPanel panel) {
        super.tableRowSelected(sourceTable, panel);
    }

    @Override
    public Converter getTotalConverter() {
        return ConverterRegistry.getConverter(MaterialCostConverter.class);
    }

    @Override
    public void setNode(Node node) {
        if (this.node != null) {
            this.clearTable();
        }
        if (this.edit != null) {
            this.edit.kill();
            this.edit = null;
        }
        this.node = node;
        if (node instanceof ProxyNode) {
            this.node = ((ProxyNode)node).getRefNode();
        }
        if (this.node.getParent() != null && this.node.getParent().getParent() != null) {
            this.currentProduct = (ProductComplete)this.node.getParent().getParent().getValue();
        } else if (this.node.getParent() != null && this.node.getParent().getValue() instanceof ProductComplete) {
            this.currentProduct = (ProductComplete)this.node.getParent().getValue();
        } else {
            InnerPopupFactory.showMessageDialog("Error occurred, please restart Product Specification Module", this);
            return;
        }
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        if (node.getValue(ProductVariantComplete.class) instanceof ComplexProductVariantComplete) {
            this.selectedVariant = node;
            BreadCrumbTable t = null;
            t = this.addGroupTable(node.getChildNamed(new String[]{"productComponentGroups"}));
            t.selectFirstEntry();
            this.totalCost.setNode(this.node.getChildNamed(new String[]{"materialPrice"}));
            this.totalCost.load(true);
        }
        this.screen.createFocusCycle();
    }

    @Override
    public void setTotalCostAlgorithm() {
        CalculationRunnable run = new CalculationRunnable(){

            @Override
            public void run() {
                if (ProductBreadCrumbPanel.this.screen.getCurrentState() != ProductSpecificationSubModule.LoadingState.NONE) {
                    return;
                }
                Node n = ProductBreadCrumbPanel.this.getCommitingNode();
                if (n.getValue(SimpleProductVariantComplete.class) != null) {
                    ProductBreadCrumbPanel.this.commitNode(SimpleProductVariantComplete.class);
                } else if (n.getValue(ComplexProductVariantComplete.class) != null) {
                    ProductBreadCrumbPanel.this.commitNode(ComplexProductVariantComplete.class);
                }
                if (n.getValue(ProductVariantComplete.class) == null) {
                    return;
                }
                ModificationStateE state = ((ProductVariantComplete)n.getValue(ProductVariantComplete.class)).getState();
                try {
                    PriceComplete p = ProductPriceCalculationToolkit.getProductMaterialPrice((ProductVariantComplete)((ProductVariantComplete)n.getValue(ProductVariantComplete.class)), (int)1, (ModificationStateE)state, (SystemSettingsComplete)ProductBreadCrumbPanel.this.settings, (Timestamp)new Timestamp(((Date)ProductBreadCrumbPanel.this.getDueDate().getValue()).getTime()), (RecipeVariantAccessor)ProductBreadCrumbPanel.this.variantAccessor, (CurrencyVariantAccessor)ProductBreadCrumbPanel.this.currencyAccessor);
                    if (p != null) {
                        p.setPrice(PriceToolkit.ensureDoubleFinite((Double)p.getPrice()));
                        Node pn = ProductBreadCrumbPanel.this.totalCost.getNode();
                        if (pn == null) {
                            pn = new EmbeddedDTONode();
                            ProductBreadCrumbPanel.this.totalCost.setNode(pn);
                        }
                        pn.setValue((Object)p, 0L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }

            @Override
            public boolean isAlive() {
                return !ProductBreadCrumbPanel.this.totalCost.isKilled();
            }
        };
        this.totalCost.setRunnable(run);
    }

    @Override
    public InnerPopUp2 getAddGroupPopup(Button source, int x, int y, BreadCrumbTable t) {
        InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
        popUp.setAttributes(source, true, true, Words.ADD_NEW_GROUP);
        popUp.setView(new AddGroupPopupInsert((ProductModuleDataHandler)this.dataHandler, this));
        popUp.showPopUp(x, y, 200, 300, this, source, PopupType.NORMAL);
        this.tempGroup = t;
        popUp.setOkButtonText(Words.ADD_NEW);
        return popUp;
    }

    @Override
    public void processPopUpClose(Object ... xargs) {
        if (xargs.length == 3) {
            if (xargs[0] != null && xargs[1] != null) {
                Node n;
                this.newSelectedGroup = n = (Node)xargs[1];
                Node pN = (Node)xargs[0];
                Node pO = this.node;
                BreadCrumbTable t = this.tempGroup;
                if (t instanceof BreadCrumbGroupTable && t.getTable() != null) {
                    int i = t.getTable().getRowCount() + 1;
                    SimpleProductComponentGroupComplete oGroup = (SimpleProductComponentGroupComplete)this.newSelectedGroup.getValue();
                    SimpleProductComponentGroupComplete nGroup = CopyTemplateToolkit.copyProductGroup(oGroup, false);
                    nGroup.setNumber(Integer.valueOf(i));
                    if (oGroup.getUseImage().booleanValue() && oGroup.getImage() != null) {
                        File f = null;
                        if (oGroup.getImage().getId() == null) {
                            f = oGroup.getImage().getLocalFile();
                        } else {
                            try {
                                f = FileTransferUtil.download((PegasusFileComplete)oGroup.getImage(), (FileTransferListener[])new FileTransferListener[0]);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (f != null) {
                            nGroup.setImage(new PegasusFileComplete());
                            nGroup.getImage().setClientOId(Long.valueOf(ADTO.getNextId()));
                            nGroup.getImage().setLocalFile(f);
                        }
                    }
                    Node nn = INodeCreator.getDefaultImpl().getNode4DTO((Object)nGroup, true, false);
                    t.getTable().setRequestFocusOnAdd(true);
                    t.getTable().getModel().getNode().addChild(nn, System.currentTimeMillis());
                    t.getTable().setRequestFocusOnAdd(false);
                }
            } else {
                BreadCrumbTable t = this.tempGroup;
                if (t instanceof BreadCrumbGroupTable && t.getTable() != null && t.getTable().getButtonHandler() != null) {
                    t.getTable().getButtonHandler().addButtonPressed(0, 0, null);
                }
            }
        }
    }

    @Override
    public DtoField<?> getSelectionChildName() {
        return SimpleProductComponentGroupComplete_.components;
    }

    @Override
    public GroupLoader getGroupLoader() {
        return new GroupLoader(this);
    }

    @Override
    public BreadCrumbNavigator getNavigatorComponent() {
        return new ProductBreadCrumbNavigator(this.tableStack, this);
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    public void showSimple(Node node) {
        if (this.edit == null) {
            this.edit = new SimpleEditPanel();
            if (this.getViewPort() != null) {
                this.getViewPort().removeAll();
                this.getViewPort().add(this.edit);
            }
            this.revalidate();
            this.repaint(32L);
        }
        this.edit.setNode(node);
    }

    public void hideSimple() {
        if (this.edit != null) {
            this.edit.fadeOut(true);
            this.edit = null;
        }
    }
}

