/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.FlightTypeSkin;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightTypeE;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class CellViewFlightTypeRenderer
extends CellRenderer {
    private static final long serialVersionUID = 1L;
    private FlightTypeSkin skin;
    private FlightLight currentFlight;

    public CellViewFlightTypeRenderer(FlightLight flight) {
        this.currentFlight = flight;
        this.setOpaque(false);
        this.setToolTipText(CellViewFlightTypeRenderer.getStringValue(flight));
        this.skin = SkinRegistry.getSkin(FlightTypeSkin.class);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.skin.getImage(Button.ButtonState.UP).getWidth(), this.skin.getImage(Button.ButtonState.UP).getHeight());
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = (this.getWidth() - this.skin.getImage(Button.ButtonState.UP, this.currentFlight).getWidth()) / 2;
        int y = (this.getHeight() - this.skin.getImage(Button.ButtonState.UP, this.currentFlight).getHeight()) / 2;
        this.skin.paint(g2, x, y, Button.ButtonState.UP, this.currentFlight);
        this.paintChildren(g2);
    }

    public static String getStringValue(FlightLight flight) {
        if (flight.getAdHoc().booleanValue()) {
            return Words.ADHOC_FLIGHT;
        }
        if (flight.getFlightType() == FlightTypeE.RETURN) {
            return Words.RETURN_FLIGHT;
        }
        return Words.TRANSIT_FLIGHT;
    }

    @Override
    public String getStringValue() {
        return CellViewFlightTypeRenderer.getStringValue(this.currentFlight);
    }
}

