/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.StateSkin;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultTwoStateSkin1Field;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class CellViewRecipeStateERenderer
extends CellRenderer
implements AttributeListener {
    private static final long serialVersionUID = 1L;
    private DefaultTwoStateSkin1Field skin;
    private int xInsert;
    private RecipeVariantLight recipe;
    private int calculationWarningInset = 8;
    private ModificationStateE currentState;

    public CellViewRecipeStateERenderer(RecipeVariantLight recipe) {
        this.currentState = recipe != null ? recipe.getState() : ModificationStateE.DRAFT;
        this.recipe = recipe;
        this.skin = (DefaultTwoStateSkin1Field)DefaultSkins.TwoStateIcon.createDynamicSkin();
        this.attributeChanged("All attributes changed");
        this.updateTooltip(recipe != null ? recipe.getState() : null);
    }

    public RecipeVariantLight getFlight() {
        return this.recipe;
    }

    private void updateTooltip(ModificationStateE state) {
        if (state != null) {
            String tt = "Flight State is: ";
            switch (state) {
                case ACCEPTED: {
                    tt = tt + Words.ACCEPTED;
                }
                case DRAFT: {
                    tt = tt + Words.DRAFT;
                }
            }
            tt = "-";
            this.setToolTipText(tt);
        }
    }

    public void setCalculationWarningInset(int calculationWarningInset) {
        this.calculationWarningInset = calculationWarningInset;
    }

    @Override
    public Dimension getPreferredSize() {
        int a = this.skin.getImage(Button.ButtonState.UP, StateSkin.StateType.Green).getWidth();
        int b = this.skin.getImage(Button.ButtonState.UP, StateSkin.StateType.Green).getHeight();
        int w = a * 4 + 3;
        return new Dimension(w += this.calculationWarningInset, b);
    }

    public ModificationStateE getFlightStateE() {
        return this.currentState;
    }

    @Override
    public String getStringValue() {
        return CellViewRecipeStateERenderer.getValueString(this.currentState);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int currentX = 0;
        int currentY = 0;
        currentX = this.isFirstColumn ? this.firstColumnInset : this.xInsert;
        StateSkin.StateType aState = this.currentState == ModificationStateE.ACCEPTED ? StateSkin.StateType.Green : StateSkin.StateType.Orange;
        currentY = (this.getHeight() - this.skin.getImage(Button.ButtonState.UP, aState).getHeight()) / 2;
        String t = "";
        if (this.recipe != null && Boolean.TRUE.equals(this.recipe.getHasYieldValidationWarning())) {
            t = t + "!";
        }
        if (!t.isEmpty()) {
            g2.setColor(Color.red);
            g2.setFont(AttributesConverter.getDefaultBoldFont());
            g2.drawString(t, currentX, (this.getHeight() + g2.getFont().getSize()) / 2 - 1);
        }
        this.skin.paint(g2, currentX += this.calculationWarningInset, currentY, Button.ButtonState.UP, aState);
        this.paintChildren(g2);
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.xInsert = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding"));
            this.firstColumnInset = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_first_column_inset"));
            this.repaint(32L);
        }
    }

    public static String getValueString(ModificationStateE value) {
        return value.toString();
    }
}

