/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons;

import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.prototypes.SizedSkinButton_NEW;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.StringPopUpInsert;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.server.core.i18n.Words;

public class InfoButton
extends SizedSkinButton_NEW
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    protected String titleName;
    protected static int minWidth = 250;
    protected static int minHeight = 150;
    private String currentPopupText;

    public InfoButton(String title) {
        this(SizedSkin1Field.SkinSize.SMALL);
        this.setToolTipText(Words.SHOW_INFO);
        this.titleName = title;
    }

    public InfoButton(SizedSkin1Field.SkinSize size) {
        super(DefaultSkins.InfoIcon, size, false);
        this.addButtonListener(this);
    }

    public InfoButton() {
        this(SizedSkin1Field.SkinSize.SMALL);
    }

    public void setInvalid() {
        this.setState(Button.ButtonState.ERROR);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (this.currentPopupText != null) {
            this.showMessage(source, this.currentPopupText, x, y);
        }
    }

    public void showMessage(Button source, String t, int x, int y) {
        InnerPopUp2 pop = InnerPopUp2.getInnerPopUp();
        if (this.titleName == null) {
            this.titleName = "Info";
        }
        pop.setAttributes(null, false, false, this.titleName);
        pop.setView(new StringPopUpInsert(t));
        int w = (int)pop.getView().getPreferredSize().getWidth() + 10;
        int h = (int)pop.getView().getPreferredSize().getHeight() + 5;
        if (w < minWidth) {
            w = minWidth;
        }
        if (h < minHeight) {
            h = minHeight;
        }
        pop.showPopUp(x, y, w, h, null, this, PopupType.NORMAL);
    }

    public void installStringViewer(String text) {
        this.currentPopupText = text;
    }

    public String getInstallString() {
        return this.currentPopupText;
    }

    public static int getPreferredWidth(SizedSkin1Field.SkinSize size) {
        SizedSkin1Field s = (SizedSkin1Field)DefaultSkins.InfoIcon.createDynamicSkin();
        return s.getImage(Button.ButtonState.UP, size).getWidth();
    }
}

