/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.combobox;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.comparators.ConfiguratableComparator;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CurrencyConverter;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.formatter.FormatterRegistry;
import ch.icit.pegasus.client.gui.modules.article.details.utils.CostPerUnitConverter;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.DynamicDecimalFormatSelector;
import ch.icit.pegasus.client.gui.utils.EnterListener;
import ch.icit.pegasus.client.gui.utils.Enterable;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.SelectionManager;
import ch.icit.pegasus.client.gui.utils.TextFieldListener;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.animators.Movable;
import ch.icit.pegasus.client.gui.utils.animators.Mover;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.combobox.DefaultListViewPopupInsert;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.MouseConsumer;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.skins.ISkin;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.Skin5Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.InputComboBoxSkin;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.textfield.AbstractTextField;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.gui.utils.tooltip.ToolTipCreator;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete_;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete_;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.services.exception.ClientRemoteException;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class InputComboBox2
extends JPanelFadable
implements Movable,
Focusable,
Validatable,
MouseListener,
LafListener,
FocusListener,
InnerPopUpListener2,
TextFieldListener,
ActionListener,
Enterable,
Nodable,
MouseConsumer {
    private static final long serialVersionUID = 1L;
    public static final int STATE_FOCUS_LEFT = 57;
    public static final int STATE_FOCUS_RIGHT = 13;
    private InnerPopUp2 comboPopUp;
    private Button.ButtonState currentState = Button.ButtonState.UP;
    private Button.ButtonState newState = null;
    private Skin5Field skin;
    private final List<EnterListener> enterListener = new ArrayList<EnterListener>();
    private int defaultUnitWidth = 75;
    private Node amountNode;
    private Node unitNode;
    private Node secondUnitNode;
    private UnitComplete selectedUnit;
    private Node possibleUnits;
    private static Color activTextColor;
    private static Color disabledTextColor;
    private DecimalFormat format;
    private TextField textField;
    private TextLabel textReadOnly;
    private TextLabel unitReadOnly;
    public static final int STATE_EDIT_PRICE_AND_UNIT_LONG = 3;
    public static final int STATE_EDIT_PRICE_AND_UNIT_DOUBLE = 11;
    public static final int STATE_EDIT_PRICE_DOUBLE = 5;
    public static final int STATE_EDIT_PRICE_LONG = 7;
    private ToolTipCreator toolTipCreator;
    private boolean useLongAsInteger;
    private InputComboBox.InputComboBoxType inputState;
    private AWTEventListener keyListener;
    private VisibleContainer visibleContainer;
    private boolean isDown;
    private static int minUnitWidth_editable;
    private static int minUnitWidth;
    private static int minAmountWidth;
    private String lastKeyEvents;
    private long lastKeyEventTime;
    private Comparator defaultSorter;
    private Object defaultSorterUserObject;
    private Node node;
    private static long keyEventTimeWindow;
    private int overrideKommaStellen = -1;

    private static void ensureMinUnitWidth(Component c) {
        ISkin skin;
        Font f;
        String t;
        if (minUnitWidth_editable == -1) {
            t = AttributeLoader.getAttributeLoader().getAttribute("inputcombo_min_unittext");
            f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
            skin = SkinRegistry.getSkin(InputComboBoxSkin.class);
            int alphanumerics = c.getFontMetrics(f).stringWidth(t);
            int image = ((Skin5Field)skin).getImage51(Button.ButtonState.UP, 11).getWidth();
            minUnitWidth = alphanumerics + 2;
            minUnitWidth_editable = alphanumerics + image + 1;
        }
        if (minAmountWidth == -1) {
            t = AttributeLoader.getAttributeLoader().getAttribute("inputcombo_min_amounttext");
            f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
            skin = (Skin3Field)DefaultSkins.SearchFieldTexture.createDynamicSkin();
            int image = ((Skin3Field)skin).getImageLeft(Button.ButtonState.UP).getWidth() + ((Skin3Field)skin).getImageRight(Button.ButtonState.UP).getWidth();
            int alphanuerics = c.getFontMetrics(f).stringWidth(t);
            minAmountWidth = alphanuerics + image + 4;
        }
    }

    public InputComboBox2(Node amount, Node unit, InputComboBox.InputComboBoxType inputState) {
        this(amount, unit, null, inputState);
    }

    public InputComboBox2(Node amount, Node unit, DecimalFormat formatter, InputComboBox.InputComboBoxType inputState) {
        this.initInputComboBox(amount, unit, formatter, inputState);
    }

    public void setMaxKommaStellen(int overrideKommaStellen) {
        this.overrideKommaStellen = overrideKommaStellen;
        this.ensureKommaStellen(null);
    }

    private void initInputComboBox(Node amount, Node unit, DecimalFormat formatter, InputComboBox.InputComboBoxType inputState) {
        InputComboBox2.ensureMinUnitWidth(this);
        this.format = formatter;
        if (formatter == null) {
            this.format = FormatterRegistry.getDecimalFormat(Words.DEFAULT_PRICE_PATTERN);
        }
        this.skin = SkinRegistry.getSkin(InputComboBoxSkin.class);
        this.unitReadOnly = new TextLabel();
        this.unitReadOnly.setProgress(1.0f);
        this.setCurrentState(inputState);
        this.setFocusable(true);
        if (this.inputState == InputComboBox.InputComboBoxType.PRICE_LONG || this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG) {
            this.textField = new NumberTextField(TextFieldType.LONG);
        } else if (this.inputState == InputComboBox.InputComboBoxType.PRICE_DOUBLE || this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE) {
            this.textField = new NumberTextField(TextFieldType.DOUBLE);
            this.textField.setDecimalFormat(this.format);
        }
        this.textField.addActionListener(this);
        this.textField.setProgress(1.0f);
        if (this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE || this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG) {
            this.textField.setPaintTexture(false);
            this.textField.disableInnerMouseEvents(true);
            this.textField.addMouseListener(this);
            this.textField.getTextField().addMouseListener(this);
            this.textField.getTextField().addFocusListener(this);
        }
        if (amount != null && unit != null) {
            this.setNode(amount, unit);
        }
        this.lafAttributeChanged("All attribues changed");
        this.textField.setForeground(activTextColor);
        this.addMouseListener(this);
        this.unitReadOnly.addMouseListener(this);
        this.addFocusListener(this);
        this.setLayout(new Layout());
        this.setOpaque(false);
        this.add(this.textField);
        this.add(this.unitReadOnly);
    }

    private void ensureKommaStellen(UnitComplete unit) {
        if (this.overrideKommaStellen != -1) {
            int maxKS = this.overrideKommaStellen;
            if (this.textField instanceof NumberTextField) {
                try {
                    if (maxKS == 0) {
                        this.textField.setType(TextFieldType.LONG);
                        ((NumberTextField)this.textField).setMaxKommaStellen(0);
                        ((NumberTextField)this.textField).setUseMaxDecimals(false);
                    } else {
                        this.textField.setType(TextFieldType.DOUBLE);
                        ((NumberTextField)this.textField).setUseMaxDecimals(true);
                        ((NumberTextField)this.textField).setMaxKommaStellen(maxKS);
                    }
                }
                catch (ClientRemoteException e) {
                    e.printStackTrace();
                }
                this.textField.setDecimalFormat(DynamicDecimalFormatSelector.format(maxKS));
            }
        } else if (unit != null) {
            UnitComplete u = unit;
            int maxKS = 0;
            while (u.getSubUnit() != null) {
                maxKS += (int)Math.log10(u.getSubUnit().getConversionFactor().intValue());
                u = u.getSubUnit();
            }
            if (this.textField instanceof NumberTextField) {
                try {
                    if (maxKS == 0) {
                        this.textField.setType(TextFieldType.LONG);
                        ((NumberTextField)this.textField).setMaxKommaStellen(0);
                        ((NumberTextField)this.textField).setUseMaxDecimals(false);
                    } else {
                        this.textField.setType(TextFieldType.DOUBLE);
                        ((NumberTextField)this.textField).setUseMaxDecimals(true);
                        ((NumberTextField)this.textField).setMaxKommaStellen(maxKS);
                    }
                }
                catch (ClientRemoteException e) {
                    e.printStackTrace();
                }
                this.textField.setDecimalFormat(DynamicDecimalFormatSelector.format(maxKS));
            }
        }
    }

    public void setUseLongAsInteger() {
        this.useLongAsInteger = true;
    }

    public void addTextListener(TextFieldListener listener) {
        this.textField.addTextFieldListener(listener);
    }

    public void setToolTipCreator(ToolTipCreator creator) {
        this.toolTipCreator = creator;
        this.toolTipCreator.setToolTippedComponent(this.unitReadOnly);
    }

    public void setPossibleUnits(Node possValues) {
        this.possibleUnits = possValues;
    }

    public Node getPossibleUnits() {
        return this.possibleUnits;
    }

    public void setDefaultSorterUserObject(Object o) {
        this.defaultSorterUserObject = o;
    }

    public void setNode(Node value, Node unit) {
        if (unit != null && unit.getValue() != null) {
            if (unit.getValue() instanceof UnitComplete) {
                if (this.unitReadOnly != null) {
                    this.unitReadOnly.setViewConverter(ConverterRegistry.getConverter(UnitConverter.class));
                }
            } else if (!(unit.getValue() instanceof CurrencyComplete) && this.unitReadOnly != null) {
                this.unitReadOnly.setViewConverter(ConverterRegistry.getConverter(UnitConverter.class));
            }
        }
        this.amountNode = value;
        this.unitNode = unit;
        Node nAmount = new Node();
        DTOProxyNode nUnit = new DTOProxyNode();
        if (this.amountNode != null && this.amountNode.getValue() != null && this.unitNode != null && this.unitNode.getValue() != null) {
            this.createInputValue(nAmount, (Node)nUnit);
        }
        if (this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE || this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG) {
            this.ensureKommaStellen((UnitComplete)nUnit.getValue());
        }
        this.textField.valueChanged(nAmount);
        if (nUnit != null && nUnit.getValue() != null && this.unitReadOnly != null && this.unitReadOnly.getViewConverter() != null) {
            this.unitReadOnly.setText((String)this.unitReadOnly.getViewConverter().convert(nUnit.getValue(), (Node)nUnit, new Object[0]));
        }
        if (this.secondUnitNode != null && unit != null && value != null) {
            this.setSecondUnitNode((Node<UnitComplete>)this.secondUnitNode);
        }
        if (nUnit != null && nUnit.getValue() instanceof UnitComplete) {
            this.selectedUnit = (UnitComplete)nUnit.getValue();
        }
        this.textField.setNode(nAmount);
        this.textField.removeTextFieldListener(this);
        this.textField.addTextFieldListener(this);
    }

    private void createInputValue(Node nAmount, Node nUnit) {
        double v = 0.0;
        if (this.amountNode.getValue() instanceof Integer) {
            v = ((Integer)this.amountNode.getValue()).intValue();
        } else if (this.amountNode.getValue() instanceof Double) {
            v = (Double)this.amountNode.getValue();
        } else if (this.amountNode.getValue() instanceof Long) {
            v = ((Long)this.amountNode.getValue()).longValue();
        }
        if (this.unitNode.getValue() instanceof UnitComplete) {
            QuantityComplete q = new QuantityComplete(Double.valueOf(v), (UnitComplete)this.unitNode.getValue());
            q = UnitConversionToolkit.normalizeQuantity((QuantityComplete)q);
            nAmount.setValue((Object)q.getQuantity(), 0L);
            nUnit.setValue((Object)q.getUnit(), 0L);
        } else if (this.unitNode.getValue() instanceof CurrencyComplete) {
            PriceComplete p = new PriceComplete((CurrencyComplete)this.unitNode.getValue(), Double.valueOf(v));
            nAmount.setValue((Object)p.getPrice(), 0L);
            nUnit.setValue((Object)p.getCurrency(), 0L);
        }
    }

    public UnitComplete getSelectUnit() {
        return this.selectedUnit;
    }

    public void setSelectedUnit(UnitComplete unit) {
        this.selectedUnit = unit;
        if (this.unitNode != null) {
            this.unitNode.setValue((Object)unit, 1L);
            this.setNode(this.amountNode, this.unitNode);
        }
    }

    public void setQuantity(QuantityComplete qty) {
        this.selectedUnit = qty.getUnit();
        if (this.unitNode != null) {
            this.unitNode.setValue((Object)qty.getUnit(), 1L);
            this.setNode(this.amountNode, this.unitNode);
        }
    }

    public void clearSelectedUnit() {
        this.selectedUnit = null;
        if (this.unitNode != null) {
            this.unitNode.setValue((Object)new UnitComplete("", ""), 0L);
            this.setNode(this.amountNode, this.unitNode);
        }
    }

    public int getTextFieldWidth() {
        return minAmountWidth;
    }

    public void setNode(Node node) {
        this.node = node;
        if (node != null && node.getValue() instanceof PriceComplete) {
            Node p = node.getChildNamed(PriceComplete_.price);
            Node u = node.getChildNamed(PriceComplete_.currency);
            this.setNode(p, u);
        } else if (node != null && node.getValue() instanceof QuantityComplete) {
            Node p = node.getChildNamed(QuantityComplete_.quantity);
            Node u = node.getChildNamed(QuantityComplete_.unit);
            this.setNode(p, u);
        } else if (node != null && node.getValue() instanceof StoreQuantityComplete) {
            Node p = node.getChildNamed(StoreQuantityComplete_.amount);
            Node u = node.getChildNamed(StoreQuantityComplete_.unit);
            this.setNode(p, u);
        }
        if (node == null) {
            this.setNode(null, null);
        }
    }

    @Override
    public Node<?> getNode() {
        return this.node;
    }

    public void setCurrentState(InputComboBox.InputComboBoxType newState) {
        this.inputState = newState;
        if (this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE || this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG) {
            this.defaultUnitWidth = minUnitWidth_editable;
            if (this.textField != null) {
                this.textField.setPaintTexture(false);
                this.textField.disableInnerMouseEvents(true);
            }
        } else if (this.inputState == InputComboBox.InputComboBoxType.PRICE_DOUBLE || this.inputState == InputComboBox.InputComboBoxType.PRICE_LONG) {
            this.defaultUnitWidth = 35;
            if (this.textField != null) {
                this.textField.setPaintTexture(true);
                this.textField.disableInnerMouseEvents(false);
            }
        }
    }

    public void setState(Button.ButtonState state) {
        this.currentState = state;
        this.repaint(32L);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE || this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG) {
            this.skin.paint(g2, this.getWidth(), this.getWidth() - this.defaultUnitWidth, this.currentState, this.inputState.getNumber());
        }
        this.paintChildren(g2);
    }

    public void setSecondUnitNode(Node<UnitComplete> secondUnit) {
        if (this.secondUnitNode != null && this.unitReadOnly != null) {
            this.unitReadOnly.addNodeToTextLabel(secondUnit);
        }
        this.secondUnitNode = secondUnit;
        if (this.unitReadOnly != null) {
            if (this.secondUnitNode != null) {
                this.unitReadOnly.setViewConverter(ConverterRegistry.getConverter(CostPerUnitConverter.class));
                ((CostPerUnitConverter)this.unitReadOnly.getViewConverter()).setSecondNode((Node<UnitComplete>)this.secondUnitNode);
            } else {
                this.unitReadOnly.setViewConverter(ConverterRegistry.getConverter(CurrencyConverter.class));
            }
            this.unitReadOnly.updateString();
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.textField != null && this.textField.getTextField() != null) {
            this.textField.getTextField().removeActionListener(this);
        }
    }

    public Mover<InputComboBox2> getMover() {
        return null;
    }

    public Node getValueNode() {
        return this.amountNode;
    }

    public Node getUnitNode() {
        return this.unitNode;
    }

    @Override
    public void setLocationSmooth(int endX, int endY) {
        this.setLocation(endX, endY);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.textField);
        if (this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE || this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG) {
            a.add(this);
        }
        return a;
    }

    public TextField getEnterField() {
        return this.textField;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (isEnabled) {
            this.setState(Button.ButtonState.UP);
        } else {
            this.setState(Button.ButtonState.DISABLED);
        }
        if (this.unitReadOnly != null) {
            this.unitReadOnly.setEnabled(isEnabled);
        }
        this.textField.setEnabled(isEnabled);
    }

    @Override
    public void setInvalid() {
        this.setState(Button.ButtonState.ERROR);
        if (this.inputState != InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE && this.inputState != InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG) {
            this.textField.setInvalid();
        }
    }

    @Override
    public void setValid() {
        if (this.currentState == Button.ButtonState.ERROR) {
            if (this.textField.hasFocus()) {
                this.setState(Button.ButtonState.STATE_FOCUS_LEFT);
            } else if (this.hasFocus()) {
                this.setState(Button.ButtonState.STATE_FOCUS_RIGHT);
            } else {
                this.setState(Button.ButtonState.UP);
            }
        }
    }

    @Override
    public void setWarning() {
    }

    private boolean ensurePopup() {
        if (this.comboPopUp == null && this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE || this.comboPopUp == null && this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG) {
            this.showPopup();
            return true;
        }
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return this.comboPopUp != null && this.comboPopUp.isInnerComponent(c);
    }

    private void registerKeyEvents() {
        if (this.keyListener == null) {
            this.keyListener = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    KeyEvent ke;
                    if (event instanceof KeyEvent && (ke = (KeyEvent)event).getID() == 401 && !ke.isConsumed()) {
                        if (ke.getKeyCode() == 40) {
                            ke.consume();
                            if (!InputComboBox2.this.ensurePopup() && InputComboBox2.this.comboPopUp != null && InputComboBox2.this.comboPopUp.getView() != null) {
                                ((DefaultListViewPopupInsert)InputComboBox2.this.comboPopUp.getView()).selectLowerItem();
                            }
                        } else if (ke.getKeyCode() == 38) {
                            ke.consume();
                            if (!InputComboBox2.this.ensurePopup() && InputComboBox2.this.comboPopUp != null && InputComboBox2.this.comboPopUp.getView() != null) {
                                ((DefaultListViewPopupInsert)InputComboBox2.this.comboPopUp.getView()).selectUpperItem();
                            }
                        } else if (ke.getKeyCode() == 10) {
                            ke.consume();
                            if (InputComboBox2.this.comboPopUp != null && InputComboBox2.this.comboPopUp.getView() instanceof DefaultListViewPopupInsert) {
                                ((DefaultListViewPopupInsert)InputComboBox2.this.comboPopUp.getView()).closeIt(false);
                            } else {
                                InputComboBox2.this.enterPressed();
                            }
                        } else {
                            String t = "" + ke.getKeyChar();
                            long currentTime = System.currentTimeMillis();
                            long dif = currentTime - InputComboBox2.this.lastKeyEventTime;
                            if (dif > keyEventTimeWindow) {
                                InputComboBox2.this.lastKeyEvents = t;
                            } else {
                                InputComboBox2.this.lastKeyEvents = InputComboBox2.this.lastKeyEvents + t;
                            }
                            InputComboBox2.this.lastKeyEventTime = currentTime;
                            if (InputComboBox2.this.comboPopUp != null) {
                                if (InputComboBox2.this.comboPopUp.getView() instanceof DefaultListViewPopupInsert) {
                                    ((DefaultListViewPopupInsert)InputComboBox2.this.comboPopUp.getView()).tryToSelectItemStartsWith(InputComboBox2.this.lastKeyEvents);
                                }
                            } else {
                                InputComboBox2.this.tryToSelectItemStartsWith(InputComboBox2.this.lastKeyEvents);
                            }
                        }
                    }
                }
            };
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(this.keyListener, 8L);
    }

    private void enterPressed() {
        for (EnterListener l : this.enterListener) {
            l.enterPressed(this);
        }
    }

    private void deregisterKeyEvents() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.keyListener);
    }

    private void tryToSelectItemStartsWith(String t) {
        block2: {
            long id;
            block3: {
                if (this.inputState != InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE && this.inputState != InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG || this.unitNode == null || this.unitNode.getValue() == null) break block2;
                id = System.currentTimeMillis();
                if (!(this.unitNode.getValue() instanceof UnitComplete)) break block3;
                Node u = null;
                u = this.possibleUnits != null && this.possibleUnits.getChildCount() > 0 ? this.possibleUnits : NodeToolkit.getAffixList(UnitComplete.class);
                Converter c = ConverterRegistry.getConverter(UnitConverter.class);
                Iterator it = u.getChilds();
                while (it.hasNext()) {
                    Node dto = (Node)it.next();
                    Node dto2 = null;
                    dto2 = dto.getValue() instanceof UnitSystemComplete ? dto.getChildNamed(UnitSystemComplete_.maxUnit) : dto;
                    String a = (String)c.convert(dto2.getValue(), dto2, new Object[0]);
                    if (!a.toLowerCase().startsWith(t.toLowerCase())) continue;
                    this.unitNode.setValue(dto2.getValue(), id);
                    return;
                }
                break block2;
            }
            if (!(this.unitNode.getValue() instanceof CurrencyComplete)) break block2;
            Node c = NodeToolkit.getAffixList(CurrencyComplete.class);
            CurrencyConverter con = (CurrencyConverter)ConverterRegistry.getConverter(CurrencyConverter.class);
            Iterator it = c.getChilds();
            while (it.hasNext()) {
                Node dto = (Node)it.next();
                String a = con.convert((CurrencyComplete)dto.getValue(), dto, new Object[0]);
                if (!a.toLowerCase().startsWith(t.toLowerCase())) continue;
                this.unitNode.setValue(dto.getValue(), id);
                return;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.currentState != Button.ButtonState.DISABLED && (Button.pressedItem == null || Button.pressedItem == this) && this.currentState != Button.ButtonState.STATE_FOCUS_LEFT && this.currentState != Button.ButtonState.STATE_FOCUS_RIGHT) {
            if (this.currentState == Button.ButtonState.ERROR) {
                this.newState = Button.ButtonState.OVER;
            } else {
                this.currentState = Button.ButtonState.OVER;
            }
            this.repaint(32L);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.currentState != Button.ButtonState.DISABLED) {
            if (this.currentState != Button.ButtonState.STATE_FOCUS_LEFT && this.currentState != Button.ButtonState.STATE_FOCUS_RIGHT) {
                if (this.currentState == Button.ButtonState.ERROR) {
                    this.newState = Button.ButtonState.UP;
                } else {
                    this.currentState = Button.ButtonState.UP;
                }
                this.setCursor(new Cursor(0));
                this.repaint(23L);
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.currentState != Button.ButtonState.DISABLED) {
            this.isDown = true;
            Button.pressedItem = this;
            if (e.getX() > this.textField.getWidth() && e.getX() < this.getWidth() || this.unitReadOnly == e.getSource()) {
                this.requestFocusInWindow();
                this.showPopup();
            }
        }
    }

    public void setDefaultSorter(Comparator defaultSorter) {
        this.defaultSorter = defaultSorter;
    }

    public Comparator getDefaultSorter() {
        return this.defaultSorter;
    }

    private void initPopup(Node it, Converter vc) {
        if (this.comboPopUp == null) {
            this.comboPopUp = InnerPopUp2.getInnerPopUp();
            this.comboPopUp.setAttributes(null, false, false, "");
            if (this.defaultSorter != null && this.defaultSorter instanceof ConfiguratableComparator) {
                ((ConfiguratableComparator)this.defaultSorter).setAttribute(this.defaultSorterUserObject);
            }
            DefaultListViewPopupInsert v = new DefaultListViewPopupInsert(it, vc, this, this.defaultSorter);
            v.setSorter(this.defaultSorter);
            this.comboPopUp.setView(v);
            if (this.unitNode instanceof ProxyNode) {
                v.selectCurrentSelection(((ProxyNode)this.unitNode).getRefNode());
            } else {
                v.selectCurrentSelection(this.unitNode);
            }
            this.comboPopUp.showPopUp(this.getWidth() - this.defaultUnitWidth, this.getHeight(), this.defaultUnitWidth - 5, v.getDefaultEntryHeight() * 7, this, this, PopupType.INPUTCOMBO);
            if ((this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE || this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG) && this.unitNode != null && this.unitNode.getValue() != null) {
                String name = "";
                if (this.unitNode.getValue() instanceof UnitComplete) {
                    Converter c = ConverterRegistry.getConverter(UnitConverter.class);
                    name = (String)c.convert(this.unitNode.getValue(), this.unitNode, new Object[0]);
                    v.tryToSelectItemStartsWith(name);
                } else if (this.unitNode.getValue() instanceof CurrencyComplete) {
                    Converter con = ConverterRegistry.getConverter(CurrencyConverter.class);
                    name = (String)con.convert(this.unitNode.getValue(), this.unitNode, new Object[0]);
                    v.tryToSelectItemStartsWith(name);
                }
            }
        }
    }

    private void closePopup() {
        if (this.comboPopUp != null) {
            this.comboPopUp.hidePopUp(new Object[0]);
        }
    }

    private void showPopup() {
        if ((this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE || this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG) && this.unitNode != null && this.unitNode.getValue() != null) {
            if (this.unitNode.getValue() instanceof UnitComplete) {
                Node u = null;
                if (this.possibleUnits != null && this.possibleUnits.getChildCount() > 0) {
                    u = this.possibleUnits;
                } else {
                    ArrayList<Node<UnitComplete>> list = new ArrayList<Node<UnitComplete>>();
                    if (NodeToolkit.getAffixList(UnitComplete.class) != null) {
                        Iterator it = NodeToolkit.getAffixList(UnitComplete.class).getChilds();
                        while (it.hasNext()) {
                            Node sys = (Node)it.next();
                            UnitToolkit.generateUnitView((Node<UnitComplete>)sys.getChildNamed(UnitSystemComplete_.maxUnit), null, list, true);
                        }
                    }
                    u = new ViewNode("list");
                    ((ViewNode)u).addChildren(list);
                }
                this.initPopup(u, ConverterRegistry.getConverter(UnitConverter.class));
            } else if (this.unitNode.getValue() instanceof CurrencyComplete) {
                Node c = null;
                c = this.possibleUnits == null ? NodeToolkit.getAffixList(CurrencyComplete.class) : this.possibleUnits;
                this.initPopup(c, ConverterRegistry.getConverter(CurrencyConverter.class));
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.currentState != Button.ButtonState.DISABLED) {
            Button.pressedItem = null;
            this.isDown = false;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.currentState != Button.ButtonState.DISABLED) {
            SelectionManager.getSelectionManager().focusGained(this);
            if (e.getSource() == this) {
                Button.pressedItem = this;
                this.registerKeyEvents();
                this.setState(Button.ButtonState.STATE_FOCUS_RIGHT);
                if (this.visibleContainer != null) {
                    this.visibleContainer.scrollTo(this);
                }
            } else if (e.getSource() == this.textField.getTextField()) {
                Button.pressedItem = this.textField.getTextField();
                this.setState(Button.ButtonState.STATE_FOCUS_LEFT);
                if (!this.isDown && this.visibleContainer != null) {
                    this.visibleContainer.scrollTo(this);
                }
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.currentState != Button.ButtonState.DISABLED) {
            if (this.currentState == Button.ButtonState.STATE_FOCUS_RIGHT) {
                this.deregisterKeyEvents();
            }
            if (e.getOppositeComponent() != this && e.getOppositeComponent() != this.textField.getTextField()) {
                this.closePopup();
                this.setState(Button.ButtonState.UP);
            }
            this.repaint(32L);
        }
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
        if (this.comboPopUp != null) {
            this.comboPopUp = null;
        }
        if (xargs != null) {
            Node n = (Node)xargs[0];
            if (n instanceof Node) {
                this.selectedUnit = (UnitComplete)n.getValue();
            }
            this.valueChanged(this.textField);
            if (!this.textField.isKilled()) {
                this.textField.fireTextFieldEvent();
            }
        }
        this.ensureKommaStellen((UnitComplete)this.unitNode.getValue());
    }

    @Override
    public void lafAttributeChanged(String att) {
        if (activTextColor == null) {
            activTextColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
            disabledTextColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_disabled_color"));
        }
    }

    public static int getPreferredWidth(Component c, int inputState) {
        InputComboBox2.ensureMinUnitWidth(c);
        if (inputState == 11 || inputState == 3) {
            int tw = minUnitWidth_editable;
            tw = minUnitWidth_editable + minAmountWidth;
            return tw;
        }
        int tw = minUnitWidth;
        return tw += minAmountWidth;
    }

    public static int getPreferredUnitWidth(Component c) {
        InputComboBox2.ensureMinUnitWidth(c);
        return minUnitWidth;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.visibleContainer = pane;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.textField.requestFocusInWindowNow();
    }

    @Override
    public void valueChanged(AbstractTextField field) {
        String t = field.getText();
        t = NumberTextField.getUnifiedDecimalString(t);
        if (this.unitReadOnly != null && this.unitReadOnly.getViewConverter() != null) {
            this.unitReadOnly.setText((String)this.unitReadOnly.getViewConverter().convert((Object)this.selectedUnit, null, new Object[0]));
        }
        if (t.isEmpty()) {
            return;
        }
        switch (this.inputState) {
            case PRICE_AND_UNIT_LONG: 
            case PRICE_LONG: {
                this.handleLongValueChanged(t);
                break;
            }
            case PRICE_AND_UNIT_INT: 
            case PRICE_INT: {
                this.handleAsInt(t);
                break;
            }
            case PRICE_AND_UNIT_DOUBLE: 
            case PRICE_DOUBLE: {
                this.handleAsDouble(t);
                break;
            }
        }
    }

    private boolean handleLongValueChanged(String t) {
        if (!this.useLongAsInteger) {
            return this.handleAsLong(t);
        }
        return this.handleAsInt(t);
    }

    private boolean handleAsInt(String t) {
        try {
            int i = Integer.valueOf(t);
            this.amountNode.setValue((Object)i, System.currentTimeMillis());
            this.unitNode.setValue((Object)this.selectedUnit, System.currentTimeMillis());
            return true;
        }
        catch (NumberFormatException i) {
            UnitComplete u = this.selectedUnit;
            try {
                double value = Double.valueOf(t);
                int k = this.getDecimalsCount(t);
                int ck = 0;
                while (u.getSubUnit() != null && k > ck) {
                    ck = (int)((double)ck + Math.log10(u.getSubUnit().getConversionFactor().intValue()));
                    u = u.getSubUnit();
                }
                this.amountNode.setValue((Object)((int)(value *= Math.pow(10.0, ck))), System.currentTimeMillis());
                this.unitNode.setValue((Object)u, System.currentTimeMillis());
                if (this.unitReadOnly != null) {
                    this.unitReadOnly.invalidate();
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }

    private boolean handleAsDouble(String t) {
        UnitComplete u = this.selectedUnit;
        try {
            double value = Double.valueOf(t);
            int k = this.getDecimalsCount(t);
            int ck = 0;
            if (u != null) {
                while (u.getSubUnit() != null && k > ck) {
                    ck = (int)((double)ck + Math.log10(u.getSubUnit().getConversionFactor().intValue()));
                    u = u.getSubUnit();
                }
            }
            this.amountNode.setValue((Object)(value *= Math.pow(10.0, ck)), System.currentTimeMillis());
            if (u != null) {
                this.unitNode.setValue((Object)u, System.currentTimeMillis());
            }
            if (this.unitReadOnly != null) {
                this.unitReadOnly.invalidate();
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean handleAsLong(String t) {
        try {
            long i = Long.valueOf(t);
            this.amountNode.setValue((Object)i, System.currentTimeMillis());
            this.unitNode.setValue((Object)this.selectedUnit, System.currentTimeMillis());
            return true;
        }
        catch (NumberFormatException i) {
            UnitComplete u = this.selectedUnit;
            try {
                double value = Double.valueOf(t);
                int k = this.getDecimalsCount(t);
                int ck = 0;
                while (u.getSubUnit() != null && k > ck) {
                    ck = (int)((double)ck + Math.log10(u.getSubUnit().getConversionFactor().intValue()));
                    u = u.getSubUnit();
                }
                this.amountNode.setValue((Object)((long)(value *= Math.pow(10.0, ck))), System.currentTimeMillis());
                this.unitNode.setValue((Object)u, System.currentTimeMillis());
                if (this.unitReadOnly != null) {
                    this.unitReadOnly.invalidate();
                }
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }

    private int getDecimalsCount(String t) {
        int i = t.indexOf(".");
        if (i != -1) {
            return t.length() - i;
        }
        return 0;
    }

    public void addActionListener(ActionListener articlePanel) {
        if (this.textField != null) {
            this.textField.getTextField().addActionListener(articlePanel);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.enterPressed();
    }

    @Override
    public void addEnterListener(EnterListener listener) {
        this.enterListener.add(listener);
    }

    @Override
    public void removeEnterListener(EnterListener listener) {
        this.enterListener.remove(listener);
    }

    public TextField getTextField() {
        return this.textField;
    }

    @Override
    public void setPermanent(boolean isPermantent) {
    }

    static {
        minUnitWidth_editable = -1;
        minUnitWidth = -1;
        minAmountWidth = -1;
        keyEventTimeWindow = 500L;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (InputComboBox2.this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE || InputComboBox2.this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG) {
                int aTw = InputComboBox2.this.defaultUnitWidth;
                InputComboBox2.this.textField.setLocation(0, 0);
                InputComboBox2.this.textField.setSize(parent.getWidth() - aTw, (int)InputComboBox2.this.textField.getPreferredSize().getHeight());
                if (InputComboBox2.this.unitReadOnly != null) {
                    InputComboBox2.this.unitReadOnly.setLocation(InputComboBox2.this.textField.getX() + InputComboBox2.this.textField.getWidth() + 7, InputComboBox2.this.textField.getY() - 1);
                    InputComboBox2.this.unitReadOnly.setSize(aTw, (int)InputComboBox2.this.unitReadOnly.getPreferredSize().getHeight());
                }
            } else {
                int aTw = (int)InputComboBox2.this.unitReadOnly.getPreferredSize().getWidth();
                InputComboBox2.this.textField.setLocation(0, 0);
                InputComboBox2.this.textField.setSize(minAmountWidth, (int)InputComboBox2.this.textField.getPreferredSize().getHeight());
                if (InputComboBox2.this.unitReadOnly != null) {
                    InputComboBox2.this.unitReadOnly.setLocation(InputComboBox2.this.textField.getX() + InputComboBox2.this.textField.getWidth() + 5, InputComboBox2.this.textField.getY() - 1);
                    InputComboBox2.this.unitReadOnly.setSize(aTw, (int)InputComboBox2.this.unitReadOnly.getPreferredSize().getHeight());
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int tw = InputComboBox2.this.defaultUnitWidth + InputComboBox2.this.skin.getImage11(InputComboBox2.this.currentState).getWidth() + InputComboBox2.this.skin.getImage21(InputComboBox2.this.currentState).getWidth() + InputComboBox2.this.skin.getImage31(InputComboBox2.this.currentState).getWidth();
            if (InputComboBox2.this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE || InputComboBox2.this.inputState == InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG) {
                tw = InputComboBox2.this.defaultUnitWidth + minAmountWidth;
            } else if (InputComboBox2.this.unitReadOnly != null) {
                tw = (int)(InputComboBox2.this.unitReadOnly.getPreferredSize().getWidth() + (double)minAmountWidth + 5.0);
            }
            return new Dimension(tw, InputComboBox2.this.skin.getImage11(InputComboBox2.this.currentState).getHeight());
        }
    }
}

