/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.article.details.utils.ArticlePackingVariantsTable;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainer;
import ch.icit.pegasus.client.gui.utils.focus.MutableFocusContainerListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTONode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitSystemComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight_;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityComplete_;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.UnitConversionToolkit;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArticlePackagingTable
extends JPanelFadable
implements Focusable,
MutableFocusContainer {
    private static final long serialVersionUID = 1L;
    private Table2 conversionTable;
    private Node node;
    private boolean isTemplateLoading;
    private boolean isDeletable;
    private final ArticlePackingVariantsTable articlePackingVariantsTable;
    private final boolean factorChanged = false;
    private RDProvider provider;
    private final DtoField accessField;
    private final List<ArticlePackagingTableListener> listener = new ArrayList<ArticlePackagingTableListener>();

    public ArticlePackagingTable(RDProvider provider, DtoField accessField, final ArticlePackingVariantsTable articlePackingVariantsTable) {
        this.provider = provider;
        this.accessField = accessField;
        this.isDeletable = provider != null ? provider.isWritable(accessField) : true;
        this.articlePackingVariantsTable = articlePackingVariantsTable;
        this.setOpaque(false);
        this.setLayout(new Layout());
        this.conversionTable = new Table2(true, Words.ADD);
        this.conversionTable.setOverrideName(accessField);
        this.conversionTable.setUseWriteAccessRight(true);
        this.conversionTable.setProvider(provider);
        this.conversionTable.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                for (Table2RowPanel p : ArticlePackagingTable.this.conversionTable.getRows()) {
                    TableRowImpl pp = (TableRowImpl)p;
                    pp.ensureConversionState();
                }
                if (articlePackingVariantsTable != null) {
                    articlePackingVariantsTable.ensureUnitsAreSelectableForStoreUnit();
                }
                ArticlePackagingTable.this.ensureSelectableUnits();
                ArticlePackagingTable.this.revalidateStoreUnit();
                ArticlePackagingTable.this.updateSequenceNumbers();
                ArticlePackagingTable.this.validate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                Node storeUnitNode;
                PackagingQuantityComplete pqc = new PackagingQuantityComplete();
                pqc.setAmount(Integer.valueOf(1));
                pqc.setUnit(ArticlePackagingTable.this.getFreeUnit());
                pqc.setSequenceNumber(Integer.valueOf(ArticlePackagingTable.this.conversionTable.getRowCount()));
                if (ArticlePackagingTable.this.conversionTable.getRowCount() == 0 && (storeUnitNode = ArticlePackagingTable.this.node.getParent().getChildNamed(BasicArticleLight_.priceUnit)) != null) {
                    storeUnitNode.setValue((Object)pqc.getUnit(), System.currentTimeMillis());
                }
                Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)pqc, false, false);
                ArticlePackagingTable.this.conversionTable.getModel().getNode().addChild(n, System.currentTimeMillis());
                if (articlePackingVariantsTable != null) {
                    articlePackingVariantsTable.ensureUnitsAreSelectableForStoreUnit();
                }
                ArticlePackagingTable.this.ensureSelectableUnits();
                ArticlePackagingTable.this.revalidateStoreUnit();
                ArticlePackagingTable.this.updateSequenceNumbers();
            }
        });
        int tw = this.conversionTable.getCellPadding() * 2 + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.CONVERSION, null, null, null, "", 30, 30, 30));
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        this.conversionTable.setModel(new Table2Model(columns, model -> new TableRowImpl(model)));
        this.conversionTable.setProgress(1.0f);
        this.add(this.conversionTable);
    }

    private void fireEvent() {
        for (ArticlePackagingTableListener p : this.listener) {
            p.tableChanged();
        }
    }

    private UnitComplete getFreeUnit() {
        Iterator it = NodeToolkit.getAffixList(UnitSystemComplete.class).getChilds();
        while (it.hasNext()) {
            Node unit = (Node)it.next();
            UnitComplete maxUnit = ((UnitSystemComplete)unit.getValue()).getMaxUnit();
            boolean found = false;
            for (Table2RowPanel p : this.conversionTable.getRows()) {
                if (p.getModel().getNode().getChildNamed(PackagingQuantityComplete_.unit) == null) continue;
                UnitComplete cu = (UnitComplete)p.getModel().getNode().getChildNamed(PackagingQuantityComplete_.unit).getValue();
                while (cu.getSuperUnit() != null) {
                    cu = cu.getSuperUnit();
                }
                if (!maxUnit.equals((Object)cu)) continue;
                found = true;
            }
            if (found) continue;
            if (((UnitSystemComplete)unit.getValue()).getBaseUnit() == null) {
                return ((UnitSystemComplete)unit.getValue()).getMaxUnit();
            }
            return ((UnitSystemComplete)unit.getValue()).getBaseUnit();
        }
        return null;
    }

    public void setNode(Node<List<PackagingQuantityComplete>> node) {
        this.node = node;
        this.conversionTable.getModel().setNode(this.node);
        this.ensureSelectableUnits();
        this.revalidateStoreUnit();
    }

    public List<ScreenValidationObject> validateInput() {
        ArrayList<ScreenValidationObject> o = new ArrayList<ScreenValidationObject>();
        boolean isValid = true;
        for (Table2RowPanel p : this.conversionTable.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (pp.validateInput()) continue;
            isValid = false;
        }
        if (!isValid) {
            o.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Review Packaging Table"));
        }
        return o;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.conversionTable);
        return a;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.conversionTable.setLocked(enabled);
    }

    protected void ensureSelectableUnits(Table2RowPanel p) {
        for (Table2RowPanel panel : this.conversionTable.getRows()) {
            if (panel == p) continue;
            TableRowImpl pp = (TableRowImpl)panel;
            pp.setSelectableUnits(this.getSelectableUnits(pp));
        }
    }

    protected void ensureSelectableUnits() {
        this.ensureSelectableUnits(null);
    }

    protected Node getSelectableUnits(TableRowImpl currentPanel) {
        ViewNode n = new ViewNode("units");
        Node list = NodeToolkit.getAffixList(UnitSystemComplete.class);
        Iterator it = list.getChilds();
        while (it.hasNext()) {
            Node n2 = (Node)it.next();
            List<Node<UnitComplete>> l = UnitToolkit.generateUnitView((Node<UnitComplete>)n2.getChildNamed(UnitSystemComplete_.maxUnit), null, null, true);
            for (Node<UnitComplete> ll : l) {
                Iterator it2 = n.getChilds();
                boolean found = false;
                while (it2.hasNext()) {
                    Node nn = (Node)it2.next();
                    if (!nn.getValue().equals(ll.getValue())) continue;
                    found = true;
                }
                if (found) continue;
                n.addChild(ll, 0L);
            }
        }
        for (Table2RowPanel panel : this.conversionTable.getRows()) {
            Node p1;
            if (panel == currentPanel || (p1 = panel.getModel().getNode().getChildNamed(PackagingQuantityComplete_.unit)) == null || p1.getValue() == null) continue;
            it = n.getChilds();
            while (it.hasNext()) {
                Node unit = (Node)it.next();
                if (((UnitComplete)unit.getValue()).equals(p1.getValue())) {
                    it.remove();
                    continue;
                }
                UnitComplete cu = (UnitComplete)p1.getValue();
                boolean deleteted = false;
                while (cu.getSuperUnit() != null && !deleteted) {
                    if (cu.getSuperUnit().equals(unit.getValue())) {
                        it.remove();
                        deleteted = true;
                        continue;
                    }
                    cu = cu.getSuperUnit();
                }
                cu = (UnitComplete)p1.getValue();
                while (cu.getSubUnit() != null && !deleteted) {
                    if (cu.getSubUnit().equals(unit.getValue())) {
                        it.remove();
                        deleteted = true;
                        continue;
                    }
                    cu = cu.getSubUnit();
                }
            }
        }
        return n;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    public boolean isInnerComponent(Component c) {
        return this.conversionTable.isInnerComponent(c);
    }

    public PackagingQuantityComplete getPackQuantity() {
        PackagingQuantityComplete q = null;
        return q;
    }

    private PackagingQuantityComplete copyTable(PackagingQuantityComplete q) {
        if (q == null) {
            return null;
        }
        PackagingQuantityComplete qq = new PackagingQuantityComplete();
        qq.setUnit(q.getUnit());
        return qq;
    }

    private void updateSequenceNumbers() {
        Iterator it = this.node.getFailSafeChildIterator();
        int i = 0;
        while (it.hasNext()) {
            DTONode next = (DTONode)it.next();
            next.commit();
            PackagingQuantityComplete conversionEntry = (PackagingQuantityComplete)next.getValue();
            conversionEntry.setSequenceNumber(Integer.valueOf(i++));
            next.updateNode();
        }
    }

    private void revalidateStoreUnit() {
        this.fireEvent();
    }

    public void commitTable(Node commitingNode) {
        Object q = null;
        Object current = null;
        Iterator it = this.node.getChilds();
        while (it.hasNext()) {
            Node node = (Node)it.next();
        }
        if (commitingNode != null) {
            commitingNode.removeExistingValues();
            commitingNode.setValue(q, 0L);
            commitingNode.updateNode();
        }
    }

    public void setTemplateLoadingDisabled() {
        this.isTemplateLoading = false;
    }

    public void setTemplateLoadingActive() {
        this.isTemplateLoading = true;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    @Override
    public void removeFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.conversionTable.getModel().removeFocusCycleChangeListener(listener);
    }

    @Override
    public void addFocusCycleChangeListener(MutableFocusContainerListener listener) {
        this.conversionTable.getModel().addFocusCycleChangeListener(listener);
    }

    public boolean hasGrammageUnit() {
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        for (Table2RowPanel p : this.conversionTable.getRows()) {
            TableRowImpl i = (TableRowImpl)p;
            if (!i.isGrammageUnit(s.getDefaultCustomsPenaltyUnit())) continue;
            return true;
        }
        return false;
    }

    public static interface ArticlePackagingTableListener {
        public void tableChanged();
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener,
    NodeListener {
        private static final long serialVersionUID = 1L;
        private RDTextField amountField;
        private TextLabel amountLabel;
        private RDComboBox unitSelection;
        private boolean isFirst;
        private final int backupValue;
        private TextLabel aLabel;
        private DeleteButton deleteButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.isFirst = false;
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            int index = (Integer)m.getNode().getChildNamed(PackagingQuantityComplete_.sequenceNumber).getValue();
            if (index == 0) {
                this.isFirst = true;
            }
            if (this.isFirst) {
                this.amountLabel = new TextLabel(m.getNode().getChildNamed(new String[]{"amount"}), ConverterRegistry.getConverter(IntegerConverter.class));
            } else {
                this.amountField = new RDTextField(ArticlePackagingTable.this.provider, TextFieldType.INT);
                this.amountField.setOverrideName(ArticlePackagingTable.this.accessField);
                this.amountField.setNode(m.getNode().getChildNamed(new String[]{"amount"}));
            }
            this.backupValue = (Integer)m.getNode().getChildNamed(new String[]{"amount"}).getValue();
            this.unitSelection = new RDComboBox(ArticlePackagingTable.this.provider, ConverterRegistry.getConverter(UnitConverter.class));
            this.unitSelection.setOverrideName(ArticlePackagingTable.this.accessField);
            this.unitSelection.refreshPossibleValues(UnitToolkit.getAllUnits());
            this.unitSelection.setNode(m.getNode().getChildNamed(new String[]{"unit"}));
            this.unitSelection.addItemListener(e -> {
                if (e.getStateChange() == 1 && ArticlePackagingTable.this.articlePackingVariantsTable != null) {
                    ArticlePackagingTable.this.articlePackingVariantsTable.ensureUnitsAreSelectableForStoreUnit();
                }
            });
            m.getNode().getChildNamed(new String[]{"unit"}).addNodeListener((NodeListener)this);
            m.getNode().getChildNamed(new String[]{"amount"}).addNodeListener((NodeListener)this);
            this.unitSelection.setProgress(1.0f);
            this.aLabel = new TextLabel(Words.A);
            if (!this.isFirst && ArticlePackagingTable.this.isDeletable) {
                this.deleteButton = new DeleteButton(SizedSkin1Field.SkinSize.SMALL);
                this.deleteButton.addButtonListener(this);
            }
            this.setLayout(new InnerLayout());
            if (this.isFirst) {
                this.add(this.amountLabel);
            } else {
                this.add(this.amountField);
                if (this.deleteButton != null) {
                    this.add(this.deleteButton);
                }
            }
            this.add(this.unitSelection);
            this.add(this.aLabel);
        }

        @Override
        public Object getObject4Column(int column) {
            return this.model.getNode().getChildNamed(PackagingQuantityComplete_.sequenceNumber).getValue();
        }

        @Override
        public boolean isInnerComponent(Component c) {
            return this.unitSelection.isInnerComponent(c);
        }

        public boolean isGrammageUnit(UnitComplete unitComplete) {
            if (this.model == null || this.model.getNode() == null) {
                return false;
            }
            Node uN = this.model.getNode().getChildNamed(PackagingQuantityComplete_.unit);
            if (uN == null) {
                return false;
            }
            UnitComplete unit = (UnitComplete)uN.getValue();
            UnitSystemComplete o = UnitToolkit.getUnitSystem4Unit(unit);
            UnitSystemComplete o2 = UnitToolkit.getUnitSystem4Unit(unitComplete);
            return o.equals((Object)o2);
        }

        public boolean validateInput() {
            if (this.isFirst) {
                return true;
            }
            if (this.amountField.getNode().getValue() == null) {
                this.amountField.getNode().setValue((Object)0, 0L);
            }
            if ((Integer)this.amountField.getNode().getValue() <= 0) {
                this.amountField.setInvalid();
                return false;
            }
            this.amountField.setValid();
            return true;
        }

        public String getWarnings() {
            int d = (Integer)this.model.getNode().getChildNamed(PackagingQuantityComplete_.amount).getValue();
            if (d == this.backupValue) {
                return null;
            }
            return "Factor changed. The price is may inconsistent!";
        }

        protected void ensureConversionState() {
            int index = ArticlePackagingTable.this.node.getChildIndex(this.model.getNode());
            if (index == 0) {
                this.isFirst = true;
            }
            if (this.isFirst) {
                this.model.getNode().getChildNamed(PackagingQuantityComplete_.amount).setValue((Object)1, System.currentTimeMillis());
                if (this.amountLabel == null) {
                    this.amountLabel = new TextLabel(this.model.getNode().getChildNamed(PackagingQuantityComplete_.amount), ConverterRegistry.getConverter(IntegerConverter.class));
                    this.add(this.amountLabel);
                }
                if (this.amountField != null) {
                    this.amountField.setVisible(false);
                }
                this.amountLabel.setProgress(1.0f);
                this.amountLabel.setVisible(true);
                this.invalidate();
                this.validate();
            }
        }

        protected void setSelectableUnits(Node n) {
            this.unitSelection.refreshPossibleValues(n);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.amountField != null) {
                this.amountField.kill();
            }
            if (this.amountLabel != null) {
                this.amountLabel.kill();
            }
            if (this.model != null && this.model.getNode() != null && this.model.getNode().getChildNamed(PackagingQuantityComplete_.unit) != null) {
                this.model.getNode().getChildNamed(PackagingQuantityComplete_.unit).removeNodeListener((NodeListener)this);
            }
            this.unitSelection.kill();
            this.aLabel.kill();
            if (this.deleteButton != null) {
                this.deleteButton.kill();
            }
            this.amountField = null;
            this.unitSelection = null;
            this.aLabel = null;
            this.deleteButton = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            if (this.amountField != null) {
                this.amountField.setEnabled(isEnabled);
            }
            if (this.amountLabel != null) {
                this.amountLabel.setEnabled(isEnabled);
            }
            this.unitSelection.setEnabled(isEnabled);
            this.aLabel.setEnabled(isEnabled);
            if (this.deleteButton != null) {
                this.deleteButton.setEnabled(isEnabled);
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.amountField);
            CheckedListAdder.addToList(a, this.unitSelection);
            CheckedListAdder.addToList(a, this.deleteButton);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            if (this.amountField != null) {
                this.amountField.requestFocusInWindowNow();
            } else {
                this.unitSelection.requestFocusInWindowNow();
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.deleteButton) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            }
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public void valueChanged(Node<?> node) {
            if (ArticlePackagingTable.this.isTemplateLoading || this.isKilled()) {
                return;
            }
            if (node.getName().equals("unit")) {
                ArticlePackagingTable.this.revalidateStoreUnit();
            }
            ArticlePackagingTable.this.ensureSelectableUnits(this);
            if (ArticlePackagingTable.this.articlePackingVariantsTable != null) {
                ArticlePackagingTable.this.articlePackingVariantsTable.ensureUnitsAreSelectableForStoreUnit();
                ArticlePackagingTable.this.articlePackingVariantsTable.updateOrderIntervalUnits();
            }
        }

        public boolean isSwingOnly() {
            return true;
        }

        public List<UnitComplete> getPossibleUnits() {
            if (this.unitSelection.getEditor() != null && ((ComboBox)this.unitSelection.getEditor()).getSelectedItem() != null) {
                return UnitConversionToolkit.getAllUnits((UnitComplete)((UnitComplete)((Node)((ComboBox)this.unitSelection.getEditor()).getSelectedItem()).getValue()));
            }
            if (this.unitSelection.getRenderer() != null) {
                return UnitConversionToolkit.getAllUnits((UnitComplete)((UnitComplete)((TextLabel)this.unitSelection.getRenderer()).getNode().getValue()));
            }
            return new ArrayList<UnitComplete>();
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                int dt = 2 * TableRowImpl.this.getCellPadding() + 2 * TableRowImpl.this.getInnerCellPadding();
                if (TableRowImpl.this.aLabel != null) {
                    dt = (int)((double)dt + TableRowImpl.this.aLabel.getPreferredSize().getWidth());
                }
                int tw = w - dt;
                if (TableRowImpl.this.amountField != null) {
                    TableRowImpl.this.amountField.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.amountField.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.amountField.setSize(tw / 2, (int)TableRowImpl.this.amountField.getPreferredSize().getHeight());
                    if (TableRowImpl.this.unitSelection != null) {
                        TableRowImpl.this.unitSelection.setLocation(TableRowImpl.this.amountField.getX() + TableRowImpl.this.amountField.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.unitSelection.getPreferredSize().getHeight()) / 2.0));
                        TableRowImpl.this.unitSelection.setSize(tw / 2, (int)TableRowImpl.this.unitSelection.getPreferredSize().getHeight());
                    }
                }
                if (TableRowImpl.this.amountLabel != null) {
                    TableRowImpl.this.amountLabel.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.amountLabel.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.amountLabel.setSize(tw / 2, (int)TableRowImpl.this.amountLabel.getPreferredSize().getHeight());
                    if (TableRowImpl.this.unitSelection != null) {
                        TableRowImpl.this.unitSelection.setLocation(TableRowImpl.this.amountLabel.getX() + TableRowImpl.this.amountLabel.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.unitSelection.getPreferredSize().getHeight()) / 2.0));
                        TableRowImpl.this.unitSelection.setSize(tw / 2, (int)TableRowImpl.this.unitSelection.getPreferredSize().getHeight());
                    }
                }
                if (TableRowImpl.this.aLabel != null && TableRowImpl.this.unitSelection != null) {
                    TableRowImpl.this.aLabel.setLocation(TableRowImpl.this.unitSelection.getX() + TableRowImpl.this.unitSelection.getWidth() + TableRowImpl.this.getInnerCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.aLabel.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.aLabel.setSize(TableRowImpl.this.aLabel.getPreferredSize());
                }
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.setControlsX(currentX);
                if (TableRowImpl.this.deleteButton != null) {
                    TableRowImpl.this.deleteButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.deleteButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.deleteButton.setSize(TableRowImpl.this.deleteButton.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            ArticlePackagingTable.this.conversionTable.setLocation(0, 0);
            ArticlePackagingTable.this.conversionTable.setSize(parent.getWidth(), parent.getHeight());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 250);
        }
    }
}

