/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.popup.inserts.export;

import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;

public abstract class AnalysisItem<T extends JPanel>
implements Focusable {
    private static final long serialVersionUID = 1L;
    private T element;
    private String name;
    private List<String[]> multiValues;
    private AnalysisItem<T> subItem;
    private boolean growHeight;

    public AnalysisItem(T element, String name, boolean growHeight) {
        this(element, name);
        this.setGrowHeight(growHeight);
    }

    public AnalysisItem(T element, String name) {
        this.element = element;
        this.name = name;
    }

    public AnalysisItem(T element, String name, List<String[]> multiValues) {
        this.element = element;
        this.name = name;
        this.multiValues = multiValues;
    }

    public T getElement() {
        return this.element;
    }

    public String getName() {
        return this.name;
    }

    public List<String[]> getMultiValues() {
        return this.multiValues;
    }

    public abstract Object getPersistValue();

    public abstract void updatePersistValue(String var1);

    @Override
    public List<Component> getFocusComponents() {
        if (this.getElement() instanceof Focusable) {
            return ((Focusable)this.getElement()).getFocusComponents();
        }
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        if (this.getElement() instanceof Focusable) {
            ((Focusable)this.getElement()).setVisibleContainer(pane);
        }
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        if (this.getElement() instanceof Focusable) {
            return ((Focusable)this.getElement()).getSelectDelegationComponent();
        }
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        if (this.getElement() instanceof Focusable) {
            ((Focusable)this.getElement()).requestFocusInWindowNow();
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.getElement() instanceof Focusable) {
            return ((Component)this.getElement()).isEnabled();
        }
        return true;
    }

    public void updateMultiValues(FilterChainConfiguration config) {
    }

    public FilterChainConfiguration getMultiPersistValue() {
        return null;
    }

    public AnalysisItem<T> getSubItem() {
        return this.subItem;
    }

    public void setSubItem(AnalysisItem<T> subItem) {
        this.subItem = subItem;
    }

    public boolean isGrowHeight() {
        return this.growHeight;
    }

    public void setGrowHeight(boolean growHeight) {
        this.growHeight = growHeight;
    }
}

