/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.print;

import ch.icit.pegasus.client.gui.utils.print.PDFPrintPage;
import ch.icit.pegasus.server.core.dtos.masterdata.PrintConfigurationComplete;
import ch.icit.util.PrinterToolkit;
import ch.icit.util.PrinterToolkitException;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import java.awt.geom.Rectangle2D;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.SheetCollate;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.printing.PDFPageable;

public class PrintPdf {
    private DocPrintJob dpjob = null;

    public boolean printWithPDFBox(File file, String jobName, boolean withDialog, PrintService printer, PrintConfigurationComplete config, int copies) throws PrinterException, IOException, PrinterToolkitException {
        PrinterJob job = PrinterJob.getPrinterJob();
        PDFParser parser = new PDFParser((RandomAccessRead)new RandomAccessReadBufferedFile(file));
        COSDocument cosDoc = null;
        cosDoc = parser.parse().getDocument();
        PDDocument document = new PDDocument(cosDoc);
        PrintService myPrintService = printer;
        job.setPageable((Pageable)new PDFPageable(document));
        job.setPrintService(myPrintService);
        PDPage page = document.getPage(0);
        PDRectangle bBox = page.getBBox();
        PrintRequestAttributeSet aset = this.createPrintRequestAttributes(withDialog, printer, config, copies, bBox.getUpperRightX(), bBox.getUpperRightY(), bBox.getWidth(), bBox.getHeight(), job);
        job.print(aset);
        return true;
    }

    public boolean print(InputStream inputStream, String jobName, boolean withDialog, PrintService printer, PrintConfigurationComplete config, int copies) throws IOException, PrinterException, PrinterToolkitException, PrintException {
        byte[] pdfContent = new byte[inputStream.available()];
        inputStream.read(pdfContent, 0, inputStream.available());
        return this.initialize(pdfContent, jobName, withDialog, printer, config, copies);
    }

    private boolean initialize(byte[] pdfContent, String jobName, boolean withDialog, PrintService printer, PrintConfigurationComplete config, int copies) throws IOException, PrinterException, PrinterToolkitException, PrintException {
        ByteBuffer bb = ByteBuffer.wrap(pdfContent);
        PDFFile pdfFile = new PDFFile(bb);
        PDFPrintPage pages = new PDFPrintPage(pdfFile);
        this.dpjob = printer.createPrintJob();
        PrinterJob pjob = PrinterJob.getPrinterJob();
        if (pdfFile.getNumPages() <= 0) {
            throw new IllegalArgumentException("Unable to print PDF, no pages found");
        }
        PDFPage page = pdfFile.getPage(0);
        Rectangle2D r = page.getBBox();
        float x = (float)r.getX();
        float y = (float)r.getY();
        float w = page.getWidth() * 25.4f / 72.0f;
        float h = page.getHeight() * 25.4f / 72.0f;
        PrintRequestAttributeSet aset = this.createPrintRequestAttributes(withDialog, printer, config, copies, x, y, w, h, pjob);
        if (aset == null) {
            return false;
        }
        this.dpjob.print(new SimpleDoc(pages, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null), aset);
        return true;
    }

    private PrintRequestAttributeSet createPrintRequestAttributes(boolean withDialog, PrintService printer, PrintConfigurationComplete config, int copies, float x, float y, float w, float h, PrinterJob pjob) throws PrinterToolkitException {
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        if (config != null) {
            List a = PrinterToolkit.getMedia((String)config.getMedias());
            for (Media me : a) {
                aset.add(me);
            }
        }
        aset.add(new Copies(copies));
        aset.add(SheetCollate.COLLATED);
        MediaPrintableArea requestedArea = null;
        if (config != null) {
            if (config.getLandscape().booleanValue()) {
                if (config.getFlipXaxis().booleanValue()) {
                    aset.add(OrientationRequested.REVERSE_LANDSCAPE);
                } else {
                    aset.add(OrientationRequested.LANDSCAPE);
                }
                requestedArea = new MediaPrintableArea(x, y, h, w, 1000);
                aset.add(requestedArea);
            } else {
                if (config.getFlipXaxis().booleanValue()) {
                    aset.add(OrientationRequested.REVERSE_PORTRAIT);
                } else {
                    aset.add(OrientationRequested.PORTRAIT);
                }
                requestedArea = new MediaPrintableArea(x, y, w, h, 1000);
                aset.add(requestedArea);
            }
        } else if (w > h) {
            aset.add(OrientationRequested.LANDSCAPE);
            requestedArea = new MediaPrintableArea(x, y, h, w, 1000);
            aset.add(requestedArea);
        } else {
            aset.add(OrientationRequested.PORTRAIT);
            requestedArea = new MediaPrintableArea(x, y, w, h, 1000);
            aset.add(requestedArea);
        }
        if (config != null) {
            boolean areaFound = false;
            MediaPrintableArea[] supportedAreas = (MediaPrintableArea[])printer.getSupportedAttributeValues(MediaPrintableArea.class, null, aset);
            if (supportedAreas != null) {
                for (MediaPrintableArea area : supportedAreas) {
                    areaFound = this.fitsInArea(requestedArea, area);
                    if (!areaFound) continue;
                    if (!config.getFlipYaxis().booleanValue()) break;
                    int unit = 1000;
                    float yt = requestedArea.getY(1000) + area.getHeight(1000) - requestedArea.getHeight(1000);
                    MediaPrintableArea a = new MediaPrintableArea(requestedArea.getX(1000), yt, requestedArea.getWidth(1000), requestedArea.getHeight(1000), 1000);
                    aset.remove(requestedArea);
                    aset.add(a);
                    break;
                }
            }
        }
        if (withDialog && !pjob.printDialog(aset)) {
            return null;
        }
        return aset;
    }

    private boolean fitsInArea(MediaPrintableArea inner, MediaPrintableArea outer) {
        if (inner == null || outer == null) {
            return false;
        }
        int unit = 1000;
        return inner.getWidth(1000) <= outer.getWidth(1000) && inner.getHeight(1000) <= outer.getHeight(1000);
    }
}

