/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.ArticleChargeBatchConverter;
import ch.icit.pegasus.client.converter.QuantityConverter1Decimal;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2ButtonHandler;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.StorePositionSearchBox;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.node.impls.NodeListenerAdaptor;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.QuantityComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.consumption.ArticleChargePart2Complete;
import ch.icit.pegasus.server.core.dtos.production_new.consumption.ArticleChargePart2Complete_;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ArticlePreparationJobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.ArticlePreparationJobComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobComplete;
import ch.icit.pegasus.server.core.dtos.production_new.jobs.JobReference;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeBatchComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArticleChargePart2ChargeBasedTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    private final Node<JobComplete> jobNode;

    public ArticleChargePart2ChargeBasedTable(Node<JobComplete> jobNode) {
        super(true, Words.ADD, true, true, Words.ARTICLE);
        this.jobNode = jobNode;
        this.setButtonHandler(new Table2ButtonHandler(){

            @Override
            public void childRemoved() {
                ArticleChargePart2ChargeBasedTable.this.revalidate();
            }

            @Override
            public void addButtonPressed(int x, int y, Button source) {
                ArticleChargePart2Complete part = new ArticleChargePart2Complete();
                part.setClientOId(Long.valueOf(ADTO.getNextId()));
                ArticleChargePart2ChargeBasedTable.this.getModel().getNode().addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)part, true, false), 0L);
            }
        });
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.ARTICLE, null, null, null, "", 40));
        columns.add(new TableColumnInfo(Words.STORE, null, null, null, "", 250));
        columns.add(new TableColumnInfo(Words.CHARGE, null, null, null, "", 120));
        columns.add(new TableColumnInfo(Words.STOCK, null, null, null, "", 80));
        columns.add(new TableColumnInfo(Words.QUALITY, null, null, null, "", 120));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.getModel().setNode(jobNode.getChildNamed(ArticlePreparationJobComplete_.articleParts));
    }

    public void processEntries() throws ClientServerCallException {
        Iterator it = this.getModel().getNode().getFailSafeChildIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            node.commitThis();
        }
        this.jobNode.commitThis();
        ArticlePreparationJobComplete job = (ArticlePreparationJobComplete)this.jobNode.getValue();
        job = (ArticlePreparationJobComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).updateJob(job).getValue();
        for (ArticleChargePart2Complete articlePart : job.getArticleParts()) {
            ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).prepareArticle(new JobReference(job.getId()), articlePart, true);
        }
        job = (ArticlePreparationJobComplete)((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).getJob(new JobReference(job.getId())).getValue();
        this.jobNode.removeExistingValues();
        this.jobNode.setValue((Object)job, 0L);
        this.jobNode.updateNode();
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private SearchTextField2<BasicArticleLight> article;
        private StorePositionSearchBox store;
        private ComboBox charge;
        private TextLabel stock;
        private InputComboBox quantity;
        private DeleteButton delete;
        private NodeListenerAdaptor adaptor;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.article = SearchTextField2Factory.getBasicArticleSearchField(true, m.getNode().getChildNamed(ArticleChargePart2Complete_.article));
            this.store = new StorePositionSearchBox();
            this.store.setNode((Node<StorePositionLight>)m.getNode().getChildNamed(ArticleChargePart2Complete_.storePosition));
            this.charge = new ComboBox((Node)new DTOProxyNode(), null, ConverterRegistry.getConverter(ArticleChargeBatchConverter.class));
            this.stock = new TextLabel(null, ConverterRegistry.getConverter(QuantityConverter1Decimal.class));
            this.quantity = new InputComboBox(m.getNode().getChildNamed(new DtoField[]{ArticleChargePart2Complete_.quantity, QuantityComplete_.quantity}), m.getNode().getChildNamed(new DtoField[]{ArticleChargePart2Complete_.quantity, QuantityComplete_.unit}), InputComboBox.InputComboBoxType.PRICE_AND_UNIT_DOUBLE);
            this.delete = new DeleteButton();
            this.delete.addButtonListener((source, x, y) -> this.model.getNode().getParent().removeChild(this.model.getNode(), 0L));
            this.adaptor = new NodeListenerAdaptor(){

                public void valueChanged(Node<?> node) {
                    TableRowImpl.this.reloadBatches();
                }
            };
            this.store.getPositionNode().addNodeListener((NodeListener)this.adaptor);
            this.article.addSearchTextFieldListener((source, n) -> this.reloadBatches());
            this.charge.addItemListener(e -> this.selectBatch(e));
            this.setLayout(new Layout());
            this.add(this.article);
            this.add(this.store);
            this.add(this.charge);
            this.add(this.stock);
            this.add(this.quantity);
            this.add(this.delete);
            this.reloadBatches();
        }

        private void selectBatch(ItemEvent e) {
            Node node;
            ArticleChargeBatchComplete batch;
            if (e.getStateChange() == 1 && (batch = (ArticleChargeBatchComplete)(node = this.charge.getNode()).getValue()) != null) {
                this.model.getNode().getChildNamed(ArticleChargePart2Complete_.charge).setValue((Object)batch.getCharge(), 0L);
                this.stock.setNode(INodeCreator.getDefaultImpl().getNode4DTO((Object)batch.getQuantity(), false, false));
            }
        }

        private void reloadBatches() {
            final BasicArticleLight article = (BasicArticleLight)this.model.getNode().getChildNamed(ArticleChargePart2Complete_.article).getValue();
            final StorePositionLight position = (StorePositionLight)this.model.getNode().getChildNamed(ArticleChargePart2Complete_.storePosition).getValue();
            ThreadSafeExecutable run = new ThreadSafeExecutable(){

                @Override
                public Node<?> loadData() throws Exception {
                    ListWrapper batches = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getBatches(new BasicArticleReference(article.getId()), position);
                    return INodeCreator.getDefaultImpl().createNodes(batches.getList(), false);
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            TableRowImpl.this.charge.refreshPossibleValues(node);
                        }

                        public void errorOccurred(ClientException exception) {
                            InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)ArticleChargePart2ChargeBasedTable.this);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            boolean booked = Boolean.TRUE.equals(this.model.getNode().getChildNamed(ArticleChargePart2Complete_.booked).getValue());
            this.article.setEnabled(isEnabled && !booked);
            this.store.setEnabled(isEnabled && !booked);
            this.charge.setEnabled(isEnabled && !booked);
            this.stock.setEnabled(isEnabled && !booked);
            this.quantity.setEnabled(isEnabled && !booked);
            this.delete.setEnabled(isEnabled && !booked);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.store.getPositionNode().removeNodeListener((NodeListener)this.adaptor);
            this.article.kill();
            this.article = null;
            this.store.kill();
            this.store = null;
            this.charge.kill();
            this.charge = null;
            this.stock.kill();
            this.stock = null;
            this.quantity.kill();
            this.quantity = null;
            this.delete.kill();
            this.delete = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.article);
            CheckedListAdder.addToList(focusList, this.store);
            CheckedListAdder.addToList(focusList, this.charge);
            CheckedListAdder.addToList(focusList, this.quantity);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.article.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.article.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.article.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.article.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.store.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.store.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.store.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.store.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.charge.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.charge.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.charge.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.charge.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.stock.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.stock.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.stock.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.stock.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.quantity.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.quantity.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.quantity.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.quantity.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.delete.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
            }
        }
    }
}

