/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.tables;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.InvoiceCustomerNumberConverter;
import ch.icit.pegasus.client.converter.InvoiceNumberConverter;
import ch.icit.pegasus.client.converter.InvoiceStateEConverter;
import ch.icit.pegasus.client.converter.UserConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.buttons.ViewButton;
import ch.icit.pegasus.client.gui.utils.print.PrintPopupToolkit;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.invoice.InvoiceServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight_;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class InvoiceListViewTable
extends Table2 {
    private static final long serialVersionUID = 1L;
    private final boolean useCustomerInvoiceNumber;

    public InvoiceListViewTable(boolean useCustomerInvoiceNumber) {
        super(false, "", false, false, "");
        this.useCustomerInvoiceNumber = useCustomerInvoiceNumber;
        this.setSortDirection(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, null, null, null, "", TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth));
        columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", TableColumnInfo.state5, TableColumnInfo.state5, TableColumnInfo.state5));
        columns.add(new TableColumnInfo(Words.CREATION_DATE, null, null, null, "", TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        columns.add(new TableColumnInfo(Words.SENT, null, null, null, "", TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith, TableColumnInfo.checkColumnWith));
        columns.add(new TableColumnInfo(Words.USER_SENT_INVOICE, null, null, null, "", 40, 40, 40));
        columns.add(new TableColumnInfo(Words.INVOICE_SENT_DATE, null, null, null, "", TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
        int tw = 2 * this.getCellPadding() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.MEDIUM);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(0.1);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.8);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.1);
        ((TableColumnInfo)columns.get(6)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel number;
        private TextLabel state;
        private CheckBox sent;
        private TextLabel sentUser;
        private TextLabel sentDate;
        private TextLabel creationDate;
        private ViewButton viewButton;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.number = InvoiceListViewTable.this.useCustomerInvoiceNumber ? new TextLabel(m.getNode(), ConverterRegistry.getConverter(InvoiceCustomerNumberConverter.class)) : new TextLabel(m.getNode(), ConverterRegistry.getConverter(InvoiceNumberConverter.class));
            this.state = new TextLabel(m.getNode().getChildNamed(InvoiceLight_.state), ConverterRegistry.getConverter(InvoiceStateEConverter.class));
            this.sent = new CheckBox((Node<Boolean>)m.getNode().getChildNamed(InvoiceLight_.invoiceSentToCustomer));
            this.sentUser = new TextLabel(m.getNode().getChildNamed(InvoiceLight_.invoiceSentUser), ConverterRegistry.getConverter(UserConverter.class));
            this.sentDate = new TextLabel(m.getNode().getChildNamed(InvoiceLight_.invoiceSentTimestamp), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.creationDate = new TextLabel(m.getNode().getChildNamed(InvoiceLight_.invoiceCreationDate), ConverterRegistry.getConverter(DateTimeConverter.class));
            this.viewButton = new ViewButton();
            this.viewButton.addButtonListener(this);
            this.setLayout(new Layout());
            this.add(this.sentUser);
            this.add(this.sentDate);
            this.add(this.viewButton);
            this.add(this.number);
            this.add(this.state);
            this.add(this.sent);
            this.add(this.creationDate);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.sent.setEnabled(false);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.viewButton) {
                InvoiceListViewTable.this.showLoadingAnimation(Words.OPEN_SHEET);
                ThreadSafeExecutable run = new ThreadSafeExecutable(){

                    @Override
                    public Node<?> loadData() throws Exception {
                        InvoiceLight currentInvoice = (InvoiceLight)TableRowImpl.this.model.getNode().getValue();
                        PegasusFileComplete latestReport = (PegasusFileComplete)((InvoiceServiceManager)ServiceManagerRegistry.getService(InvoiceServiceManager.class)).getLatestReport(new InvoiceReference(currentInvoice.getId())).getValue();
                        if (latestReport != null) {
                            File f = FileTransferUtil.download((PegasusFileComplete)latestReport, (FileTransferListener[])new FileTransferListener[0]);
                            PrintPopupToolkit.previewFile(f);
                        }
                        return null;
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return new RemoteLoader(){

                            public void remoteObjectLoaded(Node<?> node) {
                                InvoiceListViewTable.this.hideLoadingAnimation();
                            }

                            public void errorOccurred(ClientException exception) {
                                InvoiceListViewTable.this.hideLoadingAnimation();
                            }
                        };
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            }
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.viewButton = null;
            this.sentDate.kill();
            this.sentDate = null;
            this.sentUser.kill();
            this.sentUser = null;
            this.number.kill();
            this.state.kill();
            this.sent.kill();
            this.creationDate.kill();
            this.number = null;
            this.state = null;
            this.sent = null;
            this.creationDate = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.viewButton);
            return a;
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.model.getNode().getChildNamed(InvoiceLight_.number).getValue();
                }
                case 1: {
                    return this.model.getNode().getChildNamed(InvoiceLight_.state).getValue();
                }
                case 3: {
                    return this.model.getNode().getChildNamed(InvoiceLight_.invoiceSentToCustomer).getValue();
                }
                case 2: {
                    return this.model.getNode().getChildNamed(InvoiceLight_.creationDate).getValue();
                }
                case 4: {
                    return this.model.getNode().getChildNamed(InvoiceLight_.invoiceSentUser).getValue();
                }
                case 5: {
                    return this.model.getNode().getChildNamed(InvoiceLight_.invoiceSentTimestamp).getValue();
                }
            }
            return null;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.number.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.number.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.number.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.number.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.state.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.state.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.state.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.state.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.creationDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.creationDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.creationDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.creationDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.sent.setLocation(currentX + TableRowImpl.this.getCellPadding() / 2, (int)(((double)parent.getHeight() - TableRowImpl.this.sent.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.sent.setSize(TableRowImpl.this.sent.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.sentUser.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.sentUser.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.sentUser.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.sentUser.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.sentDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.sentDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.sentDate.setSize(TableRowImpl.this.sentDate.getPreferredSize());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(6);
                TableRowImpl.this.viewButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.viewButton.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.viewButton.setSize(TableRowImpl.this.viewButton.getPreferredSize());
            }
        }
    }
}

