/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.textfield;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.converter.Converter2;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.DayTimeConverter;
import ch.icit.pegasus.client.converter.HourMinuteSecondConverter;
import ch.icit.pegasus.client.converter.InternationalizedConverter;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.SelectionManager;
import ch.icit.pegasus.client.gui.utils.Stringable;
import ch.icit.pegasus.client.gui.utils.TextFieldListener;
import ch.icit.pegasus.client.gui.utils.Validatable;
import ch.icit.pegasus.client.gui.utils.animators.Movable;
import ch.icit.pegasus.client.gui.utils.animators.Mover;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.filterchain.UIStateLoadable;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.skins.Skin3Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.gui.utils.textfield.NumberDocument;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.validator.ValidationChangedListener;
import ch.icit.pegasus.client.validator.Validator;
import ch.icit.pegasus.server.core.services.exception.ClientRemoteException;
import ch.icit.pegasus.server.core.services.exception.ServiceExceptionMessages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFormattedTextField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public abstract class AbstractTextField
extends JPanelFadable
implements LafListener,
FocusListener,
MouseListener,
NodeListener,
DocumentListener,
Movable,
Focusable,
Validatable,
Stringable,
UIStateLoadable,
Nodable {
    private static final long serialVersionUID = 1L;
    protected JTextField textField;
    private Skin3Field skin;
    private Focusable nextFocusComponent;
    private ActionListener listener;
    private boolean isPersistable = true;
    private boolean isPaintTexture = true;
    private boolean validateAfterTypeing;
    private Color defaultForeground;
    private Validator validator;
    private List<ValidationChangedListener> validationListener = new ArrayList<ValidationChangedListener>();
    private Button.ButtonState state = Button.ButtonState.UP;
    boolean useMaxDecimals;
    int maxKommastellen = 2;
    protected DecimalFormat format;
    private static int dayTimeMinWidth = -1;
    private static int minWidth = 75;
    private List<String> selectionList = new ArrayList<String>();
    private List<TextFieldListener> listeners = new ArrayList<TextFieldListener>();
    private Mover<AbstractTextField> mover;
    protected Converter2 converter;
    private Selectable selectionDelegate;
    private String defaultText = "";
    TextFieldType type;
    private boolean isInit = false;
    private Node node;
    private Object userObject;
    private Button.ButtonState newState = null;
    private VisibleContainer visibleContainer;
    private boolean isDown;
    private String hasChanges;
    private boolean commitOnFocusLost;
    private boolean hasRejectedChanges = false;
    private int maxChar = 255;
    protected List<TextFieldType> validTypes;

    protected AbstractTextField(Node node) {
        this(node, TextFieldType.NORMAL);
    }

    protected AbstractTextField(TextFieldType type) {
        this(null, type);
    }

    protected AbstractTextField(Node node, TextFieldType type) {
        this.type = type;
        if (TextFieldType.DATE.equals((Object)type)) {
            this.converter = new DateConverter();
            this.install();
        } else if (TextFieldType.DAYTIME.equals((Object)type)) {
            this.converter = new DayTimeConverter();
            this.install();
        } else if (TextFieldType.HOUR_MINUTE_SECOND_TIME.equals((Object)type)) {
            this.converter = new HourMinuteSecondConverter();
            this.install();
        } else {
            this.install();
        }
        this.validTypes = new ArrayList<TextFieldType>();
        this.getValidTypes();
        this.setNode(node);
    }

    protected AbstractTextField() {
        this(TextFieldType.NORMAL);
    }

    public void setNextFocusComponent(Focusable com) {
        this.nextFocusComponent = com;
    }

    public void setDecimalFormat(DecimalFormat f) {
        this.format = f;
    }

    public void setValidateAfterTypeing() {
        this.validateAfterTypeing = true;
    }

    public void setTextSelected() {
        this.textField.setSelectionStart(0);
        this.textField.setSelectionEnd(this.textField.getText().length());
    }

    public void install() {
        this.mover = new Mover<AbstractTextField>(this);
        this.getFader().setDisableWhenHidden(true);
        this.installLocal();
        this.skin = (Skin3Field)DefaultSkins.TextFieldTexture.createDynamicSkin();
        this.setOpaque(false);
        this.addMouseListener(this);
        this.textField.addMouseListener(this);
        this.addFocusListener(this);
        this.textField.addFocusListener(this);
        this.textField.getDocument().removeDocumentListener(this);
        this.textField.getDocument().addDocumentListener(this);
        this.textField.setOpaque(false);
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.setLayout(null);
        this.add(this.textField);
        this.lafAttributeChanged("All attribues changed");
    }

    protected abstract void installLocal();

    public void setSelectionDelegate(Selectable select) {
        this.selectionDelegate = select;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public void disableInnerMouseEvents(boolean isActiv) {
        this.removeMouseListener(this);
        this.textField.removeMouseListener(this);
    }

    public int getSkinBorders() {
        this.ensureSkin();
        return (this.skin.getImageLeft(this.state).getWidth() + 2) * 2;
    }

    public TextFieldType getType() {
        return this.type;
    }

    public void setType(TextFieldType type) throws ClientRemoteException {
        if (this.validTypes.contains((Object)type)) {
            this.type = type;
            if (this.textField != null && this.textField.getDocument() instanceof NumberDocument) {
                NumberDocument d = (NumberDocument)this.textField.getDocument();
                d.setType(type);
            }
        } else {
            throw new ClientRemoteException("Cannot change type of field from " + this.type.toString() + " to " + type.toString() + " because the AbstractTextField implementation " + this.getClass().getName() + " does not support this type", ServiceExceptionMessages.TODO_0000, new String[0]);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.textField != null) {
            this.textField.setEnabled(isEnabled);
        }
        if (isEnabled) {
            this.setState(Button.ButtonState.UP);
        } else {
            this.setState(Button.ButtonState.DISABLED);
        }
    }

    private static void ensureMinWidth(Component c) {
        if (dayTimeMinWidth == -1) {
            String t = AttributeLoader.getAttributeLoader().getAttribute("daytimechooser_min_text");
            Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_textfield_font_size"), LafLoader.getLafLoader().getAttribute("default_textfield_font_type"));
            Skin3Field skin = (Skin3Field)DefaultSkins.TextFieldTexture.createDynamicSkin();
            int image = skin.getImageLeft(Button.ButtonState.UP).getWidth() + skin.getImageRight(Button.ButtonState.UP).getWidth();
            int alphanuerics = c.getFontMetrics(f).stringWidth(t);
            dayTimeMinWidth = alphanuerics + image + 3;
        }
    }

    public static int getPreferredWidth(Component c, TextFieldType type) {
        AbstractTextField.ensureMinWidth(c);
        if (TextFieldType.DAYTIME.equals((Object)type)) {
            Skin3Field skin = (Skin3Field)DefaultSkins.TextFieldTexture.createDynamicSkin();
            int image = skin.getImageLeft(Button.ButtonState.UP).getWidth() + skin.getImageRight(Button.ButtonState.UP).getWidth();
            return dayTimeMinWidth - (image + 3);
        }
        return minWidth;
    }

    public void setPaintTexture(boolean isPaintTexture) {
        this.isPaintTexture = isPaintTexture;
    }

    public void setUserObject(Object node) {
        this.userObject = node;
    }

    public Node getNode() {
        return this.node;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        this.textField.getDocument().removeDocumentListener(this);
        for (ActionListener actionListener : this.textField.getActionListeners()) {
            this.textField.removeActionListener(actionListener);
        }
        for (EventListener eventListener : this.textField.getMouseListeners()) {
            this.textField.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.textField.getMouseMotionListeners()) {
            this.textField.removeMouseMotionListener((MouseMotionListener)eventListener);
        }
        for (EventListener eventListener : this.textField.getFocusListeners()) {
            this.textField.removeFocusListener((FocusListener)eventListener);
        }
        super.kill();
        this.remove(this.textField);
        this.textField = null;
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
            this.node = null;
        }
        this.validator = null;
        this.validationListener.clear();
        this.validationListener = null;
        this.skin = null;
        this.selectionList.clear();
        this.selectionList = null;
        this.listeners.clear();
        this.listeners = null;
        this.converter = null;
        this.userObject = null;
        this.mover.deregister();
        this.mover = null;
    }

    public void setDefaultText(String t) {
        this.defaultText = t;
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        if (this.isPaintTexture) {
            this.ensureSkin();
            this.skin.paint(g2, 0, 0, this.getWidth(), this.state);
        }
        this.paintChildren(g2);
    }

    public void setEditable(boolean isEditable) {
        this.textField.setEditable(isEditable);
    }

    public boolean isEditable() {
        return this.textField.isEditable();
    }

    public void setFontColorToDisabled() {
        this.textField.setForeground(this.textField.getDisabledTextColor());
    }

    @Override
    public Dimension getPreferredSize() {
        AbstractTextField.ensureMinWidth(this);
        this.ensureSkin();
        if (TextFieldType.DAYTIME.equals((Object)this.type)) {
            return new Dimension(dayTimeMinWidth, this.skin.getImageLeft(this.state).getHeight());
        }
        return new Dimension(minWidth, this.skin.getImageLeft(this.state).getHeight());
    }

    private void ensureSkin() {
        if (this.skin == null) {
            this.skin = (Skin3Field)DefaultSkins.TextFieldTexture.createDynamicSkin();
        }
    }

    @Override
    public void setSize(int w, int h) {
        this.ensureSkin();
        if (this.textField != null) {
            this.textField.setLocation(this.skin.getImageLeft(this.state).getWidth() + 2, 3);
            this.textField.setSize(w - (this.skin.getImageLeft(this.state).getWidth() + this.skin.getImageRight(this.state).getWidth() + 2), this.skin.getImageMiddle(this.state).getHeight() - 6);
        }
        super.setSize(w, this.skin.getImageLeft(this.state).getHeight());
    }

    @Override
    public void setForeground(Color fg) {
        if (this.textField != null) {
            this.textField.setForeground(fg);
        }
    }

    public void setText(String text) {
        if (this.textField != null) {
            this.textField.setText(text);
            if (this.textField instanceof JFormattedTextField) {
                try {
                    ((JFormattedTextField)this.textField).commitEdit();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            this.textField.setCaretPosition(0);
        }
    }

    public String getText() {
        if (this.textField != null) {
            return this.textField.getText();
        }
        return "";
    }

    @Override
    public String toString() {
        return this.getText();
    }

    public void setNode(Node n) {
        this.isInit = true;
        if (this.node != null) {
            this.node.removeNodeListener((NodeListener)this);
        }
        this.node = n;
        if (this.node != null) {
            this.node.addNodeListener((NodeListener)this);
            this.valueChanged(n);
        }
        this.isInit = false;
    }

    @Override
    public void setFont(Font font) {
        if (this.textField != null) {
            this.textField.setFont(font);
        }
    }

    public void setCaretColor(Color cc) {
        this.textField.setCaretColor(cc);
    }

    public void setSelectedTextColor(Color c) {
        this.textField.setSelectedTextColor(c);
    }

    public void setSelectionColor(Color c) {
        this.textField.setSelectionColor(c);
    }

    public void setSelectionStart(int selectionStart) {
        this.textField.setSelectionStart(selectionStart);
    }

    public void setSelectionEnd(int selectionEnd) {
        this.textField.setSelectionEnd(selectionEnd);
    }

    public void addTextFieldListener(TextFieldListener l) {
        this.listeners.add(l);
    }

    public void removeTextFieldListener(TextFieldListener l) {
        this.listeners.remove(l);
    }

    public void addValidationStateChangedListener(ValidationChangedListener l) {
        this.validationListener.add(l);
    }

    public void removeValidationStateChangedListener(ValidationChangedListener l) {
        this.validationListener.remove(l);
    }

    public void addActionListener(ActionListener l) {
        this.textField.addActionListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.textField.removeActionListener(l);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.textField.getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.textField.getDocument().removeDocumentListener(listener);
    }

    public void fireTextFieldEvent() {
        if (this.commitOnFocusLost && !this.textField.hasFocus()) {
            for (TextFieldListener l : this.listeners) {
                l.valueChanged(this);
            }
        } else if (!this.commitOnFocusLost) {
            for (TextFieldListener l : this.listeners) {
                l.valueChanged(this);
            }
        } else {
            this.hasRejectedChanges = true;
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.state != Button.ButtonState.DISABLED && this.state != Button.ButtonState.ERROR) {
            this.hasChanges = this.textField.getText();
            SelectionManager.getSelectionManager().focusGained(this);
            this.setState(Button.ButtonState.FOCUS);
            this.afterFocusGained();
            if (this.nextFocusComponent != null) {
                if (this.listener == null) {
                    this.listener = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            AbstractTextField.this.nextFocusComponent.requestFocusInWindowNow();
                        }
                    };
                }
                this.textField.addActionListener(this.listener);
            }
        }
    }

    protected abstract void afterFocusGained();

    public void setAutoCompletionSelectionList(ArrayList list) {
        this.selectionList = list;
    }

    public void fireInjected() {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.state != Button.ButtonState.DISABLED) {
            if (!this.isFieldValid()) {
                this.setInvalid();
            } else if (this.converter == null || this.converter.validateInput((Object)this.textField.getText())) {
                this.setState(Button.ButtonState.UP);
                if (this.hasChanges != null && this.textField != null && !this.hasChanges.equals(this.textField.getText()) && this.node != null) {
                    this.fireInjected();
                }
            } else {
                this.setInvalid();
            }
            if (this.listener != null) {
                if (this.textField != null) {
                    this.textField.removeActionListener(this.listener);
                }
                this.listener = null;
            }
            if (this.commitOnFocusLost) {
                this.textValueChanged(null);
            }
        }
    }

    public void setCommitOnFocusLost(boolean commitOnFocusLost) {
        this.commitOnFocusLost = commitOnFocusLost;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public Button.ButtonState getState() {
        return this.state;
    }

    public void setState(Button.ButtonState state) {
        this.state = state;
        this.repaint(32L);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.state != Button.ButtonState.DISABLED && (Button.pressedItem == null || Button.pressedItem == this)) {
            if (this.state != Button.ButtonState.FOCUS) {
                if (this.state == Button.ButtonState.ERROR) {
                    this.newState = Button.ButtonState.OVER;
                } else {
                    this.state = Button.ButtonState.OVER;
                }
                this.setCursor(new Cursor(2));
                this.repaint(32L);
            } else {
                this.setCursor(new Cursor(2));
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.state != Button.ButtonState.DISABLED) {
            if (this.state != Button.ButtonState.FOCUS) {
                if (this.state == Button.ButtonState.ERROR) {
                    this.newState = Button.ButtonState.UP;
                } else {
                    this.state = Button.ButtonState.UP;
                }
                this.setCursor(new Cursor(0));
                this.repaint(23L);
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.state != Button.ButtonState.DISABLED) {
            Button.pressedItem = this;
            this.isDown = true;
            if (e.getSource() == this) {
                this.textField.requestFocusInWindow();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this.state != Button.ButtonState.DISABLED) {
            this.isDown = false;
            Button.pressedItem = null;
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_textfield_font_size"), LafLoader.getLafLoader().getAttribute("default_textfield_font_type")));
        this.defaultForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_textfield_foreground"));
        Color disabledForeground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_disabled_color"));
        this.setForeground(this.defaultForeground);
        this.textField.setDisabledTextColor(disabledForeground);
        this.setCaretColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_textfield_caret_color")));
        this.setSelectedTextColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_textfield_selected_text_color")));
        this.setSelectionColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_textfield_selection_color")));
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void textValueChanged(DocumentEvent e2) {
        boolean silentForAll;
        if (this.validateAfterTypeing && !this.getText().equals("")) {
            this.setValid();
        }
        boolean bl = silentForAll = this.commitOnFocusLost && this.textField.hasFocus();
        if (this.node != null && !silentForAll) {
            if (this.converter != null && !this.converter.validateInput((Object)this.getText())) {
                this.setState(Button.ButtonState.ERROR);
                return;
            }
            this.type.textChanged(this.node, this, silentForAll);
            this.node.commit();
        }
        this.ensureValidatorState();
        if (!this.isKilled()) {
            this.fireTextFieldEvent();
        }
    }

    public void ensureValidatorState() {
        if (this.validator != null) {
            if (this.validator.isValid(this.textField.getText(), this).isValid()) {
                this.fireValidationStateChanged(3);
                if (this.newState != null) {
                    this.setState(this.newState);
                } else {
                    this.setState(Button.ButtonState.UP);
                }
                this.newState = null;
            } else {
                this.fireValidationStateChanged(5);
                this.newState = null;
                this.setState(Button.ButtonState.ERROR);
            }
        }
    }

    protected void switchState(boolean ready) {
        if (ready) {
            this.fireValidationStateChanged(3);
            if (this.newState != null) {
                this.setState(this.newState);
            } else if (this.textField.hasFocus()) {
                this.setState(Button.ButtonState.FOCUS);
            } else {
                this.setState(Button.ButtonState.UP);
            }
            this.newState = null;
        } else {
            this.fireValidationStateChanged(5);
            this.newState = null;
            this.setState(Button.ButtonState.ERROR);
        }
    }

    private void fireValidationStateChanged(int state) {
        for (ValidationChangedListener l : this.validationListener) {
            l.validationChanged(state);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textValueChanged(e);
    }

    @Override
    public void setLocationSmooth(int endX, int endY) {
        this.mover.setLocationSmooth(endX, endY);
    }

    public Mover<AbstractTextField> getMover() {
        return this.mover;
    }

    private void valueOfNodeChanged(Node node) {
        this.type.nodeChanged(node, this);
    }

    public void valueChanged(Node<?> node) {
        if (this.textField != null && this.textField.getDocument() != null) {
            this.textField.getDocument().removeDocumentListener(this);
            this.valueOfNodeChanged(node);
            if (this.textField != null) {
                this.textField.getDocument().addDocumentListener(this);
            }
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        a.add(this.textField);
        return a;
    }

    @Override
    public void setInvalid() {
        this.setState(Button.ButtonState.ERROR);
    }

    public boolean isFieldValid() {
        return true;
    }

    @Override
    public void setValid() {
        if (this.state == Button.ButtonState.ERROR) {
            if (this.textField.hasFocus()) {
                this.setState(Button.ButtonState.FOCUS);
            } else {
                this.setState(Button.ButtonState.UP);
            }
        }
    }

    @Override
    public void setWarning() {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.visibleContainer = pane;
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return this.selectionDelegate;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.textField.requestFocusInWindow();
    }

    @Override
    public String getStringValue() {
        return this.textField.getText();
    }

    public void setTextSilent(String string) {
        this.textField.getDocument().removeDocumentListener(this);
        this.textField.setText(string);
        this.textField.setCaretPosition(0);
        this.textField.getDocument().addDocumentListener(this);
    }

    @Override
    public String getPersistString() {
        return this.getStringValue();
    }

    @Override
    public void loadState(String state, String id) {
        this.setText(state);
    }

    @Override
    public String getID() {
        return "0";
    }

    @Override
    public boolean shouldPersist() {
        return this.isPersistable;
    }

    @Override
    public void setShouldPersist(boolean isPersisting) {
        this.isPersistable = isPersisting;
    }

    public boolean isSwingOnly() {
        return true;
    }

    protected abstract List<TextFieldType> getValidTypes();

    @Override
    public void setPermanent(boolean isPermantent) {
    }

    public int getMaxChar() {
        return this.maxChar;
    }

    public void setMaxChar(int maxChar) {
        this.maxChar = maxChar;
    }

    protected class FormattedDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        protected FormattedDocument() {
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (AbstractTextField.this.converter instanceof InternationalizedConverter) {
                if (((InternationalizedConverter)AbstractTextField.this.converter).getValidInputs() != null && (((InternationalizedConverter)AbstractTextField.this.converter).getValidInputs().contains(text) || text.length() > 1)) {
                    super.replace(offset, length, text, attrs);
                }
            } else {
                super.replace(offset, length, text, attrs);
            }
        }
    }

    protected class MaxCharDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        protected MaxCharDocument() {
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            int t = 0;
            if (text != null && AbstractTextField.this.getText() != null) {
                t = text.length() + AbstractTextField.this.getText().length();
            }
            if (t > AbstractTextField.this.maxChar) {
                return;
            }
            super.replace(offset, length, text, attrs);
        }
    }
}

