/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util;

import ch.icit.pegasus.client.util.FlexListListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FlexList<T>
implements List<T> {
    private List<T> l = new ArrayList<T>();
    private List<FlexListListener> listener = new ArrayList<FlexListListener>();

    public void addFlexListener(FlexListListener l) {
        this.listener.add(l);
    }

    public void removeFlexListener(FlexListListener l) {
        this.listener.remove(l);
    }

    @Override
    public int size() {
        return this.l.size();
    }

    @Override
    public boolean isEmpty() {
        return this.l.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.l.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.l.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.l.toArray();
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.l.toArray(a);
    }

    @Override
    public boolean add(T e) {
        boolean b = this.l.add(e);
        if (b) {
            this.fireAddEvent(e);
        }
        return b;
    }

    private void fireAddEvent(Object e) {
        for (FlexListListener ll : this.listener) {
            ll.elementAdded(e);
        }
    }

    @Override
    public boolean remove(Object o) {
        boolean b = this.l.remove(o);
        if (b) {
            this.fireRemoveEvent(o);
        }
        return false;
    }

    private void fireRemoveEvent(Object o) {
        for (FlexListListener ll : this.listener) {
            ll.elementRemoved(o);
        }
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.l.containsAll(c);
    }

    @Override
    public boolean addAll(Collection c) {
        boolean b = this.l.addAll(c);
        if (b) {
            this.fireAddEvent(c);
        }
        return b;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        boolean b = this.l.addAll(index, c);
        if (b) {
            this.fireAddEvent(c);
        }
        return b;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean b = this.l.removeAll(c);
        if (b) {
            this.fireRemoveEvent(c);
        }
        return b;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean b = this.l.retainAll(c);
        if (b) {
            this.fireRemoveEvent(c);
        }
        return b;
    }

    @Override
    public void clear() {
        this.l.clear();
    }

    @Override
    public T get(int index) {
        return this.l.get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.l.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        this.l.add(index, element);
        this.fireAddEvent(element);
    }

    @Override
    public T remove(int index) {
        T o = this.l.remove(index);
        this.fireRemoveEvent(o);
        return o;
    }

    @Override
    public int indexOf(Object o) {
        return this.l.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.l.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.l.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return this.l.listIterator(index);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.l.subList(fromIndex, toIndex);
    }
}

