/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.gui.modules.articlepricecontract.details.utils.NodeStepPriceSorter;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationList;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientExceptionCollection;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractComplete_;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractEntryComplete;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractEntryComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierLight;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.utils.ExcelRow;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ArticlePriceContractToolkit {
    private static final String VERSION_STRING_PREFIX = Words.ARTICLE_CONTRACT_VERSION_PREFIX;

    public static List<ScreenValidationObject> updateArticleSupplierPrices(Node<ArticlePriceContractComplete> node) throws ClientServerCallException {
        Iterator it = node.getChildNamed(ArticlePriceContractComplete_.articles).getChilds();
        ArrayList<ScreenValidationObject> rets = new ArrayList<ScreenValidationObject>();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(ArticlePriceContractEntryComplete_.article).getValue(BasicArticleComplete.class) != null) continue;
            BasicArticleComplete art = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)n.getChildNamed(ArticlePriceContractEntryComplete_.article).getValue()).getValue();
            n.getChildNamed(ArticlePriceContractEntryComplete_.article).removeExistingValues();
            n.getChildNamed(ArticlePriceContractEntryComplete_.article).setValue((Object)art, System.currentTimeMillis());
            n.getChildNamed(ArticlePriceContractEntryComplete_.article).updateNode();
        }
        return rets;
    }

    public static List<ScreenValidationObject> importData(List<ExcelRow> r, Node<ArticlePriceContractComplete> node, SupplierLight supplier) throws ClientExceptionCollection {
        ScreenValidationList rets = new ScreenValidationList();
        try {
            Map<String, Node<ArticlePriceContractEntryComplete>> entryIndex = ArticlePriceContractToolkit.getEntryIndex(node);
            int start = ArticlePriceContractToolkit.getStartRowIndex(r);
            ExcelRow tw = r.get(start);
            if (tw.getCells().get(0).toString().startsWith(VERSION_STRING_PREFIX)) {
                String version = tw.getCells().get(0).toString().substring(VERSION_STRING_PREFIX.length());
                if (version.equals("1.0")) {
                    for (int i = start + 2; i < r.size(); ++i) {
                        tw = r.get(i);
                        String tt = ArticlePriceContractToolkit.writeImportedPriceToArticleContract(node, tw, entryIndex, supplier);
                        if (tt == null) continue;
                        rets.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, tt));
                    }
                    for (Node<ArticlePriceContractEntryComplete> e : entryIndex.values()) {
                        if (e.getChildNamed(new String[]{"importedYet"}) != null) continue;
                        ArticlePriceContractEntryComplete ee = (ArticlePriceContractEntryComplete)e.getValue();
                        String scale = "";
                        scale = scale + ee.getMinScale() + " " + ee.getScaleUnit().getShortName() + " - ";
                        scale = ee.getMaxScale() == 0 ? scale + "\u221e" : scale + ee.getMaxScale();
                        scale = scale + " " + ee.getScaleUnit().getShortName();
                        rets.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, ee.getArticle().getNumber() + " - " + ee.getArticle().getName() + " (" + scale + ") " + Words.ARTICLE_CONTRACT_NOT_UPDATED));
                    }
                } else {
                    rets.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ARTICLE_CONTRACT_INVALID_VERSION_PREFIX + " " + version + " " + Words.ARTICLE_CONTRACT_INVALID_VERSION_POSTFIX));
                }
            } else {
                rets.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ARTICLE_CONTRACT_INVALID_EXPORT_PREFIX + " " + tw.getCells().get(0).toString() + " " + Words.ARTICLE_CONTRACT_INVALID_EXPORT_POSTFIX + " " + VERSION_STRING_PREFIX + " 1.0)"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            rets.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ARTICLE_CONTRACT_INVALID));
        }
        return rets;
    }

    private static Map<String, Node<ArticlePriceContractEntryComplete>> getEntryIndex(Node<ArticlePriceContractComplete> node) throws ClientServerCallException {
        Hashtable<String, Node<ArticlePriceContractEntryComplete>> map = new Hashtable<String, Node<ArticlePriceContractEntryComplete>>();
        Iterator it = node.getChildNamed(ArticlePriceContractComplete_.articles).getChilds();
        while (it.hasNext()) {
            BasicArticleComplete art;
            Node n = (Node)it.next();
            if (n.getChildNamed(ArticlePriceContractEntryComplete_.article).getValue(BasicArticleComplete.class) == null) {
                art = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)n.getChildNamed(ArticlePriceContractEntryComplete_.article).getValue()).getValue();
                n.getChildNamed(ArticlePriceContractEntryComplete_.article).removeExistingValues();
                n.getChildNamed(ArticlePriceContractEntryComplete_.article).setValue((Object)art, System.currentTimeMillis());
            }
            art = (BasicArticleComplete)n.getChildNamed(ArticlePriceContractEntryComplete_.article).getValue(BasicArticleComplete.class);
            Integer i = ((ArticlePriceContractEntryComplete)n.getValue()).getMinScale();
            map.put("" + i + "_" + art.getNumber() + "_", (Node<ArticlePriceContractEntryComplete>)n);
        }
        return map;
    }

    private static String writeImportedPriceToArticleContract(Node<ArticlePriceContractComplete> contractNode, ExcelRow row, Map<String, Node<ArticlePriceContractEntryComplete>> entryIndex, SupplierLight supplier) throws ClientServerCallException {
        int minScale;
        String bs;
        String bs2;
        if (row.getCellCount() != 9) {
            if (row.getCellCount() > 9) {
                return "Empty column found. Please remove empty columns at the end of table. The Contract uses only 9 columns.";
            }
            return "Empty line found. Please remove empty line at the end of table.";
        }
        int col = 0;
        String supArticleNo = row.getCells().size() == 9 ? row.getCells().get(col).toString().trim() : "";
        int number = -1;
        if (row.getCells().get(++col) instanceof Integer) {
            number = (Integer)row.getCells().get(col);
        } else if (row.getCells().get(col) instanceof Double) {
            number = ((Double)row.getCells().get(col)).intValue();
        } else if (!row.getCells().get(col).toString().isEmpty()) {
            try {
                number = Integer.parseInt(row.getCells().get(col).toString());
            }
            catch (NumberFormatException e) {
                number = Double.valueOf(row.getCells().get(col).toString()).intValue();
            }
        }
        String name = (String)row.getCells().get(++col);
        String scale = (String)row.getCells().get(++col);
        Object priceT = row.getCells().get(++col);
        String currency = (String)row.getCells().get(++col);
        String priceUnit = (String)row.getCells().get(++col);
        ++col;
        if (name.isEmpty() && number == -1) {
            return null;
        }
        priceUnit = priceUnit.substring(1);
        boolean bonded = false;
        if (row.getCells().size() >= col && row.getCellValue(col) != null && row.getCellValue(col) instanceof String && (bs2 = (String)row.getCellValue(col)).equals(Words.YES.toLowerCase())) {
            bonded = true;
        }
        boolean canBeOrdered = false;
        if (row.getCells().size() >= ++col && row.getCellValue(col) != null && row.getCellValue(col) instanceof String && (bs = (String)row.getCellValue(col)).equals(Words.YES.toLowerCase())) {
            canBeOrdered = true;
        }
        Double price = 0.0;
        if (priceT instanceof Double) {
            price = (Double)priceT;
        } else if (priceT instanceof Integer) {
            price = ((Integer)priceT).doubleValue();
        } else if (priceT instanceof String) {
            String pT = (String)priceT;
            pT = pT.replaceAll(",", ".");
            try {
                price = Double.valueOf(pT);
            }
            catch (NumberFormatException e) {
                price = null;
            }
            if (price == null) {
                try {
                    price = Integer.valueOf(pT).doubleValue();
                }
                catch (NumberFormatException e) {
                    price = null;
                }
            }
        }
        if (price == null) {
            return number + " - " + name + Words.UNABLE_TO_READ_PRICE;
        }
        String[] s = scale.split("-");
        s = s[0].trim().split(" ");
        try {
            minScale = Integer.valueOf(s[0].trim());
        }
        catch (NumberFormatException e) {
            minScale = -1;
        }
        Node<ArticlePriceContractEntryComplete> entry = entryIndex.get(minScale + "_" + number + "_");
        if (entry == null) {
            return Words.ARTICLE + " " + number + " - " + name + " " + Words.NOT_IMPORTED + " (no Entry found in Contract)";
        }
        entry.getChildNamed(ArticlePriceContractEntryComplete_.canBeOrdered).setValue((Object)canBeOrdered, 0L);
        entry.getChildNamed(ArticlePriceContractEntryComplete_.bonded).setValue((Object)bonded, 0L);
        Node nn = entry.getChildNamed(new String[]{"importedYet"});
        if (nn == null) {
            nn = new Node();
            nn.setName("importedYet");
            entry.addChild(nn, 0L);
        }
        if (entry.getChildNamed(ArticlePriceContractEntryComplete_.article).getValue(BasicArticleComplete.class) == null) {
            BasicArticleComplete ac = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)entry.getChildNamed(new String[]{"article"}).getValue()).getValue();
            entry.getChildNamed(ArticlePriceContractEntryComplete_.article).removeExistingValues();
            entry.getChildNamed(ArticlePriceContractEntryComplete_.article).setValue((Object)ac, System.currentTimeMillis());
        }
        BasicArticleComplete art = (BasicArticleComplete)entry.getChildNamed(ArticlePriceContractEntryComplete_.article).getValue(BasicArticleComplete.class);
        SupplierConditionComplete scc = ArticleToolkit.getSupplierCondition(art, (SupplierReference)supplier, ((ArticlePriceContractComplete)contractNode.getValue()).getUseTaxZone(), ((ArticlePriceContractComplete)contractNode.getValue()).getTaxZone(), new Timestamp(((ArticlePriceContractComplete)contractNode.getValue()).getContractPeriod().getStartDate().getTime()));
        if (art.getNumber() != number) {
            return art.getNumber() + " - " + art.getName() + Words.CATIT_NO_CHANGED;
        }
        if (!art.getPriceUnit().getShortName().equals(priceUnit)) {
            return art.getNumber() + " - " + art.getName() + Words.PRICE_UNIT_CHANGED;
        }
        if (scc != null && !scc.getSupplier().getPaymentCurrency().getCode().equals(currency)) {
            return art.getNumber() + " - " + art.getName() + Words.CURRENCY_CHANGED;
        }
        if (minScale != -1 && ((ArticlePriceContractEntryComplete)entry.getValue()).getMinScale() == minScale) {
            ((ArticlePriceContractEntryComplete)entry.getValue()).getPrice().setPrice(price);
            return null;
        }
        return art.getNumber() + " - " + art.getName() + Words.ARTICLE_NOT_IN_CONTRACT;
    }

    private static void removeFromContract(Node<BasicArticleLight> entry, Node<ArticlePriceContractComplete> contractNode) {
        Iterator it = contractNode.getChildNamed(new String[]{"overview"}).getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (!((ArticlePriceContractEntryComplete)n.getValue()).getArticle().equals(entry.getValue())) continue;
            contractNode.getChildNamed(new String[]{"overview"}).removeChild(n, 0L);
        }
    }

    private static int getStartRowIndex(List<ExcelRow> rows) {
        int i = 0;
        for (ExcelRow r : rows) {
            if (r.getCells().size() >= 1 && r.getCells().get(0).toString().startsWith(VERSION_STRING_PREFIX)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static List<ExcelRow> createExportList(Node<ArticlePriceContractComplete> contractNode, SupplierLight usedSupplier, SystemSettingsComplete settings) throws ClientServerCallException {
        contractNode.commitThis(ArticlePriceContractComplete.class);
        ArrayList<ExcelRow> rows = new ArrayList<ExcelRow>();
        ArticlePriceContractComplete contract = (ArticlePriceContractComplete)contractNode.getValue(ArticlePriceContractComplete.class);
        if (contract.getIsDayPriceContract().booleanValue()) {
            rows.add(new ExcelRow());
            rows.add(new ExcelRow());
            rows.add(new ExcelRow());
            rows.add(new ExcelRow());
            rows.add(new ExcelRow());
            rows.add(new ExcelRow());
            rows.add(new ExcelRow());
            rows.add(new ExcelRow());
            rows.add(new ExcelRow());
            rows.add(new ExcelRow());
            rows.add(new ExcelRow());
            rows.add(new ExcelRow());
            rows.add(new ExcelRow());
            rows.add(new ExcelRow());
            ((ExcelRow)rows.get(0)).addCell((Object)Words.ARTICLE_CONTRACT_FOR, new String[0]);
            ((ExcelRow)rows.get(2)).addCell((Object)Words.SUPPLIER, new String[0]);
            ((ExcelRow)rows.get(2)).addCell(null, new String[0]);
            ((ExcelRow)rows.get(2)).addCell((Object)Words.CUSTOMER, new String[0]);
            ((ExcelRow)rows.get(3)).addCell((Object)contract.getSupplier().getName(), new String[0]);
            ((ExcelRow)rows.get(3)).addCell(null, new String[0]);
            ((ExcelRow)rows.get(3)).addCell((Object)settings.getCompany().getCompanyName(), new String[0]);
            ((ExcelRow)rows.get(4)).addCell((Object)(contract.getSupplier().getHeadQuarters().getZipCode() + " " + contract.getSupplier().getHeadQuarters().getCity()), new String[0]);
            ((ExcelRow)rows.get(4)).addCell(null, new String[0]);
            ((ExcelRow)rows.get(4)).addCell((Object)(settings.getCompany().getZipCode() + " " + settings.getCompany().getCity()), new String[0]);
            ((ExcelRow)rows.get(6)).addCell((Object)Words.CONTRACT_NUMBER, new String[0]);
            ((ExcelRow)rows.get(6)).addCell(null, new String[0]);
            ((ExcelRow)rows.get(6)).addCell((Object)contract.getNumber(), new String[0]);
            ((ExcelRow)rows.get(7)).addCell((Object)Words.CONTRACT_DATE, new String[0]);
            ((ExcelRow)rows.get(7)).addCell(null, new String[0]);
            ((ExcelRow)rows.get(7)).addCell((Object)contract.getContractPeriod().getStartDate(), new String[0]);
            ((ExcelRow)rows.get(8)).addCell((Object)Words.PERIOD_START, new String[0]);
            ((ExcelRow)rows.get(8)).addCell(null, new String[0]);
            ((ExcelRow)rows.get(8)).addCell((Object)contract.getContractPeriod().getStartDate(), new String[0]);
            ((ExcelRow)rows.get(8)).addCell((Object)"->", new String[0]);
            ((ExcelRow)rows.get(8)).addCell((Object)contract.getContractPeriod().getEndDate(), new String[0]);
            ((ExcelRow)rows.get(9)).addCell((Object)Words.DOCUMENT_ID, new String[0]);
            ((ExcelRow)rows.get(9)).addCell(null, new String[0]);
            ((ExcelRow)rows.get(9)).addCell((Object)contract.getDocumentID(), new String[0]);
            ((ExcelRow)rows.get(11)).addCell((Object)Phrase.getPhrase((String)Phrase.ARTICLE_CONTRACT_DISCLAIMER, (Object[])new Object[]{contract.getDocumentID()}), new String[0]);
            ((ExcelRow)rows.get(13)).addCell((Object)(VERSION_STRING_PREFIX + "1.0"), new String[0]);
        } else {
            rows.add(new ExcelRow(null));
            rows.add(new ExcelRow(null));
            rows.add(new ExcelRow(null));
            ((ExcelRow)rows.get(0)).addCell((Object)Words.ARTICLE_CONTRACT_FOR, new String[0]);
            ((ExcelRow)rows.get(1)).addCell((Object)contract.getContractPeriod().getStartDate(), new String[0]);
            ((ExcelRow)rows.get(1)).addCell((Object)"->", new String[0]);
            ((ExcelRow)rows.get(1)).addCell((Object)contract.getContractPeriod().getEndDate(), new String[0]);
            ((ExcelRow)rows.get(2)).addCell((Object)(VERSION_STRING_PREFIX + "1.0"), new String[0]);
        }
        ExcelRow header = new ExcelRow(true);
        header.addCell((Object)Words.NO_NUMBER, new String[0]);
        header.addCell((Object)Words.CATIT_NO, new String[0]);
        header.addCell((Object)Words.ARTICLE, new String[0]);
        header.addCell((Object)Words.SCALE, new String[0]);
        header.addCell((Object)Words.PRICE, new String[0]);
        header.addCell((Object)"", new String[0]);
        header.addCell((Object)Words.UNIT, new String[0]);
        header.addCell((Object)(Words.BONDED + " " + Words.YES_NO_BRACKETS), new String[0]);
        header.addCell((Object)(Words.CAN_BE_ORDERED + " " + Words.YES_NO_BRACKETS), new String[0]);
        rows.add(header);
        int c0 = ((String)header.getCells().get(0)).length();
        int c1 = ((String)header.getCells().get(1)).length();
        int c2 = ((String)header.getCells().get(2)).length();
        int c3 = ((String)header.getCells().get(3)).length();
        int c4 = ((String)header.getCells().get(4)).length();
        int c5 = ((String)header.getCells().get(5)).length();
        int c6 = ((String)header.getCells().get(6)).length();
        contractNode.getChildNamed(ArticlePriceContractComplete_.articles).sortChilds((Comparator)new NodeStepPriceSorter());
        Iterator it = contractNode.getChildNamed(ArticlePriceContractComplete_.articles).getFailSafeChildIterator();
        while (it.hasNext()) {
            BasicArticleComplete artL;
            SupplierConditionComplete scc;
            Node n = (Node)it.next();
            ExcelRow r = new ExcelRow(null);
            if (n.getChildNamed(ArticlePriceContractEntryComplete_.article).getValue(BasicArticleComplete.class) == null) {
                BasicArticleComplete a = (BasicArticleComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getBasicArticle((BasicArticleReference)n.getChildNamed(new String[]{"article"}).getValue()).getValue();
                n.getChildNamed(ArticlePriceContractEntryComplete_.article).removeExistingValues();
                n.getChildNamed(ArticlePriceContractEntryComplete_.article).setValue((Object)a, System.currentTimeMillis());
            }
            if ((scc = ArticleToolkit.getSupplierConditionForContract(artL = (BasicArticleComplete)n.getChildNamed(ArticlePriceContractEntryComplete_.article).getValue(BasicArticleComplete.class), (SupplierReference)usedSupplier, true, (TaxZoneComplete)n.getChildNamed(ArticlePriceContractEntryComplete_.taxZone).getValue(), new Timestamp(contract.getContractPeriod().getStartDate().getTime()))) == null) continue;
            String artNo = scc.getArticleNumber() == null ? " " : scc.getArticleNumber();
            r.addCell((Object)artNo, new String[0]);
            int temp = artNo.length();
            c0 = c0 < temp ? temp : c0;
            r.addCell((Object)artL.getNumber().toString(), new String[0]);
            temp = artL.getNumber().toString().length();
            c1 = c1 < temp ? temp : c1;
            String artName = artL.getOrderName();
            if (artName == null || artName.equals("")) {
                artName = artL.getName();
            }
            r.addCell((Object)artName, new String[0]);
            temp = artName.length();
            c2 = c2 < temp ? temp : c2;
            String scale = "";
            scale = scale + ((ArticlePriceContractEntryComplete)n.getValue()).getMinScale() + " " + ((ArticlePriceContractEntryComplete)n.getValue()).getScaleUnit().getShortName() + " - ";
            scale = ((ArticlePriceContractEntryComplete)n.getValue()).getMaxScale() == 0 ? scale + "\u221e" : scale + ((ArticlePriceContractEntryComplete)n.getValue()).getMaxScale();
            scale = scale + " " + ((ArticlePriceContractEntryComplete)n.getValue()).getScaleUnit().getShortName();
            r.addCell((Object)scale, new String[0]);
            temp = scale.length();
            c3 = c3 < temp ? temp : c3;
            r.addCell((Object)((ArticlePriceContractEntryComplete)n.getValue()).getPrice().getPrice(), new String[0]);
            temp = ((ArticlePriceContractEntryComplete)n.getValue()).getPrice().getPrice().toString().length();
            c4 = c4 < temp ? temp : c4;
            r.addCell((Object)((ArticlePriceContractEntryComplete)n.getValue()).getPrice().getCurrency().getCode(), new String[0]);
            temp = ((ArticlePriceContractEntryComplete)n.getValue()).getPrice().getCurrency().getCode().length();
            c5 = c5 < temp ? temp : c5;
            r.addCell((Object)("/" + ((ArticlePriceContractEntryComplete)n.getValue()).getPriceUnit().getShortName()), new String[0]);
            temp = ("/" + ((ArticlePriceContractEntryComplete)n.getValue()).getPriceUnit().getShortName()).length();
            int n2 = c6 = c6 < temp ? temp : c6;
            if (Boolean.TRUE.equals(((ArticlePriceContractEntryComplete)n.getValue()).getArticle().getBonded())) {
                r.addCell((Object)Words.YES.toLowerCase(), new String[0]);
            } else {
                r.addCell((Object)Words.NO_ANSWER.toLowerCase(), new String[0]);
            }
            r.addCell((Object)Words.YES.toLowerCase(), new String[0]);
            rows.add(r);
        }
        return rows;
    }
}

