/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.toolkits;

import ch.icit.pegasus.client.converter.FlightConverter;
import ch.icit.pegasus.client.converter.FlightDateConverter;
import ch.icit.pegasus.client.search.SearchResultIterator;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.PaxFigureComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.SpecialMealOrderComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PaxFigureTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.util.TimeUtil;
import ch.icit.utils.ExcelRow;
import ch.icit.utils.StyledWorkbook;
import java.sql.Date;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.usermodel.Sheet;

public class PaxUpdateToolkit {
    public static Date getFlightSearchDate(FlightLight oldFlight, DateDurationComplete timeWindow) {
        Date newDate = new Date(oldFlight.getStd().getTime());
        switch (timeWindow.getUnit()) {
            case DAY: {
                long tw = 86400000L;
                tw = (long)((double)tw * timeWindow.getDuration());
                newDate = new Date(newDate.getTime() - tw);
                break;
            }
            case MONTH: {
                Calendar c = TimeUtil.createCalendar();
                c.setTimeInMillis(newDate.getTime());
                int orgWeekDay = c.get(7);
                c.add(2, -timeWindow.getDuration().intValue());
                int rolledWeekDay = c.get(7);
                int dayShift = orgWeekDay - rolledWeekDay;
                c.add(7, dayShift);
                newDate = new Date(c.getTimeInMillis());
                break;
            }
            case WEEK: {
                long tw = 86400000L;
                tw = (long)((double)tw * (7.0 * timeWindow.getDuration()));
                newDate = new Date(newDate.getTime() - tw);
                break;
            }
            case YEAR: {
                Calendar c = TimeUtil.createCalendar();
                c.setTimeInMillis(newDate.getTime());
                int orgWeekDay = c.get(7);
                c.add(1, -timeWindow.getDuration().intValue());
                int rolledWeekDay = c.get(7);
                int dayShift = orgWeekDay - rolledWeekDay;
                c.add(7, dayShift);
                newDate = new Date(c.getTimeInMillis());
                break;
            }
        }
        return newDate;
    }

    public static FlightLight getUpdateFlight(FlightLight oldFlight, Date newDate, String percentage, boolean useHistoric) {
        if (useHistoric) {
            boolean found;
            FlightLight newFlight;
            SearchResultIterator sri;
            FlightSearchConfiguration fsc = new FlightSearchConfiguration();
            fsc.setOnlyOpenFlights(Boolean.valueOf(true));
            fsc.setCustomer(oldFlight.getCustomer());
            fsc.setFlightNumber(oldFlight.getOutboundCode());
            fsc.setDayPeriod(new PeriodComplete(new Date(newDate.getTime()), new Date(newDate.getTime())));
            try {
                sri = new SearchResultIterator((ASearchConfiguration)fsc);
                newFlight = null;
                found = false;
                while (sri.hasNext() && !found) {
                    newFlight = (FlightLight)sri.next();
                    if (!newFlight.getOutboundCode().equals(oldFlight.getOutboundCode())) continue;
                    return newFlight;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            fsc = new FlightSearchConfiguration();
            fsc.setCustomer(oldFlight.getCustomer());
            fsc.setFlightNumber(oldFlight.getOutboundCode());
            fsc.setDayPeriod(new PeriodComplete(new Date(newDate.getTime()), new Date(newDate.getTime())));
            try {
                sri = new SearchResultIterator((ASearchConfiguration)fsc);
                newFlight = null;
                found = false;
                while (sri.hasNext() && !found) {
                    newFlight = (FlightLight)sri.next();
                    if (!newFlight.getOutboundCode().equals(oldFlight.getOutboundCode())) continue;
                    return newFlight;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return oldFlight;
    }

    public static void updateForecastPax(FlightLight orgFlight, FlightLight newFlight, FlightLegComplete orgFlightLeg, Map<CabinClassComplete, Integer> pax) {
        for (PaxFigureComplete f : orgFlightLeg.getPaxFigures()) {
            Integer paxCount = pax.get(f.getCabinClass());
            if (paxCount == null) continue;
            f.setNumber(paxCount);
        }
    }

    public static int updateForecastPax(FlightConverter fcon, FlightDateConverter fcdcon, Set<PaxFigureTypeComplete> usedTypes, boolean useFinalPax, boolean includeSPMLPax, boolean includePax, StyledWorkbook wb, Sheet sheet, int cr, DateDurationComplete timeWindow, FlightLight oldFlight, FlightComplete oldFlightComplete, boolean includeExcel, StringBuffer text, boolean openPlannedFlight) {
        Date newDate = PaxUpdateToolkit.getFlightSearchDate((FlightLight)oldFlightComplete, timeWindow);
        FlightSearchConfiguration fsc = new FlightSearchConfiguration();
        fsc.setCustomer(oldFlight.getCustomer());
        fsc.setFlightNumber(oldFlight.getOutboundCode());
        fsc.setDayPeriod(new PeriodComplete(new Date(newDate.getTime()), new Date(newDate.getTime())));
        if (!openPlannedFlight) {
            fsc.setOnlyOpenFlights(Boolean.valueOf(true));
        }
        try {
            SearchResultIterator sri = new SearchResultIterator((ASearchConfiguration)fsc);
            FlightLight newFlight = null;
            boolean found = false;
            while (sri.hasNext() && !found) {
                newFlight = (FlightLight)sri.next();
                if (!newFlight.getOutboundCode().equals(oldFlight.getOutboundCode())) continue;
                found = true;
                FlightComplete fc = null;
                fc = oldFlight.getId() == null ? (oldFlightComplete != null ? oldFlightComplete : (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getPlannedFlightComplete(oldFlight).getValue()) : (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight((FlightReference)oldFlight).getValue();
                for (FlightLegComplete leg : fc.getLegs()) {
                    for (FlightLegComplete oleg : newFlight.getLegs()) {
                        if (!oleg.getNumber().equals(leg.getNumber())) continue;
                        for (PaxFigureComplete pf : leg.getPaxFigures()) {
                            if ((pf.getPaxFigureType() != null || !useFinalPax) && !usedTypes.contains(pf.getPaxFigureType()) || !includePax && Boolean.TRUE.equals(pf.getCabinClass().getCrewClass())) continue;
                            for (PaxFigureComplete opf : oleg.getPaxFigures()) {
                                if (!opf.getCabinClass().equals((Object)pf.getCabinClass())) continue;
                                if (includeExcel) {
                                    ExcelRow r = new ExcelRow();
                                    r.addCell((Object)oldFlight.getStd(), new String[0]);
                                    r.addCell((Object)oldFlight.getOutboundCode(), new String[0]);
                                    r.addCell((Object)oldFlight.getCustomer().getCode(), new String[0]);
                                    r.addCell((Object)fc.getStd(), new String[0]);
                                    r.addCell((Object)fc.getOutboundCode(), new String[0]);
                                    r.addCell((Object)(leg.getDepartureAirport().getCode() + " - " + leg.getArrivalAirport().getCode()), new String[0]);
                                    r.addCell((Object)(pf.getPaxFigureType() != null ? pf.getPaxFigureType().getCode() : "Final Pax"), new String[0]);
                                    r.addCell((Object)opf.getCabinClass().getCode(), new String[0]);
                                    r.addCell((Object)pf.getNumber(), new String[0]);
                                    r.addCell((Object)opf.getNumber(), new String[0]);
                                    cr = r.writeRow(wb, sheet, false, cr);
                                }
                                pf.setNumber(opf.getNumber());
                            }
                        }
                    }
                }
                if (includeSPMLPax) {
                    FlightComplete nFlight = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getFlight(new FlightReference(newFlight.getId())).getValue();
                    for (SpecialMealOrderComplete o : nFlight.getSpmlOrders()) {
                        if (PaxUpdateToolkit.hasOrder(o, fc.getSpmlOrders())) continue;
                        SpecialMealOrderComplete no = new SpecialMealOrderComplete();
                        no.setClientOId(Long.valueOf(ADTO.getNextId()));
                        no.setCabinClass(o.getCabinClass());
                        no.setCount(o.getCount());
                        no.setFlight((FlightReference)fc);
                        no.setMenuType(o.getMenuType());
                        no.setPaxName(o.getPaxName());
                        no.setPredefined(Boolean.valueOf(false));
                        no.setSeatNumber(o.getSeatNumber());
                        no.setStowingPosition(null);
                        for (FlightLegComplete l : o.getLegs()) {
                            FlightLegComplete nl = PaxUpdateToolkit.getLeg(l, fc.getLegs());
                            if (nl == null) continue;
                            no.getLegs().add(nl);
                        }
                        fc.getSpmlOrders().add(no);
                    }
                }
                if (fc.getId() != null) {
                    fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).update(fc, new ListWrapper(), false, false, false, false).getObject();
                } else {
                    fc.setFlightState(FlightStateE.OPEN);
                    fc = (FlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).create(fc, new ListWrapper(), fc.getActiveStowingList().getMatriculation()).getValue();
                }
                if (!includeExcel) continue;
                text.append("- " + fcon.convert(oldFlight, null, new Object[0]) + " " + fcdcon.convert(oldFlight, null, new Object[0]) + " updated<br/>");
                text.append("--> with " + fcon.convert(newFlight, null, new Object[0]) + " " + fcdcon.convert(newFlight, null, new Object[0]) + "<br/>");
            }
            if (!found) {
                newFlight = null;
                if (includeExcel) {
                    text.append("<font color=RED>- " + fcon.convert(oldFlight, null, new Object[0]) + " " + fcdcon.convert(oldFlight, null, new Object[0]) + " not updated<br/>");
                    text.append("--> NOT UPDATED</font><br/>");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cr;
    }

    public static FlightLegComplete getLeg(FlightLegComplete origin, List<FlightLegComplete> legs) {
        for (FlightLegComplete l : legs) {
            if (!l.getNumber().equals(origin.getNumber())) continue;
            return l;
        }
        return null;
    }

    public static boolean hasOrder(SpecialMealOrderComplete originOrder, List<SpecialMealOrderComplete> orders) {
        for (SpecialMealOrderComplete o : orders) {
            if (!o.getCabinClass().equals((Object)originOrder.getCabinClass()) || !o.getCount().equals(originOrder.getCount()) || !o.getMenuType().equals((Object)originOrder.getMenuType())) continue;
            return true;
        }
        return false;
    }
}

