/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.util.variantaccessor;

import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.mealplan.MealPlanServiceManager;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantLight;
import ch.icit.pegasus.server.core.dtos.mealplan.CateringServiceScheduleVariantReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.accessor.CateringServiceVariantAccessor;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CateringServiceVariantAccessorImpl
implements CateringServiceVariantAccessor {
    private Map<CateringServiceScheduleComplete, List<CateringServiceScheduleVariantLight>> variants = new HashMap<CateringServiceScheduleComplete, List<CateringServiceScheduleVariantLight>>();
    private Map<CateringServiceScheduleVariantReference, CateringServiceScheduleVariantComplete> completes = new HashMap<CateringServiceScheduleVariantReference, CateringServiceScheduleVariantComplete>();

    public CateringServiceScheduleVariantComplete loadData(CateringServiceScheduleComplete reference, Timestamp ts) throws ClientServerCallException {
        List v = this.variants.get(reference);
        if (v == null) {
            v = ((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getVariants(new ListWrapper(reference.getVariants())).getList();
            this.variants.put(reference, v);
        }
        CateringServiceScheduleVariantLight selected = null;
        for (CateringServiceScheduleVariantLight cv : v) {
            if (ts.getTime() < cv.getValidityPeriod().getStartDate().getTime() || ts.getTime() > cv.getValidityPeriod().getEndDate().getTime()) continue;
            selected = cv;
        }
        if (selected == null) {
            throw new IllegalArgumentException("No valid Catering Service Variant found for Service " + reference.getMealplan().getNumber() + " " + reference.getMealplan().getName() + " at " + ((DateConverter)ConverterRegistry.getConverter(DateConverter.class)).convert((Object)ts, null, new Object[0]));
        }
        CateringServiceScheduleVariantComplete ccv = this.completes.get(selected);
        if (ccv != null) {
            return ccv;
        }
        ccv = (CateringServiceScheduleVariantComplete)((MealPlanServiceManager)ServiceManagerRegistry.getService(MealPlanServiceManager.class)).getVariant(new CateringServiceScheduleVariantReference(selected.getId())).getValue();
        this.completes.put(new CateringServiceScheduleVariantReference(selected.getId()), ccv);
        return ccv;
    }
}

