/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.utils;

import ch.icit.pegasus.server.core.dtos.util.DateDurationComplete;
import ch.icit.pegasus.server.core.util.TimeUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalTime;

public class DateUtil {
    private static long TIME_MIN = 300000L;

    public static long getTimeMin() {
        return TIME_MIN;
    }

    public static <T extends Date> T addWorkingDays(T date, int days) {
        if (date == null) {
            return null;
        }
        boolean backwards = days < 0;
        int d = Math.abs(days);
        DateTime dt = new DateTime(date.getTime());
        while (d > 0) {
            dt = backwards ? dt.minusDays(1) : dt.plusDays(1);
            if (!DateUtil.isWorkingDay(dt)) continue;
            --d;
        }
        date.setTime(dt.getMillis());
        return date;
    }

    public static <T extends Date> T addDays(T date, int days) {
        if (date == null) {
            return null;
        }
        boolean backwards = days < 0;
        DateTime dt = new DateTime(date.getTime());
        for (int d = Math.abs(days); d > 0; --d) {
            dt = backwards ? dt.minusDays(1) : dt.plusDays(1);
        }
        date.setTime(dt.getMillis());
        return date;
    }

    public static boolean isWorkingDay(DateTime dt) {
        if (dt == null) {
            return false;
        }
        int dow = dt.getDayOfWeek();
        return dow != 6 && dow != 7;
    }

    public static DateTime addPeriod(DateTime dateTime, DateDurationComplete period) {
        if (period == null || dateTime == null) {
            return null;
        }
        switch (period.getUnit()) {
            case DAY: {
                return dateTime.plusDays(period.getDuration().intValue());
            }
            case MONTH: {
                return dateTime.plusMonths(period.getDuration().intValue());
            }
            case WEEK: {
                return dateTime.plusWeeks(period.getDuration().intValue());
            }
            case YEAR: {
                return dateTime.plusYears(period.getDuration().intValue());
            }
        }
        throw new IllegalStateException("Invalid date unit: " + period.getUnit());
    }

    public static boolean isInfinityDate(java.sql.Date date) {
        if (date == null) {
            return false;
        }
        Calendar c = TimeUtil.createCalendar();
        c.setTime(date);
        int y = c.get(1);
        int m = c.get(2);
        int d = c.get(5);
        if (y == 6666 && m == 6 && d == 6) {
            return true;
        }
        return y == 6666;
    }

    public static Date getDefaultStartDate() {
        Calendar c = TimeUtil.createCalendar();
        c.set(1, 2010);
        c.set(2, 0);
        c.set(5, 1);
        return new Date(c.getTimeInMillis());
    }

    public static Date getInfinityDate() {
        Calendar c = TimeUtil.createCalendar();
        c.set(1, 6666);
        c.set(2, 6);
        c.set(5, 6);
        return new Date(c.getTimeInMillis());
    }

    public static java.sql.Date getSQLInfinityDate() {
        return new java.sql.Date(DateUtil.getInfinityDate().getTime());
    }

    public static java.sql.Date getSQLDefaultStartDate() {
        return new java.sql.Date(DateUtil.getDefaultStartDate().getTime());
    }

    public static Date min(Date d1, Date d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return d1.before(d2) ? d1 : d2;
    }

    public static Date max(Date d1, Date d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return d1.after(d2) ? d1 : d2;
    }

    public static <T extends Date> DateTime getStartOfDay(T date) {
        if (date == null) {
            return null;
        }
        return new DateTime(date.getTime()).withTime(0, 0, 0, 0);
    }

    public static <T extends Date> T setStartOfDay(T date) {
        if (date == null) {
            return null;
        }
        long millis = DateUtil.getStartOfDay(date).getMillis();
        date.setTime(millis);
        return date;
    }

    public static <T extends Date> T setEndOfDay(T date) {
        if (date == null) {
            return null;
        }
        long millis = new DateTime(date.getTime()).withTime(23, 59, 59, 999).getMillis();
        date.setTime(millis);
        return date;
    }

    public static Time subtract(Time t, int hours) {
        DateTime dt = new DateTime(t.getTime()).withDate(2000, 1, 1);
        dt = dt.minusHours(hours);
        return new Time(dt.getMillis());
    }

    public static Timestamp subtract(Timestamp t, int hours) {
        DateTime dt = new DateTime(t.getTime());
        dt = dt.minusHours(hours);
        return new Timestamp(dt.getMillis());
    }

    public static Time normalize(Time t) {
        if (t == null) {
            return null;
        }
        DateTime dt = new DateTime(t.getTime()).withDate(1970, 1, 1);
        return new Time(dt.getMillis());
    }

    public static Date normalize(Date d) {
        if (d == null) {
            return null;
        }
        DateTime dt = new DateTime(d.getTime()).withTime(0, 0, 0, 0);
        return new Date(dt.getMillis());
    }

    public static Time removeSeconds(Time t) {
        if (t == null) {
            return null;
        }
        DateTime dt = new DateTime(t.getTime()).withDate(1970, 1, 1).withSecondOfMinute(0).withMillisOfSecond(0);
        return new Time(dt.getMillis());
    }

    public static Timestamp removeSeconds(Timestamp t) {
        if (t == null) {
            return null;
        }
        DateTime dt = new DateTime(t.getTime()).withSecondOfMinute(0).withMillisOfSecond(0);
        return new Timestamp(dt.getMillis());
    }

    public static <T extends Date> int getDayOfWeek(T d) {
        if (d == null) {
            return -1;
        }
        DateTime dt = new DateTime(d.getTime());
        return dt.getDayOfWeek();
    }

    public static <T extends Date> int getMonthOfYear(T d) {
        if (d == null) {
            return -1;
        }
        return new DateTime(d.getTime()).getMonthOfYear();
    }

    public static <T extends Date> int getYear(T d) {
        if (d == null) {
            return -1;
        }
        return new DateTime(d.getTime()).getYear();
    }

    public static <T extends Date> int getDayOfMonth(T d) {
        if (d == null) {
            return -1;
        }
        return new DateTime(d.getTime()).getDayOfMonth();
    }

    public static <T extends Date> int getHourOfDay(T d) {
        if (d == null) {
            return -1;
        }
        return new DateTime(d.getTime()).getHourOfDay();
    }

    public static <T extends Date> int getMinuteOfHour(T d) {
        if (d == null) {
            return -1;
        }
        return new DateTime(d.getTime()).getMinuteOfHour();
    }

    public static <T extends Date> int getSecondsOfMinute(T d) {
        if (d == null) {
            return -1;
        }
        return new DateTime(d.getTime()).getSecondOfMinute();
    }

    public static DateTime getDayStartDateTime(Date date, Time dayStartTime) {
        if (date == null) {
            return null;
        }
        LocalTime ds = new LocalTime(dayStartTime.getTime());
        return new DateTime(date.getTime()).withTime(ds.getHourOfDay(), ds.getMinuteOfHour(), 0, 0);
    }

    public static Timestamp getDayStartTimestamp(Date date, Time dayStartTime) {
        if (date == null) {
            return null;
        }
        return new Timestamp(DateUtil.getDayStartDateTime(date, dayStartTime).getMillis());
    }

    public static Date getDate(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new Date(DateUtil.getStartOfDay(timestamp).getMillis());
    }

    public static Date getDate(int year, int month, int day) {
        return new Date(new DateTime(year, month, day, 0, 0, 0, 0).getMillis());
    }

    public static Date getDate(int year, int month, int day, int hour, int minute, int second) {
        return new Date(new DateTime(year, month, day, hour, minute, second, 0).getMillis());
    }

    public static java.sql.Date getSQLDate(int year, int month, int day) {
        return new java.sql.Date(new DateTime(year, month, day, 0, 0, 0, 0).getMillis());
    }

    public static java.sql.Date getSQLDate(int year, int month, int day, int hour, int minute, int second) {
        return new java.sql.Date(new DateTime(year, month, day, hour, minute, second, 0).getMillis());
    }

    public static Time getSQLTime(int hour, int minute, int second) {
        return new Time(hour, minute, second);
    }

    public static Timestamp getTimestamp(int year, int month, int day, int hour, int minute, int second) {
        return new Timestamp(new DateTime(year, month, day, hour, minute, second, 0).getMillis());
    }

    public static Timestamp mergeTimes(Timestamp original, Time newTime) {
        LocalDate d = new LocalDate(original.getTime());
        LocalTime t = new LocalTime(newTime.getTime());
        DateTime dateTime = new DateTime(d.getYear(), d.getMonthOfYear(), d.getDayOfMonth(), t.getHourOfDay(), t.getMinuteOfHour(), t.getSecondOfMinute(), t.getMillisOfSecond());
        return new Timestamp(dateTime.getMillis());
    }

    public static Timestamp getTimestampWithSecondsLikeZero(Timestamp original) {
        LocalDate d = new LocalDate(original.getTime());
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(original.getTime());
        int hours = calendar.get(11);
        int minutes = calendar.get(12);
        LocalTime t = new LocalTime(new Time(hours, minutes, 0).getTime());
        DateTime dateTime = new DateTime(d.getYear(), d.getMonthOfYear(), d.getDayOfMonth(), t.getHourOfDay(), t.getMinuteOfHour(), t.getSecondOfMinute(), t.getMillisOfSecond());
        return new Timestamp(dateTime.getMillis());
    }

    public static java.sql.Date getSQLDate(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new java.sql.Date(DateUtil.getStartOfDay(timestamp).getMillis());
    }

    public static java.sql.Date getSQLDate(Date date) {
        if (date == null) {
            return null;
        }
        return new java.sql.Date(DateUtil.getStartOfDay(date).getMillis());
    }

    public static Timestamp getSQLDate(Date date, Time time) {
        if (date == null) {
            return null;
        }
        if (time == null) {
            return null;
        }
        return DateUtil.getTimestamp(DateUtil.getYear(date), DateUtil.getMonthOfYear(date), DateUtil.getDayOfMonth(date), DateUtil.getHourOfDay(time), DateUtil.getMinuteOfHour(time), 0);
    }

    public static Time getTime(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        DateTime dt = new DateTime(timestamp.getTime()).withDate(1970, 1, 1);
        return new Time(dt.getMillis());
    }

    public static Timestamp getTimestamp(Date date, Time time) {
        if (date == null || time == null) {
            return null;
        }
        DateTime t = new DateTime(time.getTime());
        DateTime d = new DateTime(date.getTime());
        DateTime dt = new DateTime(d.getYear(), d.getMonthOfYear(), d.getDayOfMonth(), t.getHourOfDay(), t.getMinuteOfHour(), t.getSecondOfMinute(), t.getMillisOfSecond());
        return new Timestamp(dt.getMillis());
    }

    public static Date getCurrentDate() {
        Date date = new Date();
        DateUtil.setStartOfDay(date);
        return date;
    }

    public static java.sql.Date getCurrentSQLDate() {
        java.sql.Date date = new java.sql.Date(System.currentTimeMillis());
        DateUtil.setStartOfDay(date);
        return date;
    }

    public static String getMonthNameForMonthInYear(int m) {
        switch (m) {
            case 1: {
                return "January";
            }
            case 2: {
                return "February";
            }
            case 3: {
                return "March";
            }
            case 4: {
                return "April";
            }
            case 5: {
                return "Mai";
            }
            case 6: {
                return "June";
            }
            case 7: {
                return "July";
            }
            case 8: {
                return "August";
            }
            case 9: {
                return "September";
            }
            case 10: {
                return "October";
            }
            case 11: {
                return "November";
            }
            case 12: {
                return "December";
            }
        }
        return "";
    }

    public static <T extends Date> String getDayName(T date) {
        return DateUtil.getDayName(DateUtil.getDayOfWeek(date));
    }

    public static String getDayName(int day) {
        switch (day) {
            case 1: {
                return "Monday";
            }
            case 2: {
                return "Tuesday";
            }
            case 3: {
                return "Wednesday";
            }
            case 4: {
                return "Thursday";
            }
            case 5: {
                return "Friday";
            }
            case 6: {
                return "Saturday";
            }
            case 7: {
                return "Sunday";
            }
        }
        return "Noday";
    }

    public static <T extends Date> String getDayShortName(T date) {
        return DateUtil.getDayShortName(DateUtil.getDayOfWeek(date));
    }

    public static String getDayShortName(int day) {
        switch (day) {
            case 1: {
                return "mo";
            }
            case 2: {
                return "tue";
            }
            case 3: {
                return "wed";
            }
            case 4: {
                return "thu";
            }
            case 5: {
                return "fri";
            }
            case 6: {
                return "sat";
            }
            case 7: {
                return "sun";
            }
        }
        return "nod";
    }

    public static Timestamp getLastDayOfMonth(int month, int year) {
        LocalDate lastDayOfMonth = new LocalDate(year, month, 1).dayOfMonth().withMaximumValue();
        Timestamp timestamp = new Timestamp(lastDayOfMonth.toDateTimeAtMidnight().getMillis());
        return timestamp;
    }

    public static Timestamp getFirstDayOfMonth(int month, int year) {
        LocalDate lastDayOfMonth = new LocalDate(year, month, 1);
        Timestamp timestamp = new Timestamp(lastDayOfMonth.toDateTimeAtStartOfDay().getMillis());
        return timestamp;
    }

    public static Timestamp getLastDayOfLastMonth() {
        Calendar aCalendar = TimeUtil.createCalendar();
        aCalendar.add(2, -1);
        aCalendar.set(5, aCalendar.getActualMaximum(5));
        aCalendar.set(11, 23);
        aCalendar.set(12, 59);
        aCalendar.set(13, 59);
        aCalendar.set(14, 999);
        Timestamp time = new Timestamp(aCalendar.getTimeInMillis());
        return time;
    }

    public static Timestamp getFirstDayOfLastMonth() {
        Calendar aCalendar = TimeUtil.createCalendar();
        aCalendar.add(2, -1);
        aCalendar.set(5, 1);
        aCalendar.set(11, 0);
        aCalendar.set(12, 0);
        aCalendar.set(13, 0);
        aCalendar.set(14, 0);
        Timestamp time = new Timestamp(aCalendar.getTimeInMillis());
        return time;
    }

    public static Timestamp getNextTime(Timestamp timestamp, long milli) {
        Calendar calendar = TimeUtil.createCalendar();
        calendar.setTimeInMillis(timestamp.getTime());
        calendar.add(14, (int)milli);
        timestamp = new Timestamp(calendar.getTimeInMillis());
        return timestamp;
    }

    public static String getWeekOfYear(Date date) {
        Calendar calendar = TimeUtil.createCalendar();
        calendar.setTimeInMillis(date.getTime());
        int n = calendar.get(3);
        String t = "" + n;
        if (t.length() == 1) {
            t = "0" + n;
        }
        return t;
    }
}

