/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.search;

import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.tracking.SealComplete;
import ch.icit.pegasus.server.core.general.SearchImplType;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.util.Tuple;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SealSearchConfiguration
extends ADtoSearchConfiguration<SealComplete, SEAL_COLUMN> {
    @XmlAttribute
    private String sealNumber;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private CustomerLight customer;

    public SearchImplType getIdentifier() {
        return SearchImplType.SEAL_TRACKER;
    }

    public CustomerLight getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerLight customer) {
        this.customer = customer;
    }

    public SEAL_COLUMN getDefaultSortColumn() {
        return SEAL_COLUMN.SEAL_NUMBER;
    }

    public List<Tuple<String, String>> getSearchConfig() {
        ArrayList<Tuple<String, String>> configs = new ArrayList<Tuple<String, String>>();
        configs.add(new Tuple((Object)Words.CUSTOMER, (Object)(this.getCustomer() != null ? this.getCustomer().getCode() : "")));
        configs.add(new Tuple((Object)Words.NUMBER, (Object)(this.getSealNumber() != null ? this.getSealNumber().toString() : "")));
        return configs;
    }

    public String getSealNumber() {
        return this.sealNumber;
    }

    public void setSealNumber(String sealNumber) {
        this.sealNumber = this.limitString(sealNumber);
    }

    public static enum SEAL_COLUMN {
        SEAL_NUMBER,
        SEAL_COLOR,
        SEAL_TYPE;

    }
}

