/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.supply;

import ch.icit.pegasus.server.core.calculator.IPackagingQuantityBase;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryLight;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleOriginComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CommodityLight;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticlePriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleTenderPriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleTypeE;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorComplete;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorTenderVariantComplete;
import ch.icit.pegasus.server.core.dtos.supply.MaterialCostFactorVariantComplete;
import ch.icit.pegasus.server.core.dtos.supply.PackagingQuantityBaseComplete;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@DTO(target="ch.icit.pegasus.server.core.entities.basicarticle.BasicArticle")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class BasicArticleLight
extends BasicArticleReference
implements CommodityLight,
Comparable<BasicArticleLight> {
    @DTOField(nullable=false, empty=false)
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String labelName;
    @XmlAttribute
    private Boolean noExpiryDate;
    @XmlAttribute
    private Boolean purchaseCharge;
    private BasicArticleTypeE articleType;
    @XmlAttribute
    private Boolean showOnCCPAnyway;
    @XmlAttribute
    private Boolean hasCustomsDeadline;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @DTOField(nullable=false)
    private UnitComplete baseUnit;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @DTOField(nullable=false)
    private UnitComplete priceUnit;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @DTOField(nullable=false)
    private UnitComplete mainStoreUnit;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @DTOField(nullable=false)
    private UnitComplete floatStoreUnit;
    @XmlAttribute
    private Boolean excludeFromPurchaseLabelPrint;
    @DTOField(readonly=true)
    @XmlAttribute
    private Integer number;
    @XmlAttribute
    private Boolean bonded;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ArticleCategoryLight category;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private ArticleOriginComplete originCountry;
    @XmlAttribute
    private Boolean isInUse;
    @XmlAttribute
    private Boolean customerIsOwner;
    @XmlAttribute
    private Boolean excludeFromMaterialCostCalculations;
    private PegasusFileComplete mainStoreUnitImage;
    private PegasusFileComplete floatStoreUnitImage;
    private PegasusFileComplete productionUnitImage;
    @XmlAttribute
    private String customerArticleNumber = "";
    @IgnoreField
    @XmlAttribute
    private String supplierArticleNumber;
    @IgnoreField
    private PriceComplete supplierPrice;
    private List<BasicArticlePriceComplete> prices;
    private List<BasicArticleTenderPriceComplete> tenderPrices;
    private List<MaterialCostFactorVariantComplete> materialCostFactorVariants;
    private List<MaterialCostFactorTenderVariantComplete> materialCostFactorTenderVariants;
    @IgnoreField
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private MaterialCostFactorComplete selectedFactor;
    @IgnoreField
    @XmlAttribute
    private String customerName;
    @XmlAttribute
    private String gmcCode;
    @XmlAttribute
    private String englishName;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private CostCenterComplete defaultProductionDepartment;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private CostCenterComplete defaultRequisitionDeliverDepartment;
    @XmlAttribute
    private Boolean reUsable;
    @XmlAttribute
    private Boolean isNominated;
    @XmlAttribute
    private String orderName;
    @DTOField(maxStringLength=0x7FFFFFFF)
    @XmlAttribute
    private String usageComment;
    @Deprecated
    @XmlAttribute
    private Boolean autoCheckout = false;
    @XmlAttribute
    private Boolean allergensApproved = false;
    @XmlAttribute
    private Boolean nutritionApproved = false;
    private ArticleModificationStateE state = ArticleModificationStateE.DRAFT;
    @XmlAttribute
    private Boolean halal = false;
    @XmlAttribute
    private Boolean kosher = false;
    @XmlAttribute
    private Boolean chilled = false;
    @XmlAttribute
    private Boolean frozen = true;
    @XmlAttribute
    private Boolean canCreateTransactions = false;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    private CustomerLight customer;
    private List<PackagingQuantityBaseComplete> packingQuantitiesVariants;

    public BasicArticleLight() {
        this.prices = new ArrayList<BasicArticlePriceComplete>();
        this.materialCostFactorVariants = new ArrayList<MaterialCostFactorVariantComplete>();
        this.tenderPrices = new ArrayList<BasicArticleTenderPriceComplete>();
        this.materialCostFactorTenderVariants = new ArrayList<MaterialCostFactorTenderVariantComplete>();
        this.packingQuantitiesVariants = new ArrayList<PackagingQuantityBaseComplete>();
    }

    public Boolean getFrozen() {
        return this.frozen;
    }

    public void setFrozen(Boolean frozen) {
        this.frozen = frozen;
    }

    public Boolean getHasCustomsDeadline() {
        return this.hasCustomsDeadline;
    }

    public void setHasCustomsDeadline(Boolean hasCustomsDeadline) {
        this.hasCustomsDeadline = hasCustomsDeadline;
    }

    public Boolean getShowOnCCPAnyway() {
        return this.showOnCCPAnyway;
    }

    public void setShowOnCCPAnyway(Boolean showOnCCPAnyway) {
        this.showOnCCPAnyway = showOnCCPAnyway;
    }

    public Boolean getNoExpiryDate() {
        return this.noExpiryDate;
    }

    public void setNoExpiryDate(Boolean noExpiryDate) {
        this.noExpiryDate = noExpiryDate;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public void setEnglishName(String englishName) {
        this.englishName = englishName;
    }

    public Boolean getIsNominated() {
        return this.isNominated;
    }

    public void setIsNominated(Boolean isNominated) {
        this.isNominated = isNominated;
    }

    public Boolean getCustomerIsOwner() {
        return this.customerIsOwner;
    }

    public void setCustomerIsOwner(Boolean customerIsOwner) {
        this.customerIsOwner = customerIsOwner;
    }

    public String getUsageComment() {
        return this.usageComment;
    }

    public void setUsageComment(String usageComment) {
        this.usageComment = usageComment;
    }

    public PriceComplete getSupplierPrice() {
        return this.supplierPrice;
    }

    public void setSupplierPrice(PriceComplete supplierPrice) {
        this.supplierPrice = supplierPrice;
    }

    public Boolean getHalal() {
        return this.halal;
    }

    public void setHalal(Boolean halal) {
        this.halal = halal;
    }

    public Boolean getReUsable() {
        return this.reUsable;
    }

    public void setReUsable(Boolean reUsable) {
        this.reUsable = reUsable;
    }

    public Boolean getAllergensApproved() {
        return this.allergensApproved;
    }

    public void setAllergensApproved(Boolean allergensApproved) {
        this.allergensApproved = allergensApproved;
    }

    public Boolean getBonded() {
        return this.bonded;
    }

    public void setBonded(Boolean bonded) {
        this.bonded = bonded;
    }

    public Boolean getIsInUse() {
        return this.isInUse;
    }

    public void setIsInUse(Boolean isInUse) {
        this.isInUse = isInUse;
    }

    public String getOwnerArticleNumber() {
        return this.customerArticleNumber;
    }

    public void setOwnerArticleNumber(String customerArticleNumber) {
        this.customerArticleNumber = customerArticleNumber;
    }

    public String getCustomerArticleNumber() {
        return this.customerArticleNumber;
    }

    public void setCustomerArticleNumber(String customerArticleNumber) {
        this.customerArticleNumber = customerArticleNumber;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Integer getNumber() {
        return this.number;
    }

    @Override
    public void setNumber(Integer number) {
        this.number = number;
    }

    public ArticleCategoryLight getCategory() {
        return this.category;
    }

    public void setCategory(ArticleCategoryLight category) {
        this.category = category;
    }

    @Override
    public String toString() {
        return this.number + " - " + this.name;
    }

    public String getSupplierArticleNumber() {
        return this.supplierArticleNumber;
    }

    public void setSupplierArticleNumber(String supplierArticleNumber) {
        this.supplierArticleNumber = supplierArticleNumber;
    }

    public MaterialCostFactorComplete getSelectedFactor() {
        return this.selectedFactor;
    }

    public void setSelectedFactor(MaterialCostFactorComplete selectedFactor) {
        this.selectedFactor = selectedFactor;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public void setLabelName(String labelName) {
        this.labelName = labelName;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getGmcCode() {
        return this.gmcCode;
    }

    public void setGmcCode(String gmcCode) {
        this.gmcCode = gmcCode;
    }

    public String getOrderName() {
        return this.orderName;
    }

    public void setOrderName(String orderName) {
        this.orderName = orderName;
    }

    @Deprecated
    public Boolean getAutoCheckout() {
        return this.autoCheckout;
    }

    @Deprecated
    public void setAutoCheckout(Boolean autoCheckout) {
        this.autoCheckout = autoCheckout;
    }

    @Override
    public int compareTo(BasicArticleLight o) {
        return this.number - o.getNumber();
    }

    public List<BasicArticlePriceComplete> getPrices() {
        return this.prices;
    }

    public void setPrices(List<BasicArticlePriceComplete> prices) {
        this.prices = prices;
    }

    public List<MaterialCostFactorVariantComplete> getMaterialCostFactorVariants() {
        return this.materialCostFactorVariants;
    }

    public void setMaterialCostFactorVariants(List<MaterialCostFactorVariantComplete> materialCostFactorVariants) {
        this.materialCostFactorVariants = materialCostFactorVariants;
    }

    public List<BasicArticleTenderPriceComplete> getTenderPrices() {
        return this.tenderPrices;
    }

    public void setTenderPrices(List<BasicArticleTenderPriceComplete> tenderPrices) {
        this.tenderPrices = tenderPrices;
    }

    public List<MaterialCostFactorTenderVariantComplete> getMaterialCostFactorTenderVariants() {
        return this.materialCostFactorTenderVariants;
    }

    public void setMaterialCostFactorTenderVariants(List<MaterialCostFactorTenderVariantComplete> materialCostFactorTenderVariants) {
        this.materialCostFactorTenderVariants = materialCostFactorTenderVariants;
    }

    public CostCenterComplete getDefaultProductionDepartment() {
        return this.defaultProductionDepartment;
    }

    public void setDefaultProductionDepartment(CostCenterComplete defaultProductionDepartment) {
        this.defaultProductionDepartment = defaultProductionDepartment;
    }

    public CostCenterComplete getDefaultRequisitionDeliverDepartment() {
        return this.defaultRequisitionDeliverDepartment;
    }

    public void setDefaultRequisitionDeliverDepartment(CostCenterComplete defaultRequisitionDeliverDepartment) {
        this.defaultRequisitionDeliverDepartment = defaultRequisitionDeliverDepartment;
    }

    public ArticleModificationStateE getState() {
        return this.state;
    }

    public void setState(ArticleModificationStateE state) {
        this.state = state;
    }

    public Boolean getNutritionApproved() {
        return this.nutritionApproved;
    }

    public void setNutritionApproved(Boolean nutritionApproved) {
        this.nutritionApproved = nutritionApproved;
    }

    public ArticleOriginComplete getOriginCountry() {
        return this.originCountry;
    }

    public void setOriginCountry(ArticleOriginComplete originCountry) {
        this.originCountry = originCountry;
    }

    public UnitComplete getBaseUnit() {
        return this.baseUnit;
    }

    public void setBaseUnit(UnitComplete baseUnit) {
        this.baseUnit = baseUnit;
    }

    public Boolean getExcludeFromMaterialCostCalculations() {
        return this.excludeFromMaterialCostCalculations;
    }

    public void setExcludeFromMaterialCostCalculations(Boolean excludeFromMaterialCostCalculations) {
        this.excludeFromMaterialCostCalculations = excludeFromMaterialCostCalculations;
    }

    public CustomerLight getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerLight customer) {
        this.customer = customer;
    }

    public UnitComplete getPriceUnit() {
        return this.priceUnit;
    }

    public void setPriceUnit(UnitComplete priceUnit) {
        this.priceUnit = priceUnit;
    }

    public UnitComplete getMainStoreUnit() {
        return this.mainStoreUnit;
    }

    public void setMainStoreUnit(UnitComplete mainStoreUnit) {
        this.mainStoreUnit = mainStoreUnit;
    }

    public UnitComplete getFloatStoreUnit() {
        return this.floatStoreUnit;
    }

    public void setFloatStoreUnit(UnitComplete floatStoreUnit) {
        this.floatStoreUnit = floatStoreUnit;
    }

    public PegasusFileComplete getMainStoreUnitImage() {
        return this.mainStoreUnitImage;
    }

    public void setMainStoreUnitImage(PegasusFileComplete mainStoreUnitImage) {
        this.mainStoreUnitImage = mainStoreUnitImage;
    }

    public PegasusFileComplete getFloatStoreUnitImage() {
        return this.floatStoreUnitImage;
    }

    public void setFloatStoreUnitImage(PegasusFileComplete floatStoreUnitImage) {
        this.floatStoreUnitImage = floatStoreUnitImage;
    }

    public PegasusFileComplete getProductionUnitImage() {
        return this.productionUnitImage;
    }

    public void setProductionUnitImage(PegasusFileComplete productionUnitImage) {
        this.productionUnitImage = productionUnitImage;
    }

    public Boolean getExcludeFromPurchaseLabelPrint() {
        return this.excludeFromPurchaseLabelPrint;
    }

    public void setExcludeFromPurchaseLabelPrint(Boolean excludeFromPurchaseLabelPrint) {
        this.excludeFromPurchaseLabelPrint = excludeFromPurchaseLabelPrint;
    }

    public Boolean getChilled() {
        return this.chilled;
    }

    public void setChilled(Boolean chilled) {
        this.chilled = chilled;
    }

    public Boolean getCanCreateTransactions() {
        return this.canCreateTransactions;
    }

    public void setCanCreateTransactions(Boolean canCreateTransactions) {
        this.canCreateTransactions = canCreateTransactions;
    }

    public List<PackagingQuantityBaseComplete> getPackingQuantitiesVariants() {
        return this.packingQuantitiesVariants;
    }

    public void setPackingQuantitiesVariants(List<PackagingQuantityBaseComplete> packingQuantitiesVariants) {
        this.packingQuantitiesVariants = packingQuantitiesVariants;
    }

    public IPackagingQuantityBase getPackingQuantitiesVariant(Timestamp validityDate) {
        if (this.packingQuantitiesVariants.isEmpty() || validityDate == null) {
            return new PackagingQuantityBaseComplete();
        }
        for (PackagingQuantityBaseComplete p : this.packingQuantitiesVariants) {
            if (p.getPeriod() == null || p.getPeriod().getStartDate() == null || p.getPeriod().getEndDate() == null || validityDate.getTime() < p.getPeriod().getStartDate().getTime() || validityDate.getTime() > p.getPeriod().getEndDate().getTime()) continue;
            if (p.getPackingQuantities() != null) {
                Collections.sort(p.getPackingQuantities());
            }
            return p;
        }
        return this.packingQuantitiesVariants.get(this.packingQuantitiesVariants.size() - 1);
    }

    public BasicArticleTypeE getArticleType() {
        return this.articleType;
    }

    public void setArticleType(BasicArticleTypeE articleType) {
        this.articleType = articleType;
    }

    public Boolean getKosher() {
        return this.kosher;
    }

    public void setKosher(Boolean kosher) {
        this.kosher = kosher;
    }

    public Boolean getPurchaseCharge() {
        return this.purchaseCharge;
    }

    public void setPurchaseCharge(Boolean purchaseCharge) {
        this.purchaseCharge = purchaseCharge;
    }
}

