/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.masterdata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;

public class UploadImage
implements Serializable {
    private final byte[] rawImage;

    public UploadImage(String filePath) throws IOException {
        this.rawImage = this.getFileAsByteArray(filePath);
    }

    private byte[] getFileAsByteArray(String filePath) throws IOException {
        byte[] bytes;
        File file = new File(filePath);
        try (FileInputStream is = new FileInputStream(file);){
            int offset;
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                // empty if block
            }
            bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
        }
        return bytes;
    }

    public byte[] getRawImage() {
        return this.rawImage;
    }
}

