/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.dtos.recipe;

import ch.icit.pegasus.server.core.dtos.recipe.RecipeCategoryComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCategoryReference;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeCookingWasteVariantComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLadapter.XmlCache;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeMode;
import ch.icit.pegasus.server.dtos.annotations.ClientLogicNodeModes;
import ch.icit.pegasus.server.dtos.annotations.DTO;
import ch.icit.pegasus.server.dtos.annotations.DTOField;
import ch.icit.pegasus.server.dtos.annotations.IgnoreField;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DTO(target="ch.icit.pegasus.server.core.entities.masterdata.RecipeCategory")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RecipeCategoryLight
extends RecipeCategoryReference {
    @ClientLogicNodeMode(type=ClientLogicNodeModes.NONE)
    private static Logger logger = LoggerFactory.getLogger(RecipeCategoryLight.class);
    @XmlAttribute
    private String name;
    @ClientLogicNodeMode(type=ClientLogicNodeModes.PROXYNODE)
    @DTOField(target="superCategory")
    @XmlTransient
    private RecipeCategoryComplete parent;
    @XmlAttribute
    @IgnoreField
    private Long parentCategoryId;
    @XmlAttribute
    private Boolean display;
    @XmlAttribute
    private String code;
    private List<RecipeCookingWasteVariantComplete> cookingWaste = new ArrayList<RecipeCookingWasteVariantComplete>();

    public void setParent(RecipeCategoryComplete parent) {
        this.parent = parent;
    }

    public RecipeCategoryComplete getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getDisplay() {
        return this.display;
    }

    public void setDisplay(Boolean display) {
        this.display = display;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setParentCategoryId(Long parentCategoryId) {
        this.parentCategoryId = parentCategoryId;
    }

    public Long getParentCategoryId() {
        return this.parentCategoryId;
    }

    public List<RecipeCookingWasteVariantComplete> getCookingWaste() {
        return this.cookingWaste;
    }

    public void setCookingWaste(List<RecipeCookingWasteVariantComplete> cookingWaste) {
        this.cookingWaste = cookingWaste;
    }

    public void beforeMarshal(Marshaller m) {
        try {
            if (this.getParent() != null) {
                this.setParentCategoryId(this.getParent().getId());
            }
        }
        catch (Throwable e) {
            logger.error("", e);
        }
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        for (RecipeCategoryLight cat = this; cat != null; cat = cat.resolveParent()) {
        }
    }

    protected RecipeCategoryComplete resolveParent() {
        try {
            RecipeCategoryComplete newParent = null;
            Object o = XmlCache.getXmlCache().get(this.parentCategoryId);
            if (o instanceof RecipeCategoryComplete) {
                newParent = (RecipeCategoryComplete)o;
            }
            if (newParent != null) {
                this.setParent(newParent);
            }
            return newParent;
        }
        catch (Throwable e) {
            logger.error("", e);
            return null;
        }
    }
}

