/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.server.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class NTuple {
    private final Class<?> type;
    private final String name;
    private final Object[] values;
    private static final Collector<?, ?, NTuple> SIMPLE_COLLECTOR = Collectors.collectingAndThen(Collectors.toList(), NTuple::of);

    protected NTuple(@Nullable Class<?> type, @Nullable String name, Object[] values) {
        this.type = Self.class.equals(type) ? this.getClass() : type;
        this.name = name;
        this.values = values;
    }

    protected NTuple(Object ... values) {
        this(Self.class, null, values);
    }

    protected NTuple(Name name, Object ... values) {
        this(null, name.name, values);
    }

    protected static Name name(@Nullable String name) {
        return new Name(name);
    }

    public static NTuple of(Object ... values) {
        return new NTuple(NTuple.class, null, NTuple.toArray(values));
    }

    public static NTuple withType(Class<?> type, Object ... values) {
        return new NTuple(type, null, NTuple.toArray(values));
    }

    public static NTuple withName(String name, Object ... values) {
        return new NTuple(null, name, NTuple.toArray(values));
    }

    public static NTuple withTypeAndName(Class<?> type, String name, Object ... values) {
        return new NTuple(type, name, NTuple.toArray(values));
    }

    public static NTuple of(Collection<?> values) {
        return new NTuple(NTuple.class, null, NTuple.toArray(values));
    }

    public static NTuple withType(@Nullable Class<?> type, Collection<?> values) {
        return new NTuple(type, null, NTuple.toArray(values));
    }

    public static NTuple withName(String name, Collection<?> values) {
        return new NTuple(null, name, NTuple.toArray(values));
    }

    public static NTuple withTypeAndName(@Nullable Class<?> type, String name, Collection<?> values) {
        return new NTuple(type, name, NTuple.toArray(values));
    }

    public static NTuple of(Iterable<?> values) {
        return new NTuple(NTuple.class, null, NTuple.toArray(values));
    }

    public static NTuple withType(Class<?> type, Iterable<?> values) {
        return new NTuple(type, null, NTuple.toArray(values));
    }

    public static NTuple withName(String name, Iterable<?> values) {
        return new NTuple(null, name, NTuple.toArray(values));
    }

    public static NTuple withTypeAndName(Class<?> type, String name, Iterable<?> values) {
        return new NTuple(type, name, NTuple.toArray(values));
    }

    private static Object[] toArray(Object[] values) {
        return (Object[])values.clone();
    }

    private static Object[] toArray(Collection<?> values) {
        return values.toArray();
    }

    private static Object[] toArray(Iterable<?> values) {
        if (values instanceof Collection) {
            return NTuple.toArray((Collection)values);
        }
        ArrayList list = new ArrayList();
        for (Object v : values) {
            list.add(v);
        }
        return list.toArray();
    }

    public static <T> Collector<T, ?, NTuple> toGenericKey() {
        return SIMPLE_COLLECTOR;
    }

    public static <T> Collector<T, ?, NTuple> toGenericKey(Class<?> type) {
        return Collectors.collectingAndThen(Collectors.toList(), list -> NTuple.withType(type, new Object[0]));
    }

    public static <T> Collector<T, ?, NTuple> toGenericKey(String name) {
        return Collectors.collectingAndThen(Collectors.toList(), list -> NTuple.withName(name, new Object[0]));
    }

    public static <T> Collector<T, ?, NTuple> toGenericKey(Class<?> type, String name) {
        return Collectors.collectingAndThen(Collectors.toList(), list -> NTuple.withTypeAndName(type, name, new Object[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NTuple that = (NTuple)o;
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return Arrays.deepEquals(this.values, that.values);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.type != null) {
            buf.append(this.getClass().getCanonicalName());
        }
        if (this.name != null) {
            if (buf.length() > 0) {
                buf.append(':');
            }
            buf.append(this.name);
        }
        this.appendArray(buf, this.values);
        return buf.toString();
    }

    private void appendArray(StringBuilder buf, Object[] array) {
        boolean firstValue = true;
        buf.append('{');
        for (Object elem : array) {
            if (firstValue) {
                firstValue = false;
            } else {
                buf.append(',');
            }
            if (elem == null) {
                buf.append("null");
                continue;
            }
            if (elem.getClass().isArray()) {
                this.appendArray(buf, (Object[])elem);
                continue;
            }
            buf.append(String.valueOf(elem));
        }
        buf.append('}');
    }

    protected static final class Name {
        private final String name;

        private Name(String name) {
            this.name = name;
        }
    }

    protected static final class Self {
        private Self() {
        }
    }
}

