/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils;

import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.ExcelToolkitException;
import ch.icit.utils.StyledWorkbook;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelColumnComposer {
    private File baseFile;
    private Integer headerRowCount;
    private Integer targetIdField;
    private Integer originIdField;
    private Map<Integer, Integer> columnInsertMapping = new HashMap<Integer, Integer>();

    public File getBaseFile() {
        return this.baseFile;
    }

    public void setBaseFile(File baseFile) {
        this.baseFile = baseFile;
    }

    public void insertFile(File insertFile) throws ExcelToolkitException, InvalidFormatException, IOException {
        assert (this.baseFile != null);
        assert (insertFile != null);
        ArrayList<Integer> targets = new ArrayList<Integer>();
        targets.addAll(this.columnInsertMapping.keySet());
        Collections.sort(targets);
        List<ExcelRow> targetRows = ExcelToolkit.readRows(this.baseFile);
        List<ExcelRow> originRows = ExcelToolkit.readRows(insertFile);
        int c = 0;
        for (ExcelRow t : targetRows) {
            if (c < this.headerRowCount) {
                ++c;
                continue;
            }
            ++c;
            Object object = t.getCells().get(this.getTargetIdField());
            ExcelRow row = this.getRowForId(object, originRows);
            if (row != null) {
                for (Integer targetIndex : targets) {
                    Integer originIndex = this.columnInsertMapping.get(targetIndex);
                    Object value2Insert = row.getCells().get(originIndex);
                    t.getCells().add(targetIndex, value2Insert);
                }
                continue;
            }
            for (Integer targetIndex : targets) {
                t.getCells().add(targetIndex, null);
            }
        }
        Workbook wb = ExcelToolkit.readWorkbookFromFile(this.baseFile);
        StyledWorkbook wbb = new StyledWorkbook(wb);
        Sheet sheet = ExcelToolkit.insertSheet(wbb, "Merged with Mat Dispo");
        int cr = 0;
        for (ExcelRow t : targetRows) {
            cr = t.writeRow(wbb, sheet, t.isHeader(), cr);
        }
    }

    private ExcelRow getRowForId(Object id, List<ExcelRow> origin) {
        for (ExcelRow r : origin) {
            Object id2 = r.getCells().get(this.getOriginIdField());
            if (!id2.equals(id)) continue;
            return r;
        }
        return null;
    }

    public Map<Integer, Integer> getColumnInsertMapping() {
        return this.columnInsertMapping;
    }

    public void setColumnInsertMapping(Map<Integer, Integer> columnInsertMapping) {
        this.columnInsertMapping = columnInsertMapping;
    }

    public Integer getHeaderRowCount() {
        return this.headerRowCount;
    }

    public void setHeaderRowCount(Integer headerRowCount) {
        this.headerRowCount = headerRowCount;
    }

    public Integer getTargetIdField() {
        return this.targetIdField;
    }

    public void setTargetIdField(Integer targetIdField) {
        this.targetIdField = targetIdField;
    }

    public Integer getOriginIdField() {
        return this.originIdField;
    }

    public void setOriginIdField(Integer originIdField) {
        this.originIdField = originIdField;
    }
}

