/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils;

import ch.icit.utils.ExcelRow;
import ch.icit.utils.ExcelToolkit;
import ch.icit.utils.ExcelToolkitException;
import ch.icit.utils.NumberUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ExcelGroupMergeFile {
    private Integer countField;
    private Integer idField;
    private List<Integer> sumFields;
    private List<Integer> staticFields;
    private List<Integer> appendFields;
    private File baseFile;
    private boolean firstWrite;
    private int headerRowCount;
    private int footerCount;
    private String sheetName;

    public ExcelGroupMergeFile() {
        this.setSumFields(new ArrayList<Integer>());
        this.setStaticFields(new ArrayList<Integer>());
        this.setAppendFields(new ArrayList<Integer>());
    }

    public void mergeFile(File file) throws ExcelToolkitException {
        assert (this.baseFile != null);
        assert (file != null);
        List<Object> baseRows = null;
        List<ExcelRow> rows = ExcelToolkit.readRows(file);
        if (!this.firstWrite) {
            baseRows = new ArrayList();
            for (int i = 0; i < this.headerRowCount; ++i) {
                baseRows.add(rows.get(0));
                rows.remove(0);
            }
            this.firstWrite = true;
        } else {
            baseRows = ExcelToolkit.readRows(this.baseFile);
        }
        int c = 0;
        for (ExcelRow r : rows) {
            if (c >= rows.size() - this.footerCount) continue;
            ++c;
            Object id = r.getCells().get(this.idField);
            ExcelRow mergeRow = this.getRowForId(baseRows, id);
            if (mergeRow == null) {
                mergeRow = new ExcelRow();
                baseRows.add(mergeRow);
            }
            this.mergeRow(mergeRow, r);
        }
        ExcelToolkit.writeWorkBook(this.baseFile, baseRows, this.sheetName);
    }

    private void mergeRow(ExcelRow mergeRow, ExcelRow r) {
        Object d1;
        Object d2;
        Object d;
        for (Integer s : this.sumFields) {
            d = r.getCells().get(s);
            mergeRow.fillRow(s + 1, null);
            d2 = mergeRow.getCells().get(s);
            Double res = NumberUtils.add(d, d2);
            mergeRow.getCells().set(s, res);
        }
        for (Integer s : this.staticFields) {
            d = r.getCells().get(s);
            mergeRow.fillRow(s + 1, null);
            mergeRow.getCells().set(s, d);
        }
        for (Integer s : this.appendFields) {
            d = (String)r.getCells().get(s);
            mergeRow.fillRow(s + 1, null);
            d2 = (String)mergeRow.getCells().get(s);
            d2 = d2 != null ? ", " + (String)d : d;
            mergeRow.getCells().set(s, d2);
        }
        if (this.countField != null) {
            mergeRow.fillRow(this.countField + 1, null);
            d1 = mergeRow.getCells().get(this.countField);
            Double count = NumberUtils.add(d1, 1);
            mergeRow.getCells().set(this.countField, count);
        }
        mergeRow.fillRow(this.idField + 1, null);
        d1 = r.getCells().get(this.idField);
        mergeRow.getCells().set(this.idField, d1);
    }

    private ExcelRow getRowForId(List<ExcelRow> baseRows, Object id) {
        for (ExcelRow r : baseRows) {
            Object id2 = r.getCells().get(this.idField);
            if (!id2.equals(id)) continue;
            return r;
        }
        return null;
    }

    public List<Integer> getSumFields() {
        return this.sumFields;
    }

    public void setSumFields(List<Integer> sumFields) {
        this.sumFields = sumFields;
    }

    public List<Integer> getStaticFields() {
        return this.staticFields;
    }

    public void setStaticFields(List<Integer> staticFields) {
        this.staticFields = staticFields;
    }

    public List<Integer> getAppendFields() {
        return this.appendFields;
    }

    public void setAppendFields(List<Integer> appendFields) {
        this.appendFields = appendFields;
    }

    public Integer getCountField() {
        return this.countField;
    }

    public void setCountField(Integer countField) {
        this.countField = countField;
    }

    public Integer getIdField() {
        return this.idField;
    }

    public void setIdField(Integer idField) {
        this.idField = idField;
    }

    public File getBaseFile() {
        return this.baseFile;
    }

    public void setBaseFile(File baseFile) {
        this.baseFile = baseFile;
    }

    public int getHeaderRowCount() {
        return this.headerRowCount;
    }

    public void setHeaderRowCount(int headerRowCount) {
        this.headerRowCount = headerRowCount;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public int getFooterCount() {
        return this.footerCount;
    }

    public void setFooterCount(int footerCount) {
        this.footerCount = footerCount;
    }
}

