/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.util;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class PDFViewer
extends JFrame {
    static Image image;

    public PDFViewer(String title) {
        super(title);
        this.setDefaultCloseOperation(3);
        JLabel label = new JLabel(new ImageIcon(image));
        label.setVerticalAlignment(1);
        this.setContentPane(new JScrollPane(label));
        this.pack();
        this.setVisible(true);
    }

    public static void showPDF(File pdf) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(pdf, "r");){
            FileChannel fc = raf.getChannel();
            MappedByteBuffer buf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            PDFFile pdfFile = new PDFFile((ByteBuffer)buf);
            int numpages = pdfFile.getNumPages();
            System.out.println("Number of pages = " + numpages);
            PDFPage page = pdfFile.getPage(0);
            Rectangle2D r2d = page.getBBox();
            double width = r2d.getWidth();
            double height = r2d.getHeight();
            width /= 72.0;
            height /= 72.0;
            int res = Toolkit.getDefaultToolkit().getScreenResolution();
            image = page.getImage((int)(width *= (double)res), (int)(height *= (double)res), r2d, null, true, true);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    new PDFViewer("PDF Viewer");
                }
            };
            EventQueue.invokeLater(r);
        }
    }
}

