/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.util;

import ch.icit.util.PDFPrintPage;
import ch.icit.util.PrinterToolkitException;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import java.awt.geom.Rectangle2D;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.SheetCollate;

public class PrintPdf {
    private DocPrintJob dpjob = null;

    public boolean print(InputStream inputStream, String jobName, PrintService printer, int copies) throws IOException, PrinterException, PrinterToolkitException, PrintException {
        return this.print(inputStream, jobName, printer, copies, null);
    }

    public boolean print(InputStream inputStream, String jobName, PrintService printer, int copies, String trayName) throws IOException, PrinterException, PrinterToolkitException, PrintException {
        byte[] pdfContent = new byte[inputStream.available()];
        inputStream.read(pdfContent, 0, inputStream.available());
        return this.initialize(pdfContent, jobName, printer, copies, trayName);
    }

    private boolean initialize(byte[] pdfContent, String jobName, PrintService printer, int copies, String trayName) throws IOException, PrinterException, PrinterToolkitException, PrintException {
        Object trayValues;
        ByteBuffer bb = ByteBuffer.wrap(pdfContent);
        PDFFile pdfFile = new PDFFile(bb);
        PDFPrintPage pages = new PDFPrintPage(pdfFile);
        this.dpjob = printer.createPrintJob();
        PrinterJob pjob = PrinterJob.getPrinterJob();
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        if (trayName != null && (trayValues = printer.getSupportedAttributeValues(Media.class, null, null)) instanceof Media[]) {
            Media[] trays;
            System.out.println("Available trays:");
            for (Media tray : trays = (Media[])trayValues) {
                System.out.println(tray);
                if (!trayName.equals(tray.toString())) continue;
                aset.add(tray);
                break;
            }
        }
        aset.add(new Copies(copies));
        aset.add(SheetCollate.COLLATED);
        float w = 0.0f;
        float h = 0.0f;
        float x = 0.0f;
        float y = 0.0f;
        if (pdfFile.getNumPages() <= 0) {
            throw new IllegalArgumentException("Unable to print PDF, no pages found");
        }
        PDFPage page = pdfFile.getPage(0);
        Rectangle2D r = page.getBBox();
        x = (float)r.getX();
        y = (float)r.getY();
        w = page.getWidth() * 25.4f / 72.0f;
        h = page.getHeight() * 25.4f / 72.0f;
        MediaPrintableArea requestedArea = null;
        if (w > h) {
            System.out.println("is landscape");
            aset.add(OrientationRequested.REVERSE_LANDSCAPE);
            requestedArea = new MediaPrintableArea(0, 0, 25, 60, 1000);
            aset.add(requestedArea);
        } else {
            System.out.println("is portrait");
            aset.add(OrientationRequested.REVERSE_PORTRAIT);
            requestedArea = new MediaPrintableArea(0, 0, 60, 25, 1000);
            aset.add(requestedArea);
        }
        MediaPrintableArea[] supportedAreas = (MediaPrintableArea[])printer.getSupportedAttributeValues(MediaPrintableArea.class, null, aset);
        if (supportedAreas != null) {
            for (MediaPrintableArea area : supportedAreas) {
                boolean areaFound = this.fitsInArea(requestedArea, area);
                if (!areaFound) continue;
                int unit = 1000;
                float yt = requestedArea.getY(1000) + area.getHeight(1000) - requestedArea.getHeight(1000);
                MediaPrintableArea a = new MediaPrintableArea(requestedArea.getX(1000), yt, requestedArea.getWidth(1000), requestedArea.getHeight(1000), 1000);
                aset.remove(requestedArea);
                aset.add(a);
                break;
            }
        }
        this.dpjob.print(new SimpleDoc(pages, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null), aset);
        return true;
    }

    private boolean fitsInArea(MediaPrintableArea inner, MediaPrintableArea outer) {
        if (inner == null || outer == null) {
            return false;
        }
        int unit = 1000;
        return inner.getWidth(1000) <= outer.getWidth(1000) && inner.getHeight(1000) <= outer.getHeight(1000);
    }
}

