/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.util;

import ch.icit.util.DeepCopy;
import ch.icit.util.DeepCopyCallbackHandler;
import ch.icit.util.FieldAccessMode;
import ch.icit.util.FieldFilter;
import ch.icit.util.Invoker;
import ch.icit.util.InvokerException;
import java.lang.reflect.Field;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedDeepCopier {
    static final Logger log = LoggerFactory.getLogger(ExtendedDeepCopier.class);
    private final Map<Class<?>, Map<String, Field>> fieldCache = new HashMap();
    final Map<Object, Object> cache;
    final Set<Object> createdInstances;
    private final FieldAccessMode fieldAccessMode;
    private final Map<Class<?>, Class<?>> targetClassMap;
    private final Set<Field> fieldsToSkip;
    private final Set<Class<?>> ensureCached;
    private final DeepCopyCallbackHandler callbackHandler;
    private final FieldFilter fieldFilter;
    private Set<Object> finishedObjects;

    public boolean isSkipped(Field field) {
        DeepCopy deepCopy = field.getAnnotation(DeepCopy.class);
        if (deepCopy != null) {
            return deepCopy.skip();
        }
        return this.fieldsToSkip.contains(field);
    }

    private boolean deepCopy(Object sourceObject, Field field) throws InvokerException {
        return !this.isSkipped(field) && this.callbackHandler.deepCopy(sourceObject, field);
    }

    public ExtendedDeepCopier(final DeepCopyCallbackHandler callbackHandler, FieldAccessMode fieldAccessMode) {
        this.callbackHandler = callbackHandler;
        callbackHandler.init(this);
        this.fieldFilter = new FieldFilter(){

            @Override
            public boolean isFieldValid(Field field) {
                return !ExtendedDeepCopier.this.isSkipped(field) && callbackHandler.copyField(field);
            }
        };
        this.fieldAccessMode = fieldAccessMode;
        this.cache = new HashMap<Object, Object>();
        this.createdInstances = new HashSet<Object>();
        this.targetClassMap = new HashMap();
        this.fieldsToSkip = new HashSet<Field>();
        this.ensureCached = new HashSet();
    }

    public List<?> clone(List<?> list) throws InvokerException {
        return (List)this.clone((Collection<?>)list);
    }

    public Set<?> clone(Set<?> set) throws InvokerException {
        return (Set)this.clone((Collection<?>)set);
    }

    public Collection<?> clone(Collection<?> collection) throws InvokerException {
        if (collection == null) {
            return null;
        }
        try {
            Collection c = (Collection)collection.getClass().newInstance();
            for (Object o : collection) {
                c.add(this.clone(o));
            }
            return c;
        }
        catch (InstantiationException e) {
            throw new InvokerException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new InvokerException(e.getMessage(), e);
        }
    }

    public Map<?, ?> clone(Map<?, ?> map) throws InvokerException {
        if (map == null) {
            return null;
        }
        try {
            Map m = (Map)map.getClass().newInstance();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                m.put(this.clone(entry.getKey()), this.clone(entry.getValue()));
            }
            return m;
        }
        catch (InstantiationException e) {
            throw new InvokerException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new InvokerException(e.getMessage(), e);
        }
    }

    public Object clone(Object object) throws InvokerException {
        if (object == null) {
            return null;
        }
        if (object instanceof Collection) {
            return this.clone((Collection)object);
        }
        if (object instanceof Map) {
            return this.clone((Map)object);
        }
        Class<?> targetClass = this.getTargetClass(object);
        if (Invoker.isPrimitiveType(targetClass) || Enum.class.isAssignableFrom(targetClass)) {
            this.validateAssignable(object, targetClass);
            return object;
        }
        if (String.class.isAssignableFrom(targetClass)) {
            this.validateAssignable(object, targetClass);
            return new String((String)object);
        }
        if (Date.class.isAssignableFrom(targetClass)) {
            this.validateAssignable(object, targetClass);
            try {
                return targetClass.getConstructor(Long.class).newInstance(((Date)object).getTime());
            }
            catch (Exception e) {
                throw new InvokerException("Failed to clone date object (" + e.getMessage() + ")", e);
            }
        }
        if (this.cache.containsKey(object)) {
            log.debug("Try to get Object " + object.getClass().getCanonicalName() + " from cache instead of clone");
        }
        if (this.createdInstances.contains(object)) {
            this.validateAssignable(object, targetClass);
            return object;
        }
        this.checkCache(object);
        return this.clone(object, this.createCopy(object), true);
    }

    private void validateAssignable(Object object, Class<?> targetClass) throws InvokerException {
        if (!targetClass.isAssignableFrom(object.getClass())) {
            throw new InvokerException("Incompatible target class '" + targetClass + "' for object '" + object + "'!");
        }
    }

    private <R> R clone(Object sourceObject, R targetObject, boolean clone) throws InvokerException {
        if (sourceObject instanceof Collection) {
            log.debug("  the object is an instance of 'Collection'");
            Collection sourceCollection = (Collection)sourceObject;
            log.debug("    source collection size: " + sourceCollection.size());
            Collection targetCollection = (Collection)targetObject;
            assert (targetCollection.size() == 0);
            int i = 0;
            for (Object so : sourceCollection) {
                assert (targetCollection.size() == i);
                log.debug("      cloning obj " + ++i);
                Object to = clone ? this.clone(so) : (this.cache.containsKey(so) ? this.cache.get(so) : so);
                int colSize = targetCollection.size();
                assert (colSize == i - 1);
                targetCollection.add(to);
                assert (colSize == targetCollection.size() - 1);
            }
            log.debug("    target collection size after cloning: " + targetCollection.size());
            assert (sourceCollection.size() == targetCollection.size());
            return (R)targetCollection;
        }
        if (sourceObject instanceof Map) {
            log.debug("  the object is an instance of 'Map'");
            Map targetMap = (Map)targetObject;
            Iterator iterator = ((Map)sourceObject).entrySet().iterator();
            while (iterator.hasNext()) {
                Object key;
                Map.Entry obj;
                Map.Entry entry = obj = iterator.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                Object object = clone ? this.clone(k) : (key = this.cache.containsKey(k) ? this.cache.get(k) : k);
                Object value = clone ? this.clone(v) : (this.cache.containsKey(v) ? this.cache.get(v) : v);
                targetMap.put(key, value);
            }
            return (R)targetMap;
        }
        if (clone && targetObject != null) {
            this.traverseFields(sourceObject, targetObject);
            log.debug("Successfully finished the deep copy of the object " + sourceObject);
            return targetObject;
        }
        return (R)(this.cache.containsKey(sourceObject) ? this.cache.get(sourceObject) : sourceObject);
    }

    private String getID(Field field) {
        String id;
        DeepCopy dc = field.getAnnotation(DeepCopy.class);
        if (dc != null && (id = dc.targetID()) != null && !id.isEmpty()) {
            return id;
        }
        return field.getName();
    }

    private Map<String, Field> getFieldsIndex(Class<?> clazz) {
        Map<String, Field> fields = this.fieldCache.get(clazz);
        if (fields == null) {
            fields = new HashMap<String, Field>();
            this.fieldCache.put(clazz, fields);
            for (Field field : Invoker.getAllFields(clazz, this.fieldFilter)) {
                fields.put(this.getID(field), field);
            }
        }
        return fields;
    }

    private <T> void traverseFields(T sourceObject, T targetObject) throws InvokerException {
        Map<String, Field> targetFields = this.getFieldsIndex(targetObject.getClass());
        for (Field field : Invoker.getAllFields(sourceObject.getClass(), this.fieldFilter)) {
            this.copyField_(sourceObject, field, targetObject, targetFields);
        }
    }

    public <T> void cloneField(T sourceObject, Field sourceField, T targetObject) throws InvokerException {
        this.copyField_(sourceObject, sourceField, targetObject, this.getFieldsIndex(targetObject.getClass()));
    }

    private <T> void copyField_(T sourceObject, Field sourceField, T targetObject, Map<String, Field> targetFieldMap) throws InvokerException {
        Object fieldValue;
        boolean collectionOrMap;
        boolean clone;
        Field targetField = targetFieldMap.get(this.getID(sourceField));
        if (targetField == null) {
            return;
        }
        Class<?> targetFieldType = targetField.getType();
        if (!targetFieldType.isAssignableFrom(targetFieldType)) {
            return;
        }
        Object sourceFieldObject = Invoker.getFieldValue(sourceField, sourceObject, null, this.fieldAccessMode == FieldAccessMode.METHOD);
        if (sourceFieldObject == null) {
            return;
        }
        Class<?> sourceFieldClass = sourceFieldObject.getClass();
        if (Invoker.isPrimitiveType(sourceFieldClass) || Enum.class.isAssignableFrom(sourceFieldClass) || String.class.isAssignableFrom(sourceFieldClass) || Date.class.isAssignableFrom(sourceFieldClass)) {
            this.checkType(sourceFieldObject, targetField, targetFieldType);
            Invoker.setFieldValue(targetField, sourceFieldObject, targetObject, this.fieldAccessMode == FieldAccessMode.METHOD);
            return;
        }
        if (this.deepCopy(sourceObject, sourceField)) {
            log.debug("    cloning the field '" + sourceField.getName() + "' ...");
            clone = true;
        } else {
            log.debug("    the field '" + sourceField.getName() + "' was not selected for a deep copy ... copying it's value ...");
            clone = false;
        }
        boolean bl = collectionOrMap = Collection.class.isAssignableFrom(sourceFieldClass) || Map.class.isAssignableFrom(sourceFieldClass);
        if (!collectionOrMap && this.cache.containsKey(sourceFieldObject)) {
            fieldValue = this.cache.get(sourceFieldObject);
        } else if (!collectionOrMap && this.createdInstances.contains(sourceFieldObject)) {
            fieldValue = sourceFieldObject;
        } else {
            Object targetFieldObject = this.getTargetObject(targetObject, targetField, sourceFieldObject, clone);
            fieldValue = this.clone(sourceFieldObject, targetFieldObject, clone);
        }
        this.checkType(fieldValue, targetField, targetFieldType);
        Invoker.setFieldValue(targetField, fieldValue, targetObject, this.fieldAccessMode == FieldAccessMode.METHOD);
        this.callbackHandler.fieldCopied(sourceField, targetField, sourceObject, targetObject, sourceFieldObject, fieldValue);
        log.debug("successfully copied the field '" + sourceField.getName() + "'");
    }

    private Object getTargetObject(Object targetObject, Field targetField, Object sourceFieldObject, boolean clone) throws InvokerException {
        Class<?> fieldType = targetField.getType();
        if (Collection.class.isAssignableFrom(fieldType) || Map.class.isAssignableFrom(fieldType)) {
            Object targetContainer = Invoker.getFieldValue(targetField, targetObject, null, this.fieldAccessMode == FieldAccessMode.METHOD);
            if (targetContainer == null) {
                throw new InvokerException("The field '" + targetField.getName() + "' of the Class '" + targetObject.getClass().getSimpleName() + "' is not initialized! Every container object must be initialized in the constructor!");
            }
            if (targetContainer instanceof Collection) {
                ((Collection)targetContainer).clear();
            } else if (targetContainer instanceof Map) {
                ((Map)targetContainer).clear();
            }
            return targetContainer;
        }
        this.checkCache(sourceFieldObject);
        return clone ? this.createCopy(sourceFieldObject) : null;
    }

    private void checkCache(Object object) throws InvokerException {
        if (this.ensureCached.contains(object.getClass())) {
            throw new InvokerException("Object '" + object + "' of type '" + (object != null ? object.getClass().getSimpleName() : null) + "' was not found in cache!");
        }
    }

    private void checkType(Object object, Field targetField, Class<?> targetFieldType) throws InvokerException {
        if (object != null && !Invoker.getWrapperClass(targetFieldType).isInstance(object)) {
            throw new InvokerException("Invalid type (" + object.getClass().getSimpleName() + ") for field '" + targetField.getDeclaringClass().getSimpleName() + "." + targetField.getName() + "'!");
        }
    }

    private Object getKeyForValue(Object value) {
        for (Map.Entry<Object, Object> e : this.cache.entrySet()) {
            if (!e.getValue().equals(value)) continue;
            return e.getKey();
        }
        return null;
    }

    private Object createCopy(Object object) throws InvokerException {
        try {
            if (!this.callbackHandler.deepCopy(object)) {
                return null;
            }
            Class<?> targetClass = this.getTargetClass(object);
            log.debug("Instantiating the class '" + targetClass.getSimpleName() + "' ...");
            Object newInstance = targetClass.newInstance();
            if (!this.createdInstances.add(newInstance)) {
                throw new InvokerException("Failed to create a new instance for the object '" + object + "': This object is a clone that was created by this copier instance before!");
            }
            if (this.callbackHandler.cache(targetClass) && !Collection.class.isAssignableFrom(targetClass)) {
                Object newKey = object;
                if (this.cache.containsValue(object)) {
                    newKey = this.getKeyForValue(object);
                }
                this.cache.put(newKey, newInstance);
                this.cache.put(object, newInstance);
            }
            return newInstance;
        }
        catch (InstantiationException e) {
            throw new InvokerException(e);
        }
        catch (IllegalAccessException e) {
            throw new InvokerException(e);
        }
    }

    public void finish() throws InvokerException {
        this.callbackHandler.preFinish();
        this.finishedObjects = new HashSet<Object>();
        for (Object obj : this.cache.values()) {
            this.fixRelationship(obj);
        }
        this.callbackHandler.postFinish();
    }

    private void fixRelationship(Object obj) throws InvokerException {
        if (obj == null || this.finishedObjects.contains(obj)) {
            return;
        }
        if (obj instanceof Collection) {
            for (Object o : (Collection)obj) {
                this.fixRelationship(o);
            }
        } else {
            this.finishedObjects.add(obj);
            for (Field field : Invoker.getAllFields(obj.getClass(), this.fieldFilter)) {
                Object value = Invoker.getFieldValue(field, obj, null, this.fieldAccessMode == FieldAccessMode.METHOD);
                if (value == null || this.finishedObjects.contains(value)) continue;
                this.fixRelationship0(field, obj, value);
                this.callbackHandler.finish(value);
            }
            this.callbackHandler.finish(obj);
        }
    }

    private void fixRelationship0(Field field, Object obj, Object value) throws InvokerException {
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            ArrayList<Object> objToFix = new ArrayList<Object>();
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                Object cur = it.next();
                if (!this.cache.containsKey(cur)) continue;
                objToFix.add(cur);
                it.remove();
            }
            for (Object e : objToFix) {
                Object newValue = this.cache.get(e);
                log.debug("fixed relationship of field '" + field.getDeclaringClass().getSimpleName() + "." + field.getName() + "'. Old value: " + e + ", new value: " + newValue);
                collection.add(newValue);
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            HashMap entriesToFix = new HashMap();
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Object newVal;
                Map.Entry entry = it.next();
                Object k = entry.getKey();
                Object v = entry.getValue();
                Object object = newVal = this.cache.containsKey(v) ? this.cache.get(v) : v;
                if (this.cache.containsKey(k)) {
                    entriesToFix.put(this.cache.get(k), newVal);
                    it.remove();
                    continue;
                }
                entry.setValue(newVal);
            }
            for (Map.Entry entry : entriesToFix.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry entry : map.entrySet()) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                this.fixRelationship(k);
                this.fixRelationship(v);
            }
        } else if (this.cache.containsKey(value)) {
            Object newValue = this.cache.get(value);
            this.checkType(newValue, field, field.getType());
            Invoker.setFieldValue(field, newValue, obj, this.fieldAccessMode == FieldAccessMode.METHOD);
            log.debug("fixed relationship of field '" + field.getDeclaringClass().getSimpleName() + "." + field.getName() + "'. Old value: " + value + ", new value: " + newValue);
        }
    }

    public void addTargetClassMapping(Class<?> source, Class<?> target) {
        this.targetClassMap.put(source, target);
    }

    public void ensureCached(Class<?> ... clazzes) {
        for (Class<?> c : clazzes) {
            this.ensureCached.add(c);
        }
    }

    private Class<?> getTargetClass(Object object) {
        if (object == null) {
            return null;
        }
        return this.getTargetClass(object.getClass());
    }

    private Class<?> getTargetClass(Class<?> source) {
        return this.targetClassMap.containsKey(source) ? this.targetClassMap.get(source) : source;
    }

    public void skipField(Class<?> clazz, String fieldName) throws InvokerException {
        this.fieldsToSkip.add(Invoker.getField(clazz, fieldName));
    }

    public void skipField(Field field) {
        this.fieldsToSkip.add(field);
    }

    public Map<Class<?>, Class<?>> getTargetClassMap() {
        return this.targetClassMap;
    }

    public void putInCache(Object oldObj, Object newObj) throws InvokerException {
        if (oldObj == null) {
            throw new InvokerException("Failed to put object in cache: the key is null (value = '" + newObj + "')!");
        }
        if (newObj == null) {
            throw new InvokerException("Failed to put object in cache: the value is null (key = '" + oldObj + "')!");
        }
        this.cache.put(oldObj, newObj);
    }

    public void putInCache(Map<?, ?> objectMap) throws InvokerException {
        for (Map.Entry<?, ?> entry : objectMap.entrySet()) {
            this.putInCache(entry.getKey(), entry.getValue());
        }
    }

    public Map<Object, Object> getCache() {
        return this.getCache(null);
    }

    public <T> Map<T, Object> getCache(Class<T> filter) {
        if (filter == null) {
            return this.cache;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Map.Entry<Object, Object> entry : this.cache.entrySet()) {
            if (!filter.isInstance(entry.getKey())) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public Object getFromCache(Object key) {
        return this.cache.get(key);
    }

    public boolean cacheContainsKey(Object key) {
        return this.cache.containsKey(key);
    }

    public boolean cacheContainsValue(Object value) {
        return this.cache.containsValue(value);
    }

    public DeepCopyCallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }
}

